/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.core;

public class Value {
    private Filled filled;
    private String s = null;
    private Long l = null;
    private Double d = null;

    public Value(String p) {
        this.filled = Filled.STRING;
        this.s = p;
    }

    public Value(Long p) {
        this.filled = Filled.LONG;
        this.l = p;
    }

    public Value(Double p) {
        this.filled = Filled.DOUBLE;
        this.d = p;
    }

    public String getString() {
        switch (this.filled) {
            case STRING: {
                return this.s;
            }
            case LONG: {
                return this.l == null ? null : Long.toString(this.l);
            }
            case DOUBLE: {
                return this.d == null ? null : Double.toString(this.d);
            }
        }
        return null;
    }

    public Long getLong() {
        switch (this.filled) {
            case STRING: {
                try {
                    return this.s == null ? null : Long.valueOf(Long.parseLong(this.s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case LONG: {
                return this.l;
            }
            case DOUBLE: {
                return this.d == null ? null : Long.valueOf((long)Math.floor(this.d + 0.5));
            }
        }
        return null;
    }

    public Double getDouble() {
        switch (this.filled) {
            case STRING: {
                try {
                    return this.s == null ? null : Double.valueOf(Double.parseDouble(this.s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case LONG: {
                return this.l == null ? null : new Double(this.l.longValue());
            }
            case DOUBLE: {
                return this.d;
            }
        }
        return null;
    }

    public String toString() {
        return "Value{filled=" + (Object)((Object)this.filled) + ", s='" + this.s + '\'' + ", l=" + this.l + ", d=" + this.d + '}';
    }

    static enum Filled {
        STRING,
        LONG,
        DOUBLE;

    }
}

