/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.hadoop.input;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.hadoop.input.ApacheHttpdLogfileRecordReader;
import nl.basjes.hadoop.input.ParsedRecord;
import nl.basjes.parse.apachehttpdlog.ApacheHttpdLoglineParser;
import nl.basjes.parse.core.exceptions.InvalidDisectorException;
import nl.basjes.parse.core.exceptions.MissingDisectorsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class ApacheHttpdLogfileInputFormat
extends FileInputFormat<LongWritable, MapWritable> {
    private ApacheHttpdLogfileRecordReader theRecordReader;
    private String logFormat = null;
    private final Set<String> requestedFields = new HashSet<String>();

    public static List<String> listPossibleFields(String logformat) throws MissingDisectorsException, InvalidDisectorException, ParseException {
        return new ApacheHttpdLoglineParser<ParsedRecord>(ParsedRecord.class, logformat).getPossiblePaths();
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public Set<String> getRequestedFields() {
        return this.requestedFields;
    }

    public ApacheHttpdLogfileInputFormat() {
    }

    public ApacheHttpdLogfileInputFormat(String newLogformat, Collection<String> newRequestedFields) {
        this.logFormat = newLogformat;
        this.requestedFields.addAll(newRequestedFields);
    }

    public ApacheHttpdLogfileRecordReader createRecordReader() {
        return new ApacheHttpdLogfileRecordReader(this.getLogFormat(), this.getRequestedFields());
    }

    public ApacheHttpdLogfileRecordReader getRecordReader() {
        if (this.theRecordReader == null) {
            this.theRecordReader = this.createRecordReader();
        }
        return this.theRecordReader;
    }

    public RecordReader<LongWritable, MapWritable> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return this.getRecordReader();
    }

    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        return null == codec || codec instanceof SplittableCompressionCodec;
    }
}

