/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.apachehttpdlog.logformat;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.apachehttpdlog.logformat.NamedTokenParser;
import nl.basjes.parse.apachehttpdlog.logformat.Token;
import nl.basjes.parse.apachehttpdlog.logformat.TokenParser;
import nl.basjes.parse.apachehttpdlog.logformat.TokenSorterByStartPos;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Disector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DisectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDisectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpdLogFormatDisector
extends Disector {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpdLogFormatDisector.class);
    private String logFormat = null;
    private List<String> logFormatNames = null;
    private List<String> logFormatTypes = null;
    private String logFormatRegEx = null;
    private Pattern logFormatPattern = null;
    private boolean isUsable = false;
    private List<Token> logFormatTokens;
    private List<String> outputTypes;
    private static final String FIXED_STRING_TYPE = "NONE";
    private final Set<String> requestedFields = new HashSet<String>(16);
    private static final String INPUT_TYPE = "APACHELOGLINE";

    public ApacheHttpdLogFormatDisector(String logFormat) throws ParseException {
        this.setLogFormat(logFormat);
    }

    public ApacheHttpdLogFormatDisector() {
    }

    @Override
    protected void initializeNewInstance(Disector newInstance) {
        if (newInstance instanceof ApacheHttpdLogFormatDisector) {
            ((ApacheHttpdLogFormatDisector)newInstance).setLogFormat(this.logFormat);
        } else {
            LOG.error("============================== WTF == " + newInstance.getClass().getCanonicalName());
        }
    }

    public void setLogFormat(String logformat) {
        this.logFormat = logformat;
        switch (logformat.toLowerCase(Locale.getDefault())) {
            case "common": {
                this.logFormat = "%h %l %u %t \"%r\" %>s %b";
                break;
            }
            case "combined": {
                this.logFormat = "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
                break;
            }
            case "combinedio": {
                this.logFormat = "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" %I %O";
                break;
            }
            case "referer": {
                this.logFormat = "%{Referer}i -> %U";
                break;
            }
            case "agent": {
                this.logFormat = "%{User-agent}i";
                break;
            }
            default: {
                this.logFormat = logformat;
            }
        }
        if (!this.logFormat.equals(logformat)) {
            LOG.debug("Specified logformat \"" + logformat + "\" was mapped to " + this.logFormat);
        }
        this.logFormatTokens = this.parseApacheLogFileDefinition(this.logFormat);
        this.outputTypes = new ArrayList<String>(20);
        for (Token token : this.logFormatTokens) {
            String type = token.getType();
            if (FIXED_STRING_TYPE.equals(type)) continue;
            this.outputTypes.add(token.getType() + ':' + token.getName());
        }
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public String getLogFormatRegEx() {
        return this.logFormatRegEx;
    }

    @Override
    public EnumSet<Casts> prepareForDisect(String inputname, String outputname) {
        this.requestedFields.add(outputname);
        for (Token token : this.logFormatTokens) {
            if (!outputname.equals(token.getName())) continue;
            return token.getCasts();
        }
        return Casts.STRING_ONLY;
    }

    @Override
    public void prepareForRun() throws InvalidDisectorException {
        StringBuilder regex = new StringBuilder(this.logFormatTokens.size() * 16);
        this.logFormatNames = new ArrayList<String>(20);
        this.logFormatTypes = new ArrayList<String>(20);
        regex.append('^');
        for (Token token : this.logFormatTokens) {
            if ("FIXED_STRING".equals(token.getType())) {
                regex.append(Pattern.quote(token.getRegex()));
                continue;
            }
            if (this.requestedFields.contains(token.getName())) {
                this.logFormatNames.add(token.getName());
                this.logFormatTypes.add(token.getType());
                regex.append("(").append(token.getRegex()).append(")");
                continue;
            }
            regex.append("(?:").append(token.getRegex()).append(")");
        }
        regex.append('$');
        this.logFormatRegEx = regex.toString();
        LOG.debug("Source logformat : " + this.logFormat);
        LOG.debug("Used regex       : " + this.logFormatRegEx);
        this.logFormatPattern = Pattern.compile(this.logFormatRegEx);
        this.isUsable = true;
    }

    @Override
    public String getInputType() {
        return INPUT_TYPE;
    }

    @Override
    public List<String> getPossibleOutput() {
        return this.outputTypes;
    }

    @Override
    public void disect(Parsable<?> parsable, String inputname) throws DisectionFailure {
        if (!this.isUsable) {
            throw new DisectionFailure("Disector in unusable state");
        }
        ParsedField line = parsable.getParsableField(INPUT_TYPE, inputname);
        Matcher matcher = this.logFormatPattern.matcher(line.getValue());
        boolean matches = matcher.find();
        if (matches) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String matchedStr = matcher.group(i);
                String matchedName = this.logFormatNames.get(i - 1);
                String matchedType = this.logFormatTypes.get(i - 1);
                if (matchedStr.equals("-")) {
                    matchedStr = null;
                }
                parsable.addDisection(inputname, matchedType, matchedName, matchedStr);
            }
        } else {
            throw new DisectionFailure("The input line :\n" + line.getValue() + "\n" + "does not match the specified apache log format RegEx:\n" + this.logFormatRegEx);
        }
    }

    public static String makeHeaderNamesLowercaseInLogFormat(String logformat) {
        StringBuffer sb = new StringBuffer(logformat.length());
        Pattern p = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = p.matcher(logformat);
        while (m.find()) {
            m.appendReplacement(sb, '{' + m.group(1).toLowerCase() + '}');
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private List<Token> parseApacheLogFileDefinition(String apacheLogFormat) {
        List<TokenParser> tokenParsers = this.createAllTokenParsers();
        ArrayList<Token> tokens = new ArrayList<Token>(50);
        String cleanedApacheLogFormat = ApacheHttpdLogFormatDisector.makeHeaderNamesLowercaseInLogFormat(apacheLogFormat);
        for (TokenParser tokenParser : tokenParsers) {
            List<Token> newTokens = tokenParser.getTokens(cleanedApacheLogFormat);
            if (newTokens == null) continue;
            tokens.addAll(newTokens);
        }
        Collections.sort(tokens, new TokenSorterByStartPos());
        ArrayList<Token> kickTokens = new ArrayList<Token>(50);
        Token prevToken = null;
        for (Token token : tokens) {
            if (prevToken == null) {
                prevToken = token;
                continue;
            }
            if (prevToken.getStartPos() == token.getStartPos()) {
                if (prevToken.getPrio() < token.getPrio()) {
                    kickTokens.add(prevToken);
                } else {
                    kickTokens.add(token);
                    continue;
                }
            }
            prevToken = token;
        }
        tokens.removeAll(kickTokens);
        ArrayList<Token> allTokens = new ArrayList<Token>(50);
        int tokenEnd = 0;
        for (Token token : tokens) {
            int tokenBegin = token.getStartPos();
            if (tokenBegin - tokenEnd > 0) {
                String separator = cleanedApacheLogFormat.substring(tokenEnd, tokenBegin);
                Token fixedStringToken = new Token("FIXED_STRING", FIXED_STRING_TYPE, null, separator, tokenBegin, tokenBegin - tokenEnd);
                allTokens.add(fixedStringToken);
            }
            allTokens.add(token);
            tokenEnd = tokenBegin + token.getLength();
        }
        int apacheLogFormatLength = cleanedApacheLogFormat.length();
        if (tokenEnd < apacheLogFormatLength) {
            String separator = cleanedApacheLogFormat.substring(tokenEnd);
            Token fixedStringToken = new Token("FIXED_STRING", FIXED_STRING_TYPE, null, separator, tokenEnd, cleanedApacheLogFormat.length() - tokenEnd);
            allTokens.add(fixedStringToken);
        }
        return allTokens;
    }

    private List<TokenParser> createAllTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenParser("%%", "FIXED_STRING", FIXED_STRING_TYPE, null, "%"));
        parsers.add(new TokenParser("%a", "connection.client.ip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("%A", "connection.server.ip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("%B", "response.body.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%b", "response.body.bytesclf", "BYTES", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}C", "request.cookies.", "HTTP.COOKIE", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%D", "server.process.time", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}e", "server.environment.", "VARIABLE", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%f", "server.filename", "FILENAME", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%h", "connection.client.host", "IP", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%H", "request.protocol", "PROTOCOL", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}i", "request.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%k", "connection.keepalivecount", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%l", "connection.client.logname", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.add(new TokenParser("%m", "request.method", "HTTP.METHOD", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}n", "server.module_note.", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-]*)\\}o", "response.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%p", "request.server.port.canonical", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{canonical}p", "connection.server.port.canonical", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{local}p", "connection.server.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{remote}p", "connection.client.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%P", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{pid}P", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{tid}P", "connection.server.child.threadid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%{hextid}P", "connection.server.child.hexthreadid", "NUMBER", Casts.STRING_OR_LONG, "[0-9a-fA-F]*|-"));
        parsers.add(new TokenParser("%q", "request.querystring", "HTTP.QUERYSTRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%r", "request.firstline", "HTTP.FIRSTLINE", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%R", "request.handler", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%s", "request.status.original", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%>s", "request.status.last", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%t", "request.receive.time", "TIME.STAMP", Casts.STRING_ONLY, "\\[[0-3][0-9]/(?:[A-Z][a-z][a-z])/2[0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9]0\\]"));
        parsers.add(new NamedTokenParser("\\%\\{([^\\}]*)\\}t", "", "", null, ""){

            @Override
            public Token getNextToken(String logformat, int startOffset) {
                if (super.getNextToken(logformat, startOffset) != null) {
                    throw new UnsupportedOperationException("%{format}t has not been implemented yet");
                }
                return null;
            }
        });
        parsers.add(new TokenParser("%T", "response.server.processing.time", "SECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("%u", "connection.client.user", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%U", "request.urlpath", "URI", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("%v", "connection.server.name.canonical", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%V", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%X", "response.connection.status", "HTTP.CONNECTSTATUS", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("%I", "request.bytes", "BYTES", Casts.STRING_OR_LONG, "[1-9]|[1-9][0-9]*"));
        parsers.add(new TokenParser("%O", "response.bytes", "BYTES", Casts.STRING_OR_LONG, "[1-9]|[1-9][0-9]*"));
        parsers.add(new TokenParser("%{cookie}i", "request.cookies", "HTTP.COOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{set-cookie}o", "response.cookies", "HTTP.SETCOOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{user-agent}i", "request.user-agent", "HTTP.USERAGENT", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("%{referer}i", "request.referer", "HTTP.URI", Casts.STRING_ONLY, ".*", 1));
        return parsers;
    }
}

