/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.nginxmodules;

import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.NginxModule;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.NamedTokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;

public class CoreLogModule
implements NginxModule {
    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenParser("$bytes_sent", "response.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$bytes_received", "request.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$connection", "connection.serial_number", "NUMBER", Casts.STRING_OR_LONG, "[0-9]+|-", -1));
        parsers.add(new TokenParser("$connection_requests", "connection.requestnr", "NUMBER", Casts.STRING_OR_LONG, "[0-9]+|-"));
        parsers.add(new TokenParser("$msec", "request.receive.time.epoch", "TIME.EPOCH_SECOND_MILLIS", Casts.STRING_ONLY, "[0-9]+\\.[0-9][0-9][0-9]"));
        parsers.add(new TokenParser("$status", "request.status.last", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$time_iso8601", "request.receive.time", "TIME.ISO8601", Casts.STRING_ONLY, "[1-9][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]T[0-9][0-9]:[0-9][0-9]:[0-9][0-9][\\+|\\-][0-9][0-9]:[0-9][0-9]"));
        parsers.add(new TokenParser("$time_local", "request.receive.time", "TIME.STAMP", Casts.STRING_ONLY, "[0-3][0-9]/(?:[a-zA-Z][a-zA-Z][a-zA-Z])/[1-9][0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9][0-9]"));
        parsers.add(new NamedTokenParser("\\$arg_([a-z0-9\\-\\_]*)", "request.firstline.uri.query.", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$is_args", "request.firstline.uri.is_args", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$args", "request.firstline.uri.query", "HTTP.QUERYSTRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$query_string", "request.firstline.uri.query", "HTTP.QUERYSTRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$body_bytes_sent", "response.body.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$content_length", "request.header.content_length", "HTTP.HEADER", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$content_type", "request.header.content_type", "HTTP.HEADER", Casts.STRING_ONLY, ".*?"));
        parsers.add(new NamedTokenParser("\\$cookie_([a-z0-9\\-_]*)", "request.cookies.", "HTTP.COOKIE", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$document_root", "request.firstline.document_root", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$realpath_root", "request.firstline.realpath_root", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$host", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*", -1));
        parsers.add(new TokenParser("$hostname", "connection.client.host", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\$http_([a-z0-9\\-_]*)", "request.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$http_user_agent", "request.user-agent", "HTTP.USERAGENT", Casts.STRING_ONLY, ".*?", 1));
        parsers.add(new TokenParser("$http_referer", "request.referer", "HTTP.URI", Casts.STRING_ONLY, "[^\\s]*", 1));
        parsers.add(new TokenParser("$https", "connection.https", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenFormatDissector.NotImplementedTokenParser("$limit_rate", "nginx_parameter_not_intended_for_logging", "[^\\s]*", 0));
        parsers.add(new TokenParser("$nginx_version", "server.nginx.version", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$pid", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$protocol", "connection.protocol", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$pipe", "connection.nginx.pipe", "STRING", Casts.STRING_ONLY, "."));
        parsers.add(new TokenParser("$proxy_protocol_addr", "connection.client.proxy.host", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("$proxy_protocol_port", "connection.client.proxy.port", "PORT", Casts.STRING_OR_LONG, "[0-9]+|-"));
        parsers.add(new TokenParser("$remote_addr", "connection.client.host", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        String formatHexByte = "\\\\x[0-9a-fA-F][0-9a-fA-F]";
        parsers.add(new TokenParser("$binary_remote_addr", "connection.client.host", "IP_BINARY", Casts.STRING_OR_LONG, formatHexByte + formatHexByte + formatHexByte + formatHexByte));
        parsers.add(new TokenParser("$remote_port", "connection.client.port", "PORT", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$remote_user", "connection.client.user", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$request", "request.firstline", "HTTP.FIRSTLINE", Casts.STRING_ONLY, "[^\\s]* [^\\s]* [^\\s]*", -2));
        parsers.add(new TokenFormatDissector.NotImplementedTokenParser("$request_body", "nginx_parameter_not_intended_for_logging", ".*?", -1));
        parsers.add(new TokenFormatDissector.NotImplementedTokenParser("$request_body_file", "nginx_parameter_not_intended_for_logging", ".*?", -1));
        parsers.add(new TokenParser("$request_completion", "request.completion", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$request_filename", "server.filename", "FILENAME", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$request_length", "request.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]+|-"));
        parsers.add(new TokenParser("$request_method", "request.firstline.method", "HTTP.METHOD", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$request_time", "response.server.processing.time", "SECOND_MILLIS", Casts.STRING_ONLY, "[0-9]+\\.[0-9]+"));
        parsers.add(new TokenParser("$request_uri", "request.firstline.uri", "HTTP.URI", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$request_id", "request.id", "STRING", Casts.STRING_ONLY, "[0-9a-fA-F]+"));
        parsers.add(new TokenParser("$uri", "request.firstline.uri.normalized", "HTTP.URI", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$document_uri", "request.firstline.uri.normalized", "HTTP.URI", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$scheme", "request.firstline.uri.protocol", "HTTP.PROTOCOL", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\$sent_http_([a-z0-9\\-_]*)", "response.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*?"));
        parsers.add(new NamedTokenParser("\\$sent_trailer_([a-z0-9\\-_]*)", "response.trailer.", "HTTP.TRAILER", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$server_addr", "connection.server.ip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("$server_name", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$server_port", "connection.server.port", "PORT", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$server_protocol", "request.firstline.protocol", "HTTP.PROTOCOL_VERSION", Casts.STRING_OR_LONG, "[^\\s]*"));
        parsers.add(new TokenParser("$session_time", "connection.session.time", "SECOND_MILLIS", Casts.STRING_ONLY, "[0-9]+\\.[0-9]+"));
        parsers.add(new TokenParser("$tcpinfo_rtt", "connection.tcpinfo.rtt", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]+", -1));
        parsers.add(new TokenParser("$tcpinfo_rttvar", "connection.tcpinfo.rttvar", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$tcpinfo_snd_cwnd", "connection.tcpinfo.send.cwnd", "BYTES", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new TokenParser("$tcpinfo_rcv_space", "connection.tcpinfo.receive.space", "BYTES", Casts.STRING_OR_LONG, "[0-9]+"));
        parsers.add(new NamedTokenParser("\\$([a-z0-9\\-\\_]*)", "nginx.unknown.", "UNKNOWN_NGINX_VARIABLE", Casts.STRING_ONLY, "[^\\s]*", -10).setWarningMessageWhenUsed("Found unknown variable \"${}\" that was mapped to \"{}\". It is assumed the values are text that cannot contain a whitespace."));
        return parsers;
    }
}

