/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.tokenformat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.Token;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenOutputField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenParser
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TokenParser.class);
    public static final String FORMAT_DIGIT = "[0-9]";
    public static final String FORMAT_NUMBER = "[0-9]+";
    public static final String FORMAT_CLF_NUMBER = "[0-9]+|-";
    public static final String FORMAT_HEXDIGIT = "[0-9a-fA-F]";
    public static final String FORMAT_HEXNUMBER = "[0-9a-fA-F]+";
    public static final String FORMAT_CLF_HEXNUMBER = "[0-9a-fA-F]+|-";
    public static final String FORMAT_NON_ZERO_NUMBER = "[1-9][0-9]*";
    public static final String FORMAT_CLF_NON_ZERO_NUMBER = "[1-9][0-9]*|-";
    public static final String FORMAT_EIGHT_BIT_DECIMAL = "(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    public static final String FORMAT_IPV4 = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    public static final String FORMAT_IPV6 = ":?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}";
    public static final String FORMAT_IP = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}";
    public static final String FORMAT_CLF_IP = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-";
    public static final String FORMAT_STRING = ".*?";
    public static final String FORMAT_NO_SPACE_STRING = "[^\\s]*";
    public static final String FIXED_STRING = "FIXED_STRING";
    public static final String FORMAT_STANDARD_TIME_US = "[0-3][0-9]/(?:[a-zA-Z][a-zA-Z][a-zA-Z])/[1-9][0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9][0-9]";
    public static final String FORMAT_STANDARD_TIME_ISO8601 = "[1-9][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]T[0-9][0-9]:[0-9][0-9]:[0-9][0-9][\\+|\\-][0-9][0-9]:[0-9][0-9]";
    public static final String FORMAT_NUMBER_DECIMAL = "[0-9]+\\.[0-9]+";
    public static final String FORMAT_NUMBER_OPTIONAL_DECIMAL = "[0-9]+(?:\\.[0-9]+)?";
    private final String logFormatToken;
    private List<TokenOutputField> outputFields = new ArrayList<TokenOutputField>();
    private final String regex;
    private final int prio;
    protected String warningMessageWhenUsed;
    private final Dissector customDissector;

    public TokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex) {
        this(nLogFormatToken, nValueName, nValueType, nCasts, nRegex, 10);
    }

    public TokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex, int nPrio) {
        this(nLogFormatToken, nValueName, nValueType, nCasts, nRegex, nPrio, null);
    }

    public TokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex, int nPrio, Dissector nCustomDissector) {
        this.logFormatToken = nLogFormatToken;
        this.regex = nRegex;
        this.prio = nPrio;
        this.customDissector = nCustomDissector;
        this.addOutputField(nValueType, nValueName, nCasts);
    }

    public TokenParser(String nLogFormatToken, String nRegex) {
        this(nLogFormatToken, nRegex, 0, null);
    }

    public TokenParser(String nLogFormatToken, String nRegex, int nPrio) {
        this(nLogFormatToken, nRegex, nPrio, null);
    }

    public TokenParser(String nLogFormatToken, String nRegex, int nPrio, Dissector nCustomDissector) {
        this.logFormatToken = nLogFormatToken;
        this.regex = nRegex;
        this.prio = nPrio;
        this.customDissector = nCustomDissector;
    }

    public TokenParser addOutputField(String type, String name, EnumSet<Casts> casts) {
        this.outputFields.add(new TokenOutputField(type, name, casts));
        return this;
    }

    public TokenParser addOutputField(String type, String name, EnumSet<Casts> casts, String deprecateFor) {
        this.outputFields.add(new TokenOutputField(type, name, casts).deprecateFor(deprecateFor));
        return this;
    }

    public TokenParser addOutputField(TokenOutputField outputField) {
        this.outputFields.add(outputField);
        return this;
    }

    public TokenParser addOutputFields(List<TokenOutputField> nOutputFields) {
        this.outputFields.addAll(nOutputFields);
        return this;
    }

    public List<TokenOutputField> getOutputFields() {
        return this.outputFields;
    }

    public TokenParser setWarningMessageWhenUsed(String message) {
        this.warningMessageWhenUsed = message;
        return this;
    }

    public String getLogFormatToken() {
        return this.logFormatToken;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getPrio() {
        return this.prio;
    }

    public Dissector getCustomDissector() {
        return this.customDissector;
    }

    public Token getNextToken(String logFormat, int startOffset) {
        int pos = logFormat.indexOf(this.logFormatToken, startOffset);
        if (pos == -1) {
            return null;
        }
        Token token = new Token(this.regex, pos, this.logFormatToken.length(), this.prio).addOutputFields(this.outputFields);
        if (this.warningMessageWhenUsed != null) {
            token.setWarningMessageWhenUsed(this.warningMessageWhenUsed);
        }
        if (!this.addCustomDissector(token, this.outputFields.get(0).getType(), this.outputFields.get(0).getName())) {
            return null;
        }
        return token;
    }

    public List<Token> getTokens(String logFormat) {
        Token token;
        if (StringUtils.isBlank((CharSequence)logFormat)) {
            return null;
        }
        ArrayList<Token> result = new ArrayList<Token>(5);
        int offset = 0;
        while ((token = this.getNextToken(logFormat, offset)) != null) {
            result.add(token);
            offset = token.getStartPos() + token.getLength();
        }
        return result;
    }

    protected boolean addCustomDissector(Token token, String fieldType, String fieldName) {
        if (this.customDissector == null) {
            return true;
        }
        try {
            Dissector dissector = this.customDissector.getNewInstance();
            dissector.setInputType(fieldType);
            if (!dissector.initializeFromSettingsParameter(fieldName)) {
                LOG.error("Unable to INITIALIZE custom dissector for {}:{}", (Object)fieldType, (Object)fieldName);
                return false;
            }
            token.setCustomDissector(dissector);
        }
        catch (Exception e) {
            LOG.error("Unable to add custom dissector for {}:{} because of : {}", new Object[]{fieldType, fieldName, e.getMessage()});
            return false;
        }
        return true;
    }
}

