/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.SimpleDissector;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.Utils;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.NamedTokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;
import nl.basjes.parse.httpdlog.dissectors.translate.ConvertMillisecondsIntoMicroseconds;
import nl.basjes.parse.httpdlog.dissectors.translate.ConvertSecondsWithMillisStringDissector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NginxHttpdLogFormatDissector
extends TokenFormatDissector {
    private static final Logger LOG = LoggerFactory.getLogger(NginxHttpdLogFormatDissector.class);

    public NginxHttpdLogFormatDissector(String logFormat) {
        super(logFormat);
        this.setInputType("HTTPLOGLINE");
    }

    public NginxHttpdLogFormatDissector() {
        this.setInputType("HTTPLOGLINE");
    }

    private void overrideLogFormat(String originalLogformat, String logformat) {
        LOG.debug("Specified logformat \"{}\" was mapped to {}", (Object)originalLogformat, (Object)logformat);
        super.setLogFormat(logformat);
    }

    @Override
    public void setLogFormat(String logformat) {
        switch (logformat.toLowerCase(Locale.getDefault())) {
            case "combined": {
                this.overrideLogFormat(logformat, "$remote_addr - $remote_user [$time_local] \"$request\" $status $body_bytes_sent \"$http_referer\" \"$http_user_agent\"");
                break;
            }
            default: {
                super.setLogFormat(logformat);
            }
        }
    }

    public static boolean looksLikeNginxFormat(String logFormat) {
        if (logFormat.indexOf(36) != -1) {
            return true;
        }
        switch (logFormat.toLowerCase(Locale.getDefault())) {
            case "combined": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String decodeExtractedValue(String tokenName, String value) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (value.equals("-")) {
            return null;
        }
        return value;
    }

    @Override
    protected List<TokenParser> createAllTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenParser("$bytes_sent", "response.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("$connection", "connection.serial_number", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*|-", -1));
        parsers.add(new TokenParser("$connection_requests", "connection.requestnr", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.add(new TokenParser("$msec", "request.receive.time.epoch", "TIME.EPOCH_SECOND_MILLIS", Casts.STRING_ONLY, "[0-9]+\\.[0-9][0-9][0-9]"));
        parsers.add(new TokenParser("$status", "request.status.last", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$time_iso8601", "request.receive.time", "TIME.ISO8601", Casts.STRING_ONLY, "[1-9][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]T[0-9][0-9]:[0-9][0-9]:[0-9][0-9][\\+|\\-][0-9][0-9]:[0-9][0-9]"));
        parsers.add(new TokenParser("$time_local", "request.receive.time", "TIME.STAMP", Casts.STRING_ONLY, "[0-3][0-9]/(?:[a-zA-Z][a-zA-Z][a-zA-Z])/[1-9][0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9][0-9]"));
        parsers.add(new NamedTokenParser("\\$sent_http_([a-z0-9\\-\\_]*)", "response.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\$arg_([a-z0-9\\-\\_]*)", "request.firstline.uri.query.", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$is_args", "request.firstline.uri.is_args", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$args", "request.firstline.uri.query", "HTTP.QUERYSTRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$query_string", "request.firstline.uri.query", "HTTP.QUERYSTRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$body_bytes_sent", "response.body.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("$content_length", "request.header.content_length", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$content_type", "request.header.content_type", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\$cookie_([a-z0-9\\-_]*)", "request.cookies.", "HTTP.COOKIE", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$document_root", "request.firstline.document_root", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$realpath_root", "request.firstline.realpath_root", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$host", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*", -1));
        parsers.add(new TokenParser("$hostname", "connection.client.host", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\$http_([a-z0-9\\-_]*)", "request.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$http_user_agent", "request.user-agent", "HTTP.USERAGENT", Casts.STRING_ONLY, ".*", 1));
        parsers.add(new TokenParser("$http_referer", "request.referer", "HTTP.URI", Casts.STRING_ONLY, "[^\\s]*", 1));
        parsers.add(new TokenParser("$https", "connection.https", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenFormatDissector.NotImplementedTokenParser("$limit_rate", "nginx_parameter_not_intended_for_logging", "[^\\s]*", 0));
        parsers.add(new TokenParser("$nginx_version", "server.nginx.version", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$pid", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("$pipe", "connection.nginx.pipe", "STRING", Casts.STRING_ONLY, "\\.?"));
        parsers.add(new TokenParser("$proxy_protocol_addr", "connection.client.proxy.host", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("$remote_addr", "connection.client.host", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        String formatHexByte = "\\\\x[0-9a-fA-F][0-9a-fA-F]";
        parsers.add(new TokenParser("$binary_remote_addr", "connection.client.host", "IP_BINARY", Casts.STRING_OR_LONG, formatHexByte + formatHexByte + formatHexByte + formatHexByte));
        parsers.add(new TokenParser("$remote_port", "connection.client.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("$remote_user", "connection.client.user", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$request", "request.firstline", "HTTP.FIRSTLINE", Casts.STRING_ONLY, "[^\\s]* [^\\s]* [^\\s]*", -2));
        parsers.add(new TokenFormatDissector.NotImplementedTokenParser("$request_body", "nginx_parameter_not_intended_for_logging", ".*", -1));
        parsers.add(new TokenFormatDissector.NotImplementedTokenParser("$request_body_file", "nginx_parameter_not_intended_for_logging", ".*", -1));
        parsers.add(new TokenParser("$request_completion", "request.completion", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$request_filename", "server.filename", "FILENAME", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$request_length", "request.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.add(new TokenParser("$request_method", "request.firstline.method", "HTTP.METHOD", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$request_time", "response.server.processing.time", "SECOND_MILLIS", Casts.STRING_ONLY, "[0-9]*\\.[0-9]*"));
        parsers.add(new TokenParser("$request_uri", "request.firstline.uri", "HTTP.URI", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$request_id", "request.id", "STRING", Casts.STRING_ONLY, "[0-9a-fA-F]*"));
        parsers.add(new TokenParser("$uri", "request.firstline.uri.normalized", "HTTP.URI", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$document_uri", "request.firstline.uri.normalized", "HTTP.URI", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$scheme", "request.firstline.uri.protocol", "HTTP.PROTOCOL", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\$sent_http_([a-z0-9\\-_]*)", "response.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new TokenParser("$server_addr", "connection.server.ip", "IP", Casts.STRING_OR_LONG, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.add(new TokenParser("$server_name", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$server_port", "connection.server.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("$server_protocol", "request.firstline.protocol", "HTTP.PROTOCOL_VERSION", Casts.STRING_OR_LONG, "[^\\s]*"));
        parsers.add(new TokenParser("$tcpinfo_rtt", "connection.tcpinfo.rtt", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]*", -1));
        parsers.add(new TokenParser("$tcpinfo_rttvar", "connection.tcpinfo.rttvar", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("$tcpinfo_snd_cwnd", "connection.tcpinfo.send.cwnd", "BYTES", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new TokenParser("$tcpinfo_rcv_space", "connection.tcpinfo.receive.space", "BYTES", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.add(new NamedTokenParser("\\$([a-z0-9\\-\\_]*)", "nginx.unknown.", "UNKNOWN_NGINX_VARIABLE", Casts.STRING_ONLY, "[^\\s]*", -10).setWarningMessageWhenUsed("Found unknown variable \"${}\" that was mapped to \"{}\". It is assumed the values are text that cannot contain a whitespace."));
        return parsers;
    }

    @Override
    public <RECORD> void createAdditionalDissectors(Parser<RECORD> parser) {
        super.createAdditionalDissectors(parser);
        parser.addDissector((Dissector)new BinaryIPDissector());
        parser.addDissector((Dissector)new ConvertSecondsWithMillisStringDissector("SECOND_MILLIS", "MILLISECONDS"));
        parser.addDissector((Dissector)new ConvertSecondsWithMillisStringDissector("TIME.EPOCH_SECOND_MILLIS", "TIME.EPOCH"));
        parser.addDissector((Dissector)new ConvertMillisecondsIntoMicroseconds("MILLISECONDS", "MICROSECONDS"));
    }

    @Deprecated
    public static class NotYetImplemented
    extends TokenFormatDissector.NotImplementedTokenParser {
        private static final String FIELD_PREFIX = "nginx_parameter";

        public NotYetImplemented(String nLogFormatToken) {
            super(nLogFormatToken, FIELD_PREFIX, 0);
        }

        public NotYetImplemented(String nLogFormatToken, String regex) {
            super(nLogFormatToken, FIELD_PREFIX, regex, 0);
        }

        public NotYetImplemented(String nLogFormatToken, String regex, int prio) {
            super(nLogFormatToken, FIELD_PREFIX, regex, prio);
        }

        public NotYetImplemented(String nLogFormatToken, int prio) {
            super(nLogFormatToken, FIELD_PREFIX, "[^\" ]*", prio);
        }
    }

    public static class BinaryIPDissector
    extends SimpleDissector {
        private static HashMap<String, EnumSet<Casts>> epochMillisConfig = new HashMap();
        private static final String CAPTURE_HEX_BYTE = "\\\\x([0-9a-fA-F][0-9a-fA-F])";
        Pattern binaryIPPattern = Pattern.compile("\\\\x([0-9a-fA-F][0-9a-fA-F])\\\\x([0-9a-fA-F][0-9a-fA-F])\\\\x([0-9a-fA-F][0-9a-fA-F])\\\\x([0-9a-fA-F][0-9a-fA-F])");

        public BinaryIPDissector() {
            super("IP_BINARY", epochMillisConfig);
        }

        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            Matcher matcher = this.binaryIPPattern.matcher(value.getString());
            if (matcher.matches()) {
                String ip = String.valueOf(Utils.hexCharsToByte(matcher.group(1))) + '.' + String.valueOf(Utils.hexCharsToByte(matcher.group(2))) + '.' + String.valueOf(Utils.hexCharsToByte(matcher.group(3))) + '.' + String.valueOf(Utils.hexCharsToByte(matcher.group(4)));
                parsable.addDissection(inputname, "IP", "", ip);
            }
        }

        static {
            epochMillisConfig.put("IP:", Casts.STRING_OR_LONG);
        }
    }
}

