/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.httpdlog.Utils;
import nl.basjes.parse.httpdlog.dissectors.StrfTimeStampDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.NamedTokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.ParameterizedTokenParser;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenOutputField;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpdLogFormatDissector
extends TokenFormatDissector {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpdLogFormatDissector.class);

    public ApacheHttpdLogFormatDissector(String logFormat) {
        super(logFormat);
        this.setInputType("HTTPLOGLINE");
    }

    public ApacheHttpdLogFormatDissector() {
        this.setInputType("HTTPLOGLINE");
    }

    private void overrideLogFormat(String originalLogformat, String logformat) {
        LOG.debug("Specified logformat \"{}\" was mapped to {}", (Object)originalLogformat, (Object)logformat);
        super.setLogFormat(logformat);
    }

    @Override
    public void setLogFormat(String logformat) {
        switch (logformat.toLowerCase(Locale.getDefault())) {
            case "common": {
                this.overrideLogFormat(logformat, "%h %l %u %t \"%r\" %>s %b");
                break;
            }
            case "combined": {
                this.overrideLogFormat(logformat, "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"");
                break;
            }
            case "combinedio": {
                this.overrideLogFormat(logformat, "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" %I %O");
                break;
            }
            case "referer": {
                this.overrideLogFormat(logformat, "%{Referer}i -> %U");
                break;
            }
            case "agent": {
                this.overrideLogFormat(logformat, "%{User-agent}i");
                break;
            }
            default: {
                super.setLogFormat(logformat);
            }
        }
    }

    public static boolean looksLikeApacheFormat(String logFormat) {
        if (logFormat.indexOf(37) != -1) {
            return true;
        }
        switch (logFormat.toLowerCase(Locale.getDefault())) {
            case "common": 
            case "combined": 
            case "combinedio": 
            case "referer": 
            case "agent": {
                return true;
            }
        }
        return false;
    }

    protected String makeHeaderNamesLowercaseInLogFormat(String logformat) {
        StringBuffer sb = new StringBuffer(logformat.length());
        Pattern p = Pattern.compile("%\\{([^}]*)}([^t])");
        Matcher m = p.matcher(logformat);
        while (m.find()) {
            m.appendReplacement(sb, "%{" + m.group(1).toLowerCase() + '}' + m.group(2));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected String removeModifiersFromLogformat(String tokenLogFormat) {
        return tokenLogFormat.replaceAll("%!?[0-9]{3}(?:,[0-9]{3})*", "%");
    }

    protected String fixTimestampFormat(String tokenLogFormat) {
        return tokenLogFormat.replaceAll("%t", "[%t]");
    }

    @Override
    protected String cleanupLogFormat(String tokenLogFormat) {
        String result = this.removeModifiersFromLogformat(tokenLogFormat);
        result = this.makeHeaderNamesLowercaseInLogFormat(result);
        result = this.fixTimestampFormat(result);
        return result;
    }

    @Override
    public String decodeExtractedValue(String tokenName, String value) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (value.equals("-")) {
            return null;
        }
        if (value.equals("request.firstline") || value.startsWith("request.header.") || value.startsWith("response.header.")) {
            return Utils.decodeApacheHTTPDLogValue(value);
        }
        return value;
    }

    @Override
    protected List<TokenParser> createAllTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenFormatDissector.FixedStringTokenParser("%%", "%"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%a", "connection.client.ip", "IP", Casts.STRING_ONLY, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{c}a", "connection.client.peerip", "IP", Casts.STRING_ONLY, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%A", "connection.server.ip", "IP", Casts.STRING_ONLY, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%B", "response.body.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%b", "response.body.bytes", "BYTESCLF", Casts.STRING_OR_LONG, "[0-9]*|-"));
        this.addExtraOutput(parsers, "%b", new TokenOutputField("BYTES", "response.body.bytesclf", Casts.STRING_OR_LONG).deprecateFor("BYTESCLF:response.body.bytes"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}C", "request.cookies.", "HTTP.COOKIE", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}e", "server.environment.", "VARIABLE", Casts.STRING_ONLY, ".*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%f", "server.filename", "FILENAME", Casts.STRING_ONLY, ".*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%h", "connection.client.host", "IP", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%H", "request.protocol", "PROTOCOL", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}i", "request.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}\\^ti", "request.trailer.", "HTTP.TRAILER", Casts.STRING_ONLY, ".*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%k", "connection.keepalivecount", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%l", "connection.client.logname", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%L", "request.errorlogid", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%m", "request.method", "HTTP.METHOD", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}n", "server.module_note.", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-]*)\\}o", "response.header.", "HTTP.HEADER", Casts.STRING_ONLY, ".*"));
        parsers.add(new NamedTokenParser("\\%\\{([a-z0-9\\-_]*)\\}\\^to", "response.trailer.", "HTTP.TRAILER", Casts.STRING_ONLY, ".*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%p", "request.server.port.canonical", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{canonical}p", "connection.server.port.canonical", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{local}p", "connection.server.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{remote}p", "connection.client.port", "PORT", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%P", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{pid}P", "connection.server.child.processid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{tid}P", "connection.server.child.threadid", "NUMBER", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{hextid}P", "connection.server.child.hexthreadid", "NUMBER", Casts.STRING_OR_LONG, "[0-9a-fA-F]*|-"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%q", "request.querystring", "HTTP.QUERYSTRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%r", "request.firstline", "HTTP.FIRSTLINE", Casts.STRING_ONLY, ".*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%R", "request.handler", "STRING", Casts.STRING_ONLY, ".*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%s", "request.status", "STRING", Casts.STRING_ONLY, "[^\\s]*", 0));
        parsers.addAll(this.createFirstAndLastTokenParsers("%t", "request.receive.time", "TIME.STAMP", Casts.STRING_ONLY, "[0-3][0-9]/(?:[a-zA-Z][a-zA-Z][a-zA-Z])/[1-9][0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9][0-9]"));
        parsers.add(new ParameterizedTokenParser("\\%\\{([^\\}]*%[^\\}]*)\\}t", "request.receive.time", "TIME.STRFTIME_", Casts.STRING_ONLY, ".*", -1, new StrfTimeStampDissector()).setWarningMessageWhenUsed("Only some parts of localized timestamps are supported"));
        parsers.add(new ParameterizedTokenParser("\\%\\{begin:([^\\}]*%[^\\}]*)\\}t", "request.receive.time.begin", "TIME.STRFTIME_", Casts.STRING_ONLY, ".*", 0, new StrfTimeStampDissector()).setWarningMessageWhenUsed("Only some parts of localized timestamps are supported"));
        parsers.add(new ParameterizedTokenParser("\\%\\{end:([^\\}]*%[^\\}]*)\\}t", "request.receive.time.end", "TIME.STRFTIME_", Casts.STRING_ONLY, ".*", 0, new StrfTimeStampDissector()).setWarningMessageWhenUsed("Only some parts of localized timestamps are supported"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{sec}t", "request.receive.time.sec", "TIME.SECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{begin:sec}t", "request.receive.time.begin.sec", "TIME.SECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{end:sec}t", "request.receive.time.end.sec", "TIME.SECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{msec}t", "request.receive.time.msec", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        this.addExtraOutput(parsers, "%{msec}t", new TokenOutputField("TIME.EPOCH", "request.receive.time.begin.msec", Casts.STRING_OR_LONG).deprecateFor("TIME.EPOCH:request.receive.time.msec"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{begin:msec}t", "request.receive.time.begin.msec", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{end:msec}t", "request.receive.time.end.msec", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{usec}t", "request.receive.time.usec", "TIME.EPOCH.USEC", Casts.STRING_OR_LONG, "[0-9]*"));
        this.addExtraOutput(parsers, "%{usec}t", new TokenOutputField("TIME.EPOCH.USEC", "request.receive.time.begin.usec", Casts.STRING_OR_LONG).deprecateFor("TIME.EPOCH.USEC:request.receive.time.usec"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{begin:usec}t", "request.receive.time.begin.usec", "TIME.EPOCH.USEC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{end:usec}t", "request.receive.time.end.usec", "TIME.EPOCH.USEC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{msec_frac}t", "request.receive.time.msec_frac", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        this.addExtraOutput(parsers, "%{msec_frac}t", new TokenOutputField("TIME.EPOCH", "request.receive.time.begin.msec_frac", Casts.STRING_OR_LONG).deprecateFor("TIME.EPOCH:request.receive.time.msec_frac"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{begin:msec_frac}t", "request.receive.time.begin.msec_frac", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{end:msec_frac}t", "request.receive.time.end.msec_frac", "TIME.EPOCH", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{usec_frac}t", "request.receive.time.usec_frac", "TIME.EPOCH.USEC_FRAC", Casts.STRING_OR_LONG, "[0-9]*"));
        this.addExtraOutput(parsers, "%{usec_frac}t", new TokenOutputField("TIME.EPOCH.USEC_FRAC", "request.receive.time.begin.usec_frac", Casts.STRING_OR_LONG).deprecateFor("TIME.EPOCH.USEC_FRAC:request.receive.time.usec_frac"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{begin:usec_frac}t", "request.receive.time.begin.usec_frac", "TIME.EPOCH.USEC_FRAC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{end:usec_frac}t", "request.receive.time.end.usec_frac", "TIME.EPOCH.USEC_FRAC", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%T", "response.server.processing.time", "SECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%D", "response.server.processing.time", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        this.addExtraOutput(parsers, "%D", new TokenOutputField("MICROSECONDS", "server.process.time", Casts.STRING_OR_LONG).deprecateFor("MICROSECONDS:response.server.processing.time"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{us}T", "response.server.processing.time", "MICROSECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{ms}T", "response.server.processing.time", "MILLISECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{s}T", "response.server.processing.time", "SECONDS", Casts.STRING_OR_LONG, "[0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%u", "connection.client.user", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%U", "request.urlpath", "URI", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%v", "connection.server.name.canonical", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%V", "connection.server.name", "STRING", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%X", "response.connection.status", "HTTP.CONNECTSTATUS", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%I", "request.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%O", "response.bytes", "BYTES", Casts.STRING_OR_LONG, "[0-9]*|-"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%S", "total.bytes", "BYTES", Casts.STRING_OR_LONG, "[1-9]|[1-9][0-9]*"));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{cookie}i", "request.cookies", "HTTP.COOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{set-cookie}o", "response.cookies", "HTTP.SETCOOKIES", Casts.STRING_ONLY, ".*", 1));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{user-agent}i", "request.user-agent", "HTTP.USERAGENT", Casts.STRING_ONLY, ".*", 1));
        parsers.addAll(this.createFirstAndLastTokenParsers("%{referer}i", "request.referer", "HTTP.URI", Casts.STRING_ONLY, ".*", 1));
        return parsers;
    }

    private void addExtraOutput(List<TokenParser> parsers, String nLogFormatToken, TokenOutputField tokenOutputField) {
        for (TokenParser tokenParser : parsers) {
            if (!tokenParser.getLogFormatToken().equals(nLogFormatToken)) continue;
            tokenParser.addOutputField(tokenOutputField);
            return;
        }
    }

    private List<TokenParser> createFirstAndLastTokenParsers(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex) {
        return this.createFirstAndLastTokenParsers(nLogFormatToken, nValueName, nValueType, nCasts, nRegex, 0);
    }

    private List<TokenParser> createFirstAndLastTokenParsers(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex, int nPrio) {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(3);
        switch (nLogFormatToken) {
            case "%s": 
            case "%U": 
            case "%T": 
            case "%{us}T": 
            case "%{ms}T": 
            case "%{s}T": 
            case "%D": 
            case "%r": {
                parsers.add(new TokenParser(nLogFormatToken, nRegex, nPrio).addOutputField(nValueType, nValueName, nCasts).addOutputField(nValueType, nValueName + ".original", nCasts));
                break;
            }
            default: {
                parsers.add(new TokenParser(nLogFormatToken, nRegex, nPrio).addOutputField(nValueType, nValueName, nCasts).addOutputField(nValueType, nValueName + ".last", nCasts));
            }
        }
        parsers.add(new TokenParser(nLogFormatToken.replaceFirst("%", "%<"), nRegex, nPrio).addOutputField(nValueType, nValueName + ".original", nCasts));
        parsers.add(new TokenParser(nLogFormatToken.replaceFirst("%", "%>"), nRegex, nPrio).addOutputField(nValueType, nValueName + ".last", nCasts));
        return parsers;
    }
}

