/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;

public class ResponseSetCookieDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.SETCOOKIE";
    private static final DateTimeFormatter[] DATE_FORMATS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("EEE',' dd-MMM-yyyy HH:mm:ss zzz").withZone(ZoneOffset.UTC), DateTimeFormatter.ofPattern("EEE',' dd MMM yyyy HH:mm:ss zzz").withZone(ZoneOffset.UTC), DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z").withZone(ZoneOffset.UTC)};

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("STRING:value");
        result.add("STRING:expires");
        result.add("TIME.EPOCH:expires");
        result.add("STRING:path");
        result.add("STRING:domain");
        result.add("STRING:comment");
        return result;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name;
        switch (name = this.extractFieldName(inputname, outputname)) {
            case "value": {
                return Casts.STRING_ONLY;
            }
            case "expires": {
                return Casts.STRING_OR_LONG;
            }
            case "path": {
                return Casts.STRING_ONLY;
            }
            case "domain": {
                return Casts.STRING_ONLY;
            }
            case "comment": {
                return Casts.STRING_ONLY;
            }
        }
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        String[] parts = fieldValue.split(";");
        block12: for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            String[] keyValue = part.split("=", 2);
            String key = keyValue[0].trim();
            String value = "";
            if (keyValue.length == 2) {
                value = keyValue[1].trim();
            }
            if (i == 0) {
                parsable.addDissection(inputname, "STRING", "value", value);
                continue;
            }
            switch (key) {
                case "expires": {
                    Long expires = this.parseExpire(value);
                    parsable.addDissection(inputname, "STRING", "expires", expires / 1000L);
                    parsable.addDissection(inputname, "TIME.EPOCH", "expires", expires);
                    continue block12;
                }
                case "domain": {
                    parsable.addDissection(inputname, "STRING", "domain", value);
                    continue block12;
                }
                case "comment": {
                    parsable.addDissection(inputname, "STRING", "comment", value);
                    continue block12;
                }
                case "path": {
                    parsable.addDissection(inputname, "STRING", "path", value);
                    continue block12;
                }
            }
        }
    }

    private Long parseExpire(String expireString) {
        for (DateTimeFormatter dateFormat : DATE_FORMATS) {
            try {
                return dateFormat.parse((CharSequence)expireString, ZonedDateTime::from).toEpochSecond() * 1000L;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return 0L;
    }
}

