/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.dissectors.tokenformat;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.dissectors.tokenformat.Token;
import org.apache.commons.lang.StringUtils;

public class TokenParser {
    public static final String FORMAT_NUMBER = "[0-9]*";
    public static final String FORMAT_CLF_NUMBER = "[0-9]*|-";
    public static final String FORMAT_HEXDIGIT = "[0-9a-fA-F]";
    public static final String FORMAT_HEXNUMBER = "[0-9a-fA-F]*";
    public static final String FORMAT_CLF_HEXNUMBER = "[0-9a-fA-F]*|-";
    public static final String FORMAT_NON_ZERO_NUMBER = "[1-9]|[1-9][0-9]*";
    public static final String FORMAT_EIGHT_BIT_DECIMAL = "(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    public static final String FORMAT_IPV4 = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    public static final String FORMAT_IPV6 = ":?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}";
    public static final String FORMAT_IP = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}";
    public static final String FORMAT_CLF_IP = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|:?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}(?::|::)?(?:[0-9a-fA-F]{1,4}(?::|.)?){0,8}|-";
    public static final String FORMAT_STRING = ".*";
    public static final String FORMAT_NO_SPACE_STRING = "[^\\s]*";
    public static final String FIXED_STRING = "FIXED_STRING";
    public static final String FORMAT_STANDARD_TIME_US = "\\[[0-3][0-9]/(?:[A-Z][a-z][a-z])/2[0-9][0-9][0-9]:[0-9][0-9]:[0-9][0-9]:[0-9][0-9] [\\+|\\-][0-9][0-9][0-9]0\\]";
    private final String logFormatToken;
    private final String valueName;
    private final String valueType;
    private final EnumSet<Casts> casts;
    private final String regex;
    private final int prio;

    public TokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex) {
        this(nLogFormatToken, nValueName, nValueType, nCasts, nRegex, 10);
    }

    public TokenParser(String nLogFormatToken, String nValueName, String nValueType, EnumSet<Casts> nCasts, String nRegex, int nPrio) {
        this.logFormatToken = nLogFormatToken;
        this.valueName = nValueName;
        this.valueType = nValueType;
        this.casts = nCasts;
        this.regex = nRegex;
        this.prio = nPrio;
    }

    public String getLogFormatToken() {
        return this.logFormatToken;
    }

    public String getValueName() {
        return this.valueName;
    }

    public String getValueType() {
        return this.valueType;
    }

    public EnumSet<Casts> getCasts() {
        return this.casts;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getPrio() {
        return this.prio;
    }

    public Token getNextToken(String logFormat, int startOffset) {
        int pos = logFormat.indexOf(this.logFormatToken, startOffset);
        if (pos == -1) {
            return null;
        }
        return new Token(this.valueName, this.valueType, this.casts, this.regex, pos, this.logFormatToken.length(), this.prio);
    }

    public List<Token> getTokens(String logFormat) {
        Token token;
        if (StringUtils.isBlank((String)logFormat)) {
            return null;
        }
        ArrayList<Token> result = new ArrayList<Token>(5);
        int offset = 0;
        while ((token = this.getNextToken(logFormat, offset)) != null) {
            result.add(token);
            offset = token.getStartPos() + token.getLength();
        }
        return result;
    }
}

