/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.dissectors.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;

public class HttpUriDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.URI";
    private boolean wantProtocol = false;
    private boolean wantUserinfo = false;
    private boolean wantHost = false;
    private boolean wantPort = false;
    private boolean wantPath = false;
    private boolean wantQuery = false;
    private boolean wantRef = false;

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.PROTOCOL:protocol");
        result.add("HTTP.USERINFO:userinfo");
        result.add("HTTP.HOST:host");
        result.add("HTTP.PORT:port");
        result.add("HTTP.PATH:path");
        result.add("HTTP.QUERYSTRING:query");
        result.add("HTTP.REF:ref");
        return result;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name = outputname.substring(inputname.length() + 1);
        if ("protocol".equals(name)) {
            this.wantProtocol = true;
            return Casts.STRING_ONLY;
        }
        if ("userinfo".equals(name)) {
            this.wantUserinfo = true;
            return Casts.STRING_ONLY;
        }
        if ("host".equals(name)) {
            this.wantHost = true;
            return Casts.STRING_ONLY;
        }
        if ("port".equals(name)) {
            this.wantPort = true;
            return Casts.STRING_OR_LONG;
        }
        if ("path".equals(name)) {
            this.wantPath = true;
            return Casts.STRING_ONLY;
        }
        if ("query".equals(name)) {
            this.wantQuery = true;
            return Casts.STRING_ONLY;
        }
        if ("ref".equals(name)) {
            this.wantRef = true;
            return Casts.STRING_ONLY;
        }
        return null;
    }

    public void prepareForRun() {
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        URL url;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        boolean isUrl = true;
        try {
            if (fieldValue.startsWith("/")) {
                url = new URL("http://xxx" + fieldValue);
                isUrl = false;
            } else {
                url = new URL(fieldValue);
            }
        }
        catch (MalformedURLException e) {
            throw new DissectionFailure("Unable to parse the URI: >>>" + fieldValue + "<<< (" + e.getMessage() + ")");
        }
        if (this.wantQuery || this.wantPath || this.wantRef) {
            String queryValue;
            String pathValue;
            String rawPath = url.getFile();
            int questionMark = rawPath.indexOf(63);
            int firstAmpersand = rawPath.indexOf(38);
            if (questionMark == -1) {
                if (firstAmpersand == -1) {
                    pathValue = rawPath;
                    queryValue = "";
                } else {
                    pathValue = rawPath.substring(0, firstAmpersand);
                    queryValue = rawPath.substring(firstAmpersand, rawPath.length());
                }
            } else if (firstAmpersand == -1) {
                pathValue = rawPath.substring(0, questionMark);
                queryValue = "&" + rawPath.substring(questionMark + 1, rawPath.length());
            } else {
                int usedOffset = Math.min(questionMark, firstAmpersand);
                pathValue = rawPath.substring(0, usedOffset);
                queryValue = "&" + rawPath.substring(usedOffset + 1, rawPath.length()).replaceAll("\\?", "&");
            }
            if (this.wantQuery) {
                parsable.addDissection(inputname, "HTTP.QUERYSTRING", "query", queryValue);
            }
            if (this.wantPath) {
                parsable.addDissection(inputname, "HTTP.PATH", "path", pathValue);
            }
            if (this.wantRef) {
                parsable.addDissection(inputname, "HTTP.REF", "ref", url.getRef());
            }
        }
        if (isUrl) {
            if (this.wantProtocol) {
                parsable.addDissection(inputname, "HTTP.PROTOCOL", "protocol", url.getProtocol());
            }
            if (this.wantUserinfo) {
                parsable.addDissection(inputname, "HTTP.USERINFO", "userinfo", url.getUserInfo());
            }
            if (this.wantHost) {
                parsable.addDissection(inputname, "HTTP.HOST", "host", url.getHost());
            }
            if (this.wantPort && url.getPort() != -1) {
                parsable.addDissection(inputname, "HTTP.PORT", "port", String.valueOf(url.getPort()));
            }
        }
    }
}

