/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.hadoop.input;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.basjes.hadoop.input.ApacheHttpdLogfileRecordReader;
import nl.basjes.hadoop.input.ParsedRecord;
import nl.basjes.parse.apachehttpdlog.ApacheHttpdLoglineParser;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.core.exceptions.MissingDissectorsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class ApacheHttpdLogfileInputFormat
extends FileInputFormat<LongWritable, ParsedRecord> {
    private String logFormat = null;
    private final Set<String> requestedFields = new HashSet<String>();
    private Map<String, Set<String>> typeRemappings;
    private List<Dissector> additionalDissectors;
    private ApacheHttpdLogfileRecordReader theRecordReader;

    public List<String> listPossibleFields(String logformat) throws MissingDissectorsException, InvalidDissectorException, ParseException {
        return ApacheHttpdLogfileInputFormat.listPossibleFields(logformat, this.typeRemappings, this.additionalDissectors);
    }

    public static List<String> listPossibleFields(String logformat, Map<String, Set<String>> typeRemappings, List<Dissector> additionalDissectors) throws MissingDissectorsException, InvalidDissectorException, ParseException {
        ApacheHttpdLoglineParser parser = new ApacheHttpdLoglineParser(ParsedRecord.class, logformat);
        parser.setTypeRemappings(typeRemappings);
        parser.addDissectors(additionalDissectors);
        return parser.getPossiblePaths();
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public Set<String> getRequestedFields() {
        return this.requestedFields;
    }

    public Map<String, Set<String>> getTypeRemappings() {
        return this.typeRemappings;
    }

    public List<Dissector> getAdditionalDissectors() {
        return this.additionalDissectors;
    }

    public ApacheHttpdLogfileInputFormat() {
    }

    public ApacheHttpdLogfileInputFormat(String logformat, Collection<String> requestedFields, Map<String, Set<String>> typeRemappings, List<Dissector> additionalDissectors) {
        this.logFormat = logformat;
        this.requestedFields.addAll(requestedFields);
        this.typeRemappings = typeRemappings;
        this.additionalDissectors = additionalDissectors;
    }

    public ApacheHttpdLogfileRecordReader createRecordReader() {
        return new ApacheHttpdLogfileRecordReader(this.getLogFormat(), this.getRequestedFields(), this.getTypeRemappings(), this.getAdditionalDissectors());
    }

    public ApacheHttpdLogfileRecordReader getRecordReader() {
        if (this.theRecordReader == null) {
            this.theRecordReader = this.createRecordReader();
        }
        return this.theRecordReader;
    }

    public RecordReader<LongWritable, ParsedRecord> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return this.getRecordReader();
    }

    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        return null == codec || codec instanceof SplittableCompressionCodec;
    }

    public void setTypeRemappings(Map<String, Set<String>> newTypeRemappings) {
        this.typeRemappings = newTypeRemappings;
    }
}

