/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.utils;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.utils.CustomThreadPoolManager;
import network.path.mobilenode.library.utils.CustomThreadPoolManager$sam$java_util_concurrent_Callable$0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0007\u0018\u00010\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;", "", "()V", "executorService", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "run", "Ljava/util/concurrent/Future;", "T", "name", "", "delay", "", "callable", "Lkotlin/Function0;", "stop", "", "Ljava/lang/Runnable;", "BackgroundThreadFactory", "Companion", "library_release"})
public final class CustomThreadPoolManager {
    private final ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(NUMBER_OF_CORES * 2, new BackgroundThreadFactory());
    private static final int NUMBER_OF_CORES;
    public static final Companion Companion;

    @Nullable
    public final <T> Future<T> run(@NotNull CharSequence name, long delay, @NotNull Function0<? extends T> callable) {
        Future future;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
        if (this.executorService.isShutdown()) {
            return null;
        }
        if (delay != 0L) {
            Function0<? extends T> function0 = callable;
            future = this.executorService.schedule(new CustomThreadPoolManager$sam$java_util_concurrent_Callable$0(function0), delay, TimeUnit.MILLISECONDS);
        } else {
            Function0<? extends T> function0 = callable;
            future = this.executorService.submit(new CustomThreadPoolManager$sam$java_util_concurrent_Callable$0(function0));
        }
        return future;
    }

    @Nullable
    public static /* synthetic */ Future run$default(CustomThreadPoolManager customThreadPoolManager, CharSequence charSequence, long l, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return customThreadPoolManager.run(charSequence, l, function0);
    }

    @NotNull
    public final List<Runnable> stop() {
        List<Runnable> list = this.executorService.shutdownNow();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"executorService.shutdownNow()");
        return list;
    }

    static {
        Companion = new Companion(null);
        NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager$BackgroundThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "currentTag", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "runnable", "Ljava/lang/Runnable;", "library_release"})
    private static final class BackgroundThreadFactory
    implements ThreadFactory {
        private AtomicInteger currentTag = new AtomicInteger(1);

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            String tag = String.valueOf(this.currentTag.getAndIncrement());
            Thread thread2 = new Thread(runnable);
            thread2.setName("CustomThread-" + tag);
            thread2.setPriority(10);
            thread2.setUncaughtExceptionHandler(newThread.1.INSTANCE);
            return thread2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager$Companion;", "", "()V", "NUMBER_OF_CORES", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

