/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.domain.entity.JobType;
import network.path.mobilenode.library.domain.entity.JobTypeStatistics;
import network.path.mobilenode.library.domain.entity.WifiSetting;
import network.path.mobilenode.library.utils.PrefsDelegatesKt;
import network.path.mobilenode.library.utils.SharedPreferencesDelegate;
import network.path.mobilenode.library.utils.SharedPreferencesOptionalDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\rH\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002032\u0006\u0010/\u001a\u000200H\u0016R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR/\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R/\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0016\u0010\u0010\"\u0004\b\u0017\u0010\u0012R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\f\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R$\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R+\u0010(\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020'8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u00068"}, d2={"Lnetwork/path/mobilenode/library/data/storage/PathStorageImpl;", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "<set-?>", "", "isActivated", "()Z", "setActivated", "(Z)V", "isActivated$delegate", "Lnetwork/path/mobilenode/library/utils/SharedPreferencesDelegate;", "", "nodeId", "getNodeId", "()Ljava/lang/String;", "setNodeId", "(Ljava/lang/String;)V", "nodeId$delegate", "Lnetwork/path/mobilenode/library/utils/SharedPreferencesOptionalDelegate;", "proxyDomain", "getProxyDomain", "setProxyDomain", "proxyDomain$delegate", "sharedPreferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "walletAddress", "getWalletAddress", "setWalletAddress", "walletAddress$delegate", "value", "Lnetwork/path/mobilenode/library/domain/entity/WifiSetting;", "wifiSetting", "getWifiSetting", "()Lnetwork/path/mobilenode/library/domain/entity/WifiSetting;", "setWifiSetting", "(Lnetwork/path/mobilenode/library/domain/entity/WifiSetting;)V", "", "wifiSettingValue", "getWifiSettingValue", "()I", "setWifiSettingValue", "(I)V", "wifiSettingValue$delegate", "createPrefKey", "type", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "key", "recordStatistics", "Lnetwork/path/mobilenode/library/domain/entity/JobTypeStatistics;", "elapsed", "", "statisticsForType", "Companion", "library_release"})
public final class PathStorageImpl
implements PathStorage {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final SharedPreferences sharedPreferences;
    @NotNull
    private final SharedPreferencesDelegate walletAddress$delegate;
    @Nullable
    private final SharedPreferencesOptionalDelegate nodeId$delegate;
    @NotNull
    private final SharedPreferencesDelegate isActivated$delegate;
    private final SharedPreferencesDelegate wifiSettingValue$delegate;
    @Nullable
    private final SharedPreferencesOptionalDelegate proxyDomain$delegate;
    private static final String PATH_ADDRESS_KEY = "PATH_ADDRESS_KEY";
    private static final String NODE_ID_KEY = "NODE_ID_KEY";
    private static final String IS_SERVICE_RUNNING_KEY = "IS_SERVICE_RUNNING_KEY";
    private static final String CHECKS_COUNT_KEY_SUFFIX = "_CHECKS_COUNT_KEY";
    private static final String CHECKS_LATENCY_KEY_SUFFIX = "_LATENCY_MILLIS_KEY";
    private static final String PROXY_DOMAIN_KEY = "PROXY_DOMAIN_KEY";
    private static final String WIFI_SETTING_KEY = "WIFI_SETTING_KEY";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathStorageImpl.class), "walletAddress", "getWalletAddress()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathStorageImpl.class), "nodeId", "getNodeId()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathStorageImpl.class), "isActivated", "isActivated()Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathStorageImpl.class), "wifiSettingValue", "getWifiSettingValue()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathStorageImpl.class), "proxyDomain", "getProxyDomain()Ljava/lang/String;"))};
        Companion = new Companion(null);
    }

    @Override
    @NotNull
    public String getWalletAddress() {
        return (String)this.walletAddress$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Override
    public void setWalletAddress(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.walletAddress$delegate.setValue(this, $$delegatedProperties[0], string);
    }

    @Override
    @Nullable
    public String getNodeId() {
        return (String)this.nodeId$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Override
    public void setNodeId(@Nullable String string) {
        this.nodeId$delegate.setValue(this, $$delegatedProperties[1], string);
    }

    @Override
    public boolean isActivated() {
        return (Boolean)this.isActivated$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Override
    public void setActivated(boolean bl) {
        this.isActivated$delegate.setValue(this, $$delegatedProperties[2], bl);
    }

    private final int getWifiSettingValue() {
        return ((Number)this.wifiSettingValue$delegate.getValue(this, $$delegatedProperties[3])).intValue();
    }

    private final void setWifiSettingValue(int n) {
        this.wifiSettingValue$delegate.setValue(this, $$delegatedProperties[3], n);
    }

    @Override
    @NotNull
    public WifiSetting getWifiSetting() {
        WifiSetting wifiSetting = WifiSetting.Companion.valueOf(this.getWifiSettingValue());
        if (wifiSetting == null) {
            wifiSetting = WifiSetting.WIFI_AND_CELLULAR;
        }
        return wifiSetting;
    }

    @Override
    public void setWifiSetting(@NotNull WifiSetting value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.setWifiSettingValue(value.getValue());
    }

    @Override
    @Nullable
    public String getProxyDomain() {
        return (String)this.proxyDomain$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @Override
    public void setProxyDomain(@Nullable String string) {
        this.proxyDomain$delegate.setValue(this, $$delegatedProperties[4], string);
    }

    private final String createPrefKey(JobType type, String key) {
        return (Object)((Object)type) + key;
    }

    @Override
    @NotNull
    public JobTypeStatistics statisticsForType(@NotNull JobType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        long averageLatency = this.sharedPreferences.getLong(this.createPrefKey(type, CHECKS_LATENCY_KEY_SUFFIX), 0L);
        long count = averageLatency < 1L ? 0L : this.sharedPreferences.getLong(this.createPrefKey(type, CHECKS_COUNT_KEY_SUFFIX), 0L);
        return new JobTypeStatistics(type, count, averageLatency);
    }

    @Override
    @NotNull
    public JobTypeStatistics recordStatistics(@NotNull JobType type, long elapsed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        JobTypeStatistics stats = this.statisticsForType(type);
        JobTypeStatistics newStats = stats.add$library_release(elapsed);
        SharedPreferences.Editor edit = this.sharedPreferences.edit();
        edit.putLong(this.createPrefKey(type, CHECKS_COUNT_KEY_SUFFIX), newStats.getCount());
        edit.putLong(this.createPrefKey(type, CHECKS_LATENCY_KEY_SUFFIX), newStats.getTotalLatencyMillis());
        edit.apply();
        return newStats;
    }

    public PathStorageImpl(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        this.walletAddress$delegate = PrefsDelegatesKt.prefs(sharedPreferences, PATH_ADDRESS_KEY, "0x0000000000000000000000000000000000000000");
        SharedPreferences sharedPreferences2 = this.sharedPreferences;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences2, (String)"sharedPreferences");
        this.nodeId$delegate = PrefsDelegatesKt.prefsOptional$default(sharedPreferences2, NODE_ID_KEY, String.class, 0L, 8, null);
        SharedPreferences sharedPreferences3 = this.sharedPreferences;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences3, (String)"sharedPreferences");
        this.isActivated$delegate = PrefsDelegatesKt.prefs(sharedPreferences3, IS_SERVICE_RUNNING_KEY, false);
        SharedPreferences sharedPreferences4 = this.sharedPreferences;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences4, (String)"sharedPreferences");
        this.wifiSettingValue$delegate = PrefsDelegatesKt.prefs(sharedPreferences4, WIFI_SETTING_KEY, WifiSetting.WIFI_AND_CELLULAR.ordinal());
        SharedPreferences sharedPreferences5 = this.sharedPreferences;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences5, (String)"sharedPreferences");
        this.proxyDomain$delegate = PrefsDelegatesKt.prefsOptional(sharedPreferences5, PROXY_DOMAIN_KEY, String.class, 3600000L);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnetwork/path/mobilenode/library/data/storage/PathStorageImpl$Companion;", "", "()V", "CHECKS_COUNT_KEY_SUFFIX", "", "CHECKS_LATENCY_KEY_SUFFIX", "IS_SERVICE_RUNNING_KEY", "NODE_ID_KEY", "PATH_ADDRESS_KEY", "PROXY_DOMAIN_KEY", "WIFI_SETTING_KEY", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

