/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.runner;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import network.path.mobilenode.library.data.runner.TimeSource;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rH\u0000\u001a,\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u000e\b\u0004\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0080\b\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"calculateJobStatus", "", "requestDurationMillis", "", "jobRequest", "Lnetwork/path/mobilenode/library/domain/entity/JobRequest;", "computeJobResult", "Lnetwork/path/mobilenode/library/domain/entity/JobResult;", "jobType", "Lnetwork/path/mobilenode/library/domain/entity/JobType;", "timeSource", "Lnetwork/path/mobilenode/library/data/runner/TimeSource;", "block", "Lkotlin/Function1;", "runWithTimeout", "T", "timeout", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "library_release"})
public final class RunnerUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JobResult computeJobResult(@NotNull JobType jobType, @NotNull JobRequest jobRequest, @NotNull TimeSource timeSource, @NotNull Function1<? super JobRequest, String> block) {
        void isResponseKnown;
        void responseBody;
        Intrinsics.checkParameterIsNotNull((Object)((Object)jobType), (String)"jobType");
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Intrinsics.checkParameterIsNotNull((Object)timeSource, (String)"timeSource");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = "";
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        long requestDurationMillis2 = timeSource.measure((Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef)responseBody, block, jobRequest, (Ref.BooleanRef)isResponseKnown){
            final /* synthetic */ Ref.ObjectRef $responseBody;
            final /* synthetic */ Function1 $block;
            final /* synthetic */ JobRequest $jobRequest;
            final /* synthetic */ Ref.BooleanRef $isResponseKnown;

            public final void invoke() {
                try {
                    this.$responseBody.element = (String)this.$block.invoke((Object)this.$jobRequest);
                    this.$isResponseKnown.element = true;
                }
                catch (IOException e) {
                    this.$responseBody.element = e.toString();
                }
                catch (Exception e) {
                    this.$responseBody.element = e.toString();
                }
            }
            {
                this.$responseBody = objectRef;
                this.$block = function1;
                this.$jobRequest = jobRequest;
                this.$isResponseKnown = booleanRef;
                super(0);
            }
        }));
        String status = isResponseKnown.element ? RunnerUtilsKt.calculateJobStatus(requestDurationMillis2, jobRequest) : "unknown";
        Timber.d((String)("RUNNER: [" + jobRequest + "] => " + status), (Object[])new Object[0]);
        int n = 0;
        String string = status;
        String string2 = (String)responseBody.element;
        long l = requestDurationMillis2;
        return new JobResult(null, jobType, jobRequest.getExecutionUuid(), string, l, string2, n, 65, null);
    }

    public static final <T> T runWithTimeout(long timeout, @NotNull Function0<? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future f2 = executor.submit(new Callable<T>(block){
            final /* synthetic */ Function0 $block;

            public final T call() {
                return (T)this.$block.invoke();
            }
            {
                this.$block = function0;
            }
        });
        return f2.get(timeout, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public static final String calculateJobStatus(long requestDurationMillis2, @NotNull JobRequest jobRequest) {
        long criticalAfterMillis;
        Intrinsics.checkParameterIsNotNull((Object)jobRequest, (String)"jobRequest");
        Long l = jobRequest.getDegradedAfter();
        long degradedAfterMillis = l != null ? l : 1000L;
        Long l2 = jobRequest.getCriticalAfter();
        long l3 = criticalAfterMillis = l2 != null ? l2 : 2000L;
        return requestDurationMillis2 > degradedAfterMillis ? "degraded" : (requestDurationMillis2 > criticalAfterMillis ? "critical" : "ok");
    }
}

