/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Dns;
import org.jetbrains.annotations.NotNull;
import org.xbill.DNS.Address;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnetwork/path/mobilenode/library/data/http/CustomDns;", "Lokhttp3/Dns;", "isTest", "", "(Z)V", "isInitialized", "staticIpAddress", "Ljava/net/InetAddress;", "init", "", "lookup", "", "hostname", "", "library_release"})
public final class CustomDns
implements Dns {
    private boolean isInitialized;
    private InetAddress staticIpAddress;
    private final boolean isTest;

    @NotNull
    public List<InetAddress> lookup(@NotNull String hostname) {
        List<InetAddress> list;
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        this.init();
        try {
            List<InetAddress> list2 = Collections.singletonList(Address.getByName((String)hostname));
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.singletonLis\u2026ress.getByName(hostname))");
            list = list2;
        }
        catch (UnknownHostException e) {
            String apiHost;
            String string = apiHost = this.isTest ? "http://jobs-api.dev.udpflood.net/" : "https://jobs-api.path.network/";
            if (!Intrinsics.areEqual((Object)apiHost, (Object)hostname) || this.staticIpAddress == null) {
                throw (Throwable)e;
            }
            List<InetAddress> list3 = Collections.singletonList(this.staticIpAddress);
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.singletonList(staticIpAddress)");
            list = list3;
        }
        return list;
    }

    private final void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        try {
            String apiIp = this.isTest ? "52.13.210.106" : "34.210.251.154";
            this.staticIpAddress = InetAddress.getByName(apiIp);
            Timber.d((String)"DNS: initialised static IP address", (Object[])new Object[0]);
        }
        catch (UnknownHostException e) {
            Timber.w((String)"DNS: couldn't initialize static IP address", (Object[])new Object[0]);
        }
        try {
            Resolver defaultResolver = Lookup.getDefaultResolver();
            SimpleResolver googleFirstResolver = new SimpleResolver("8.8.8.8");
            SimpleResolver googleSecondResolver = new SimpleResolver("8.8.4.4");
            SimpleResolver amazonResolver = new SimpleResolver("205.251.198.30");
            Lookup.setDefaultResolver((Resolver)((Resolver)new ExtendedResolver(new Resolver[]{defaultResolver, (Resolver)googleFirstResolver, (Resolver)googleSecondResolver, (Resolver)amazonResolver})));
            Timber.d((String)"DNS: initialised custom resolvers", (Object[])new Object[0]);
        }
        catch (UnknownHostException e) {
            Timber.w((String)"DNS: couldn't initialize custom resolvers", (Object[])new Object[0]);
        }
    }

    public CustomDns(boolean isTest) {
        this.isTest = isTest;
    }
}

