/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.data.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import network.path.mobilenode.library.data.android.NetworkMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007*\u0001\u0019\b\u0000\u0018\u00002\u00020\u0001:\u0002#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0015J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u001eJ\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006%"}, d2={"Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectivityManager", "()Landroid/net/ConnectivityManager;", "intentFilter", "Landroid/content/IntentFilter;", "intentFilter$annotations", "()V", "<set-?>", "", "isConnected", "()Z", "setConnected", "(Z)V", "listeners", "", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$Listener;", "networkCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "networkReceiver", "network/path/mobilenode/library/data/android/NetworkMonitor$networkReceiver$1", "Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$networkReceiver$1;", "addListener", "l", "checkStatus", "", "removeListener", "start", "stop", "updateStatus", "Listener", "NetworkCallback", "library_release"})
public final class NetworkMonitor {
    private boolean isConnected;
    @NotNull
    private final ConnectivityManager connectivityManager;
    private final IntentFilter intentFilter;
    private final networkReceiver.1 networkReceiver;
    private ConnectivityManager.NetworkCallback networkCallback;
    private final List<Listener> listeners;
    private final Context context;

    public final boolean isConnected() {
        return this.isConnected;
    }

    private final void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    @NotNull
    public final ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    private static /* synthetic */ void intentFilter$annotations() {
    }

    public final boolean addListener(@NotNull Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.add(l);
    }

    public final boolean removeListener(@NotNull Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.remove(l);
    }

    public final void start() {
        this.checkStatus();
        if (Build.VERSION.SDK_INT >= 24) {
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"networkCallback");
            }
            this.connectivityManager.registerDefaultNetworkCallback(networkCallback);
        } else if (Build.VERSION.SDK_INT >= 21) {
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            NetworkRequest networkRequest = builder.build();
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"networkCallback");
            }
            this.connectivityManager.registerNetworkCallback(networkRequest, networkCallback);
        } else {
            this.context.registerReceiver((BroadcastReceiver)this.networkReceiver, this.intentFilter);
        }
    }

    public final void stop() {
        if (Build.VERSION.SDK_INT >= 21) {
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"networkCallback");
            }
            this.connectivityManager.unregisterNetworkCallback(networkCallback);
        } else {
            this.context.unregisterReceiver((BroadcastReceiver)this.networkReceiver);
        }
    }

    private final void checkStatus() {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return;
        }
        NetworkInfo networkInfo2 = networkInfo;
        this.updateStatus(networkInfo2.isConnected());
    }

    private final void updateStatus(boolean isConnected) {
        if (isConnected != this.isConnected) {
            this.isConnected = isConnected;
            Iterable $receiver$iv = this.listeners;
            for (Object element$iv : $receiver$iv) {
                Listener it = (Listener)element$iv;
                it.onStatusChanged(isConnected);
            }
        }
    }

    public NetworkMonitor(@NotNull Context context) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        Object object = this.context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.connectivityManager = (ConnectivityManager)object;
        this.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.networkReceiver = new BroadcastReceiver(this){
            final /* synthetic */ NetworkMonitor this$0;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                NetworkMonitor.access$checkStatus(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        NetworkMonitor networkMonitor = this;
        networkMonitor.listeners = list = (List)new ArrayList();
        if (Build.VERSION.SDK_INT >= 21) {
            this.networkCallback = new NetworkCallback();
        }
    }

    public static final /* synthetic */ void access$checkStatus(NetworkMonitor $this) {
        $this.checkStatus();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$Listener;", "", "onStatusChanged", "", "connected", "", "library_release"})
    public static interface Listener {
        public void onStatusChanged(boolean var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnetwork/path/mobilenode/library/data/android/NetworkMonitor$NetworkCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Lnetwork/path/mobilenode/library/data/android/NetworkMonitor;)V", "onAvailable", "", "network", "Landroid/net/Network;", "onLost", "library_release"})
    @RequiresApi(value=21)
    public final class NetworkCallback
    extends ConnectivityManager.NetworkCallback {
        public void onAvailable(@Nullable Network network) {
            NetworkMonitor.this.updateStatus(true);
        }

        public void onLost(@Nullable Network network) {
            NetworkMonitor.this.updateStatus(false);
        }
    }
}

