/*
 * Decompiled with CFR 0.152.
 */
package network.path.mobilenode.library.domain;

import android.content.Context;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import network.path.mobilenode.library.data.http.PathHttpEngine;
import network.path.mobilenode.library.data.runner.PathJobExecutorImpl;
import network.path.mobilenode.library.data.runner.TimeClock;
import network.path.mobilenode.library.data.storage.PathStorageImpl;
import network.path.mobilenode.library.domain.PathEngine;
import network.path.mobilenode.library.domain.PathJobExecutor;
import network.path.mobilenode.library.domain.PathStorage;
import network.path.mobilenode.library.domain.PathSystem;
import network.path.mobilenode.library.domain.entity.ConnectionStatus;
import network.path.mobilenode.library.domain.entity.JobList;
import network.path.mobilenode.library.domain.entity.JobRequest;
import network.path.mobilenode.library.domain.entity.JobResult;
import network.path.mobilenode.library.domain.entity.JobType;
import network.path.mobilenode.library.domain.entity.JobTypeStatistics;
import network.path.mobilenode.library.domain.entity.NodeInfo;
import network.path.mobilenode.library.domain.entity.WifiSetting;
import network.path.mobilenode.library.utils.CustomThreadPoolManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007*\u0001\u0014\u0018\u0000 G2\u00020\u0001:\u0003FGHB/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u001eJ\u000e\u0010>\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u001eJ\u000e\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\"J\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020BJ\u0006\u0010D\u001a\u00020\u0003J\b\u0010E\u001a\u00020BH\u0002R$\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R$\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001c\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010 0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010!\u001a\u0004\u0018\u00010\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0013\u0010%\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R0\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020*0)@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010$R$\u00107\u001a\u0002062\u0006\u0010\r\u001a\u0002068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006I"}, d2={"Lnetwork/path/mobilenode/library/domain/PathSystem;", "", "isTest", "", "engine", "Lnetwork/path/mobilenode/library/domain/PathEngine;", "storage", "Lnetwork/path/mobilenode/library/domain/PathStorage;", "jobExecutor", "Lnetwork/path/mobilenode/library/domain/PathJobExecutor;", "threadManager", "Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;", "(ZLnetwork/path/mobilenode/library/domain/PathEngine;Lnetwork/path/mobilenode/library/domain/PathStorage;Lnetwork/path/mobilenode/library/domain/PathJobExecutor;Lnetwork/path/mobilenode/library/utils/CustomThreadPoolManager;)V", "value", "autoStart", "getAutoStart", "()Z", "setAutoStart", "(Z)V", "engineListener", "network/path/mobilenode/library/domain/PathSystem$engineListener$1", "Lnetwork/path/mobilenode/library/domain/PathSystem$engineListener$1;", "hasAddress", "getHasAddress", "isJobExecutionRunning", "<set-?>", "isStarted", "setStarted", "listeners", "", "Lnetwork/path/mobilenode/library/domain/PathSystem$Listener;", "kotlin.jvm.PlatformType", "", "nodeId", "", "getNodeId", "()Ljava/lang/String;", "nodeInfo", "Lnetwork/path/mobilenode/library/domain/entity/NodeInfo;", "getNodeInfo", "()Lnetwork/path/mobilenode/library/domain/entity/NodeInfo;", "", "Lnetwork/path/mobilenode/library/domain/entity/JobTypeStatistics;", "statistics", "getStatistics", "()Ljava/util/List;", "setStatistics", "(Ljava/util/List;)V", "status", "Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "getStatus", "()Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "walletAddress", "getWalletAddress", "Lnetwork/path/mobilenode/library/domain/entity/WifiSetting;", "wifiSetting", "getWifiSetting", "()Lnetwork/path/mobilenode/library/domain/entity/WifiSetting;", "setWifiSetting", "(Lnetwork/path/mobilenode/library/domain/entity/WifiSetting;)V", "addListener", "l", "removeListener", "setWalletAddress", "address", "start", "", "stop", "toggleJobExecution", "updateStatistics", "BaseListener", "Companion", "Listener", "library_release"})
public final class PathSystem {
    private final Set<Listener> listeners;
    private boolean isStarted;
    @NotNull
    private List<JobTypeStatistics> statistics;
    private final engineListener.1 engineListener;
    private final boolean isTest;
    private final PathEngine engine;
    private final PathStorage storage;
    private final PathJobExecutor jobExecutor;
    private final CustomThreadPoolManager threadManager;
    private static PathSystem INSTANCE;
    public static final Companion Companion;

    public final boolean addListener(@NotNull Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.add(l);
    }

    public final boolean removeListener(@NotNull Listener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return this.listeners.remove(l);
    }

    public final boolean isStarted() {
        return this.isStarted;
    }

    private final void setStarted(boolean bl) {
        this.isStarted = bl;
    }

    @NotNull
    public final ConnectionStatus getStatus() {
        return this.engine.getStatus();
    }

    @Nullable
    public final String getNodeId() {
        return this.engine.getNodeId();
    }

    @Nullable
    public final NodeInfo getNodeInfo() {
        JobList jobList = this.engine.getJobList();
        return jobList != null ? jobList.getNodeInfo() : null;
    }

    public final boolean isJobExecutionRunning() {
        return this.engine.isJobExecutionRunning();
    }

    public final boolean getAutoStart() {
        return this.storage.getAutoStart();
    }

    public final void setAutoStart(boolean value) {
        this.storage.setAutoStart(value);
    }

    @NotNull
    public final WifiSetting getWifiSetting() {
        return this.storage.getWifiSetting();
    }

    public final void setWifiSetting(@NotNull WifiSetting value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.storage.setWifiSetting(value);
    }

    @NotNull
    public final String getWalletAddress() {
        return this.storage.getWalletAddress();
    }

    public final boolean getHasAddress() {
        return Intrinsics.areEqual((Object)this.storage.getWalletAddress(), (Object)"0x0000000000000000000000000000000000000000") ^ true;
    }

    public final boolean setWalletAddress(@NotNull String address) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        if (Companion.isWalletAddressValid(address)) {
            this.storage.setWalletAddress(address);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<JobTypeStatistics> getStatistics() {
        return this.statistics;
    }

    private final void setStatistics(List<JobTypeStatistics> value) {
        this.statistics = value;
        Set<Listener> set = this.listeners;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"listeners");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            Listener it = (Listener)element$iv;
            it.onStatisticsChanged(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        PathSystem pathSystem = this;
        synchronized (pathSystem) {
            if (!this.isStarted) {
                this.isStarted = true;
                this.jobExecutor.start();
                this.engine.addListener(this.engineListener);
                this.engine.start();
                this.updateStatistics();
                Timber.d((String)"SYSTEM: started", (Object[])new Object[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean toggleJobExecution() {
        return this.engine.toggleJobExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        PathSystem pathSystem = this;
        synchronized (pathSystem) {
            if (this.isStarted) {
                this.isStarted = false;
                this.engine.stop();
                this.engine.removeListener(this.engineListener);
                this.jobExecutor.stop();
                Timber.d((String)"SYSTEM: stopped", (Object[])new Object[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStatistics() {
        void var3_4;
        Object object;
        Iterable<Object> iterable;
        void $receiver$iv$iv;
        void $receiver$iv;
        JobType[] jobTypeArray = JobType.values();
        PathSystem pathSystem = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        void var4_5 = $receiver$iv$iv;
        int n = ((void)var4_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_9 = item$iv$iv = var4_5[i];
            iterable = destination$iv$iv;
            object = this.storage.statisticsForType((JobType)it);
            iterable.add(object);
        }
        iterable = (List)var3_4;
        iterable = iterable;
        object = new Comparator<T>(){

            public final int compare(T a, T b) {
                T receiver = b;
                Comparable comparable = Long.valueOf(((JobTypeStatistics)receiver).getCount());
                receiver = a;
                Comparable comparable2 = comparable;
                Long l = ((JobTypeStatistics)receiver).getCount();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                T receiver = b;
                Comparable comparable = Long.valueOf(((JobTypeStatistics)receiver).getAverageLatency());
                receiver = a;
                Comparable comparable2 = comparable;
                Long l = ((JobTypeStatistics)receiver).getAverageLatency();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        pathSystem.setStatistics(CollectionsKt.sortedWith(iterable, (Comparator)ComparisonsKt.then((Comparator)object, (Comparator)comparator)));
    }

    public final boolean isTest() {
        return this.isTest;
    }

    public PathSystem(boolean isTest, @NotNull PathEngine engine, @NotNull PathStorage storage, @NotNull PathJobExecutor jobExecutor, @NotNull CustomThreadPoolManager threadManager) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)jobExecutor, (String)"jobExecutor");
        Intrinsics.checkParameterIsNotNull((Object)threadManager, (String)"threadManager");
        this.isTest = isTest;
        this.engine = engine;
        this.storage = storage;
        this.jobExecutor = jobExecutor;
        this.threadManager = threadManager;
        this.listeners = Collections.newSetFromMap(new ConcurrentHashMap(0));
        this.statistics = CollectionsKt.emptyList();
        this.engineListener = new PathEngine.Listener(this){
            final /* synthetic */ PathSystem this$0;

            public void onStatusChanged(@NotNull ConnectionStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                Set set = PathSystem.access$getListeners$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"listeners");
                Iterable $receiver$iv = set;
                for (T element$iv : $receiver$iv) {
                    Listener it = (Listener)element$iv;
                    it.onConnectionStatusChanged(status);
                }
            }

            public void onRequestReceived(@NotNull JobRequest request) {
                CustomThreadPoolManager customThreadPoolManager;
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                CustomThreadPoolManager $receiver = customThreadPoolManager = PathSystem.access$getThreadManager$p(this.this$0);
                Timber.d((String)("SYSTEM: received [" + request + ']'), (Object[])new Object[0]);
                try {
                    JobResult result2 = PathSystem.access$getJobExecutor$p(this.this$0).execute(request).get();
                    PathSystem.access$getStorage$p(this.this$0).recordStatistics(result2.getCheckType(), result2.getResponseTime());
                    PathEngine pathEngine = PathSystem.access$getEngine$p(this.this$0);
                    JobResult jobResult = result2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jobResult, (String)"result");
                    pathEngine.processResult(jobResult);
                    PathSystem.access$updateStatistics(this.this$0);
                    Timber.d((String)("SYSTEM: request result [" + result2 + ']'), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    Timber.e((Throwable)e, (String)("SYSTEM: job exception [" + e.getMessage() + ']'), (Object[])new Object[0]);
                }
            }

            public void onNodeId(@Nullable String nodeId) {
                if (nodeId != null) {
                    PathSystem.access$getStorage$p(this.this$0).setNodeId(nodeId);
                }
                Set set = PathSystem.access$getListeners$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"listeners");
                Iterable $receiver$iv = set;
                for (T element$iv : $receiver$iv) {
                    Listener it = (Listener)element$iv;
                    it.onNodeId(nodeId);
                }
            }

            public void onJobListReceived(@Nullable JobList jobList) {
                Set set = PathSystem.access$getListeners$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"listeners");
                Iterable $receiver$iv = set;
                for (T element$iv : $receiver$iv) {
                    Listener it = (Listener)element$iv;
                    JobList jobList2 = jobList;
                    it.onNodeInfoReceived(jobList2 != null ? jobList2.getNodeInfo() : null);
                }
            }

            public void onRunning(boolean isRunning) {
                Set set = PathSystem.access$getListeners$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"listeners");
                Iterable $receiver$iv = set;
                for (T element$iv : $receiver$iv) {
                    Listener it = (Listener)element$iv;
                    it.onJobExecutionStatusChanged(isRunning);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ Set access$getListeners$p(PathSystem $this) {
        return $this.listeners;
    }

    @NotNull
    public static final /* synthetic */ CustomThreadPoolManager access$getThreadManager$p(PathSystem $this) {
        return $this.threadManager;
    }

    @NotNull
    public static final /* synthetic */ PathJobExecutor access$getJobExecutor$p(PathSystem $this) {
        return $this.jobExecutor;
    }

    @NotNull
    public static final /* synthetic */ PathStorage access$getStorage$p(PathSystem $this) {
        return $this.storage;
    }

    @NotNull
    public static final /* synthetic */ PathEngine access$getEngine$p(PathSystem $this) {
        return $this.engine;
    }

    public static final /* synthetic */ void access$updateStatistics(PathSystem $this) {
        $this.updateStatistics();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0012\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&J\u0012\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH&J\u0016\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H&\u00a8\u0006\u0013"}, d2={"Lnetwork/path/mobilenode/library/domain/PathSystem$Listener;", "", "onConnectionStatusChanged", "", "status", "Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "onJobExecutionStatusChanged", "isRunning", "", "onNodeId", "nodeId", "", "onNodeInfoReceived", "nodeInfo", "Lnetwork/path/mobilenode/library/domain/entity/NodeInfo;", "onStatisticsChanged", "statistics", "", "Lnetwork/path/mobilenode/library/domain/entity/JobTypeStatistics;", "library_release"})
    public static interface Listener {
        public void onConnectionStatusChanged(@NotNull ConnectionStatus var1);

        public void onNodeId(@Nullable String var1);

        public void onNodeInfoReceived(@Nullable NodeInfo var1);

        public void onJobExecutionStatusChanged(boolean var1);

        public void onStatisticsChanged(@NotNull List<JobTypeStatistics> var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lnetwork/path/mobilenode/library/domain/PathSystem$BaseListener;", "Lnetwork/path/mobilenode/library/domain/PathSystem$Listener;", "()V", "onConnectionStatusChanged", "", "status", "Lnetwork/path/mobilenode/library/domain/entity/ConnectionStatus;", "onJobExecutionStatusChanged", "isRunning", "", "onNodeId", "nodeId", "", "onNodeInfoReceived", "nodeInfo", "Lnetwork/path/mobilenode/library/domain/entity/NodeInfo;", "onStatisticsChanged", "statistics", "", "Lnetwork/path/mobilenode/library/domain/entity/JobTypeStatistics;", "library_release"})
    public static class BaseListener
    implements Listener {
        @Override
        public void onConnectionStatusChanged(@NotNull ConnectionStatus status) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        }

        @Override
        public void onNodeId(@Nullable String nodeId) {
        }

        @Override
        public void onNodeInfoReceived(@Nullable NodeInfo nodeInfo) {
        }

        @Override
        public void onJobExecutionStatusChanged(boolean isRunning) {
        }

        @Override
        public void onStatisticsChanged(@NotNull List<JobTypeStatistics> statistics) {
            Intrinsics.checkParameterIsNotNull(statistics, (String)"statistics");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnetwork/path/mobilenode/library/domain/PathSystem$Companion;", "", "()V", "INSTANCE", "Lnetwork/path/mobilenode/library/domain/PathSystem;", "checkedAddress", "", "address", "", "create", "context", "Landroid/content/Context;", "isTest", "", "createLenientGson", "Lcom/google/gson/Gson;", "createOkHttpClient", "Lokhttp3/OkHttpClient;", "isWalletAddressValid", "library_release"})
    public static final class Companion {
        @NotNull
        public final PathSystem create(@NotNull Context context, boolean isTest) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (INSTANCE == null) {
                Gson gson = this.createLenientGson();
                CustomThreadPoolManager threadManager = new CustomThreadPoolManager();
                OkHttpClient okHttpClient = this.createOkHttpClient();
                PathStorageImpl storage = new PathStorageImpl(context, isTest);
                PathEngine engine = PathHttpEngine.Companion.create(context, threadManager, okHttpClient, storage, gson, isTest);
                PathJobExecutorImpl jobExecutor = new PathJobExecutorImpl(okHttpClient, storage, gson, TimeClock.INSTANCE);
                INSTANCE = new PathSystem(isTest, engine, storage, jobExecutor, threadManager);
            }
            PathSystem pathSystem = INSTANCE;
            if (pathSystem == null) {
                Intrinsics.throwNpe();
            }
            return pathSystem;
        }

        @NotNull
        public static /* synthetic */ PathSystem create$default(Companion companion, Context context, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(context, bl);
        }

        public final boolean isWalletAddressValid(@NotNull CharSequence address) {
            String s;
            String string;
            Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
            String string2 = string = (s = ((Object)address).toString());
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual((Object)string3, (Object)s)) {
                return true;
            }
            String string4 = string = s;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
            if (Intrinsics.areEqual((Object)string5, (Object)s)) {
                return true;
            }
            return Intrinsics.areEqual((Object)Numeric.prependHexPrefix((String)s), (Object)this.checkedAddress(address));
        }

        /*
         * WARNING - void declaration
         */
        private final String checkedAddress(CharSequence address) {
            String string;
            String hash;
            String string2;
            String string3 = Numeric.cleanHexPrefix((String)((Object)address).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Numeric.cleanHexPrefix(address.toString())");
            String string4 = string2 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            String cleanAddress = string5;
            StringBuilder sb = new StringBuilder();
            String string6 = hash = Hash.sha3String((String)cleanAddress);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"hash");
            String string7 = string6;
            int n = 2;
            String string8 = string7;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            String string10 = string7 = string9;
            if (string10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string10.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] hashChars = cArray;
            IntRange hashIndices = ArraysKt.getIndices((char[])hashChars);
            String string11 = string = cleanAddress;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray2 = string11.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
            char[] chars = cArray2;
            int n2 = 0;
            int n3 = chars.length;
            while (n2 < n3) {
                void i;
                if (hashIndices.contains((int)i)) {
                    char c = (Character.digit(hashChars[i], 16) & 0xFF) > 7 ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
                    sb.append(c);
                }
                ++i;
            }
            String string12 = Numeric.prependHexPrefix((String)sb.toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"Numeric.prependHexPrefix(sb.toString())");
            return string12;
        }

        private final OkHttpClient createOkHttpClient() {
            HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(10000L, TimeUnit.MILLISECONDS).writeTimeout(10000L, TimeUnit.MILLISECONDS).connectTimeout(10000L, TimeUnit.MILLISECONDS).addInterceptor((Interceptor)createOkHttpClient.1.INSTANCE);
            HttpLoggingInterceptor $receiver = httpLoggingInterceptor;
            $receiver.setLevel(HttpLoggingInterceptor.Level.NONE);
            HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor;
            OkHttpClient okHttpClient = builder.addInterceptor((Interceptor)httpLoggingInterceptor2).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"OkHttpClient.Builder()\n \u2026st))\n            .build()");
            return okHttpClient;
        }

        private final Gson createLenientGson() {
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder()\n          \u2026ES)\n            .create()");
            return gson;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

