/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.util.SparseArray;
import androidx.sqlite.db.SupportSQLiteProgram;

class BindingsRecorder
implements SupportSQLiteProgram {
    private SparseArray<Object> bindings = new SparseArray();

    BindingsRecorder() {
    }

    public void bindNull(int index) {
        this.bindings.put(index, null);
    }

    public void bindLong(int index, long value) {
        this.bindings.put(index, (Object)value);
    }

    public void bindDouble(int index, double value) {
        this.bindings.put(index, (Object)value);
    }

    public void bindString(int index, String value) {
        this.bindings.put(index, (Object)value);
    }

    public void bindBlob(int index, byte[] value) {
        this.bindings.put(index, (Object)value);
    }

    public void clearBindings() {
        this.bindings.clear();
    }

    public void close() {
        this.clearBindings();
    }

    String[] getBindings() {
        String[] result = new String[this.bindings.size()];
        for (int i = 0; i < this.bindings.size(); ++i) {
            int key = this.bindings.keyAt(i);
            Object binding = this.bindings.get(key);
            result[i] = binding != null ? this.bindings.get(key).toString() : "";
        }
        return result;
    }
}

