/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.list;

import android.content.Context;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.descriptors.CompositeNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.IEnabled;
import net.xpece.material.navigationdrawer.descriptors.NavigationSectionDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;
import net.xpece.material.navigationdrawer.internal.ViewHolder;

class NavigationListAdapter
extends BaseAdapter {
    private static final int TYPE_HEADING = 0;
    private static final int TYPE_PADDING = 1;
    private static final int TYPE_SEPARATOR = 2;
    private static final int TYPE_ITEM_START = 3;
    private SparseIntArray mItemViewTypeSet = new SparseIntArray();
    private List<NavigationSectionDescriptor> mSections = new ArrayList<NavigationSectionDescriptor>(0);
    private SparseIntArray mViewTypes = new SparseIntArray();
    private SparseArray<Object> mItems = new SparseArray();
    private SparseIntArray mPositions = null;
    private int mSelectedPosition = -1;
    private boolean mReselectEnabled = true;

    public NavigationListAdapter(List<NavigationSectionDescriptor> sections) {
        this.setSections(sections);
    }

    private void setSections(List<NavigationSectionDescriptor> sections) {
        this.notifyDataSetInvalidated();
        this.mSections = sections;
        this.calculateViewTypesAndItems();
        this.notifyDataSetChanged();
    }

    public void setActivatedItem(int position) {
        if (this.mSelectedPosition != position) {
            this.mSelectedPosition = position;
            this.notifyDataSetChanged();
        }
    }

    public boolean isReselectEnabled() {
        return this.mReselectEnabled;
    }

    public void setReselectEnabled(boolean reselectEnabled) {
        this.mReselectEnabled = reselectEnabled;
    }

    public void notifyDataSetInvalidated() {
        this.mPositions = null;
        super.notifyDataSetInvalidated();
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        return this.getItemViewType(position) >= 3 && (this.mReselectEnabled || position != this.mSelectedPosition) && this.isItemEnabled(position);
    }

    private boolean isItemEnabled(int position) {
        Object item = this.getItem(position);
        if (item instanceof IEnabled) {
            return ((IEnabled)item).isEnabled();
        }
        return false;
    }

    public int getItemViewType(int position) {
        return this.mViewTypes.get(position);
    }

    public int getViewTypeCount() {
        return 3 + this.mItemViewTypeSet.size();
    }

    public int getCount() {
        return this.getRealItemCount() + 2 * this.mSections.size();
    }

    private int getRealItemCount() {
        int count = 0;
        for (NavigationSectionDescriptor section : this.mSections) {
            count += section.size();
        }
        return count;
    }

    public Object getItem(int position) {
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        Object item = this.getItem(position);
        if (item instanceof CompositeNavigationItemDescriptor) {
            return ((CompositeNavigationItemDescriptor)item).getId();
        }
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view;
        Context context = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        switch (this.getItemViewType(position)) {
            case 1: {
                if (convertView == null) {
                    view = inflater.inflate(R.layout.mnd_padding, parent, false);
                    break;
                }
                view = convertView;
                break;
            }
            case 0: {
                view = convertView == null ? inflater.inflate(R.layout.mnd_heading, parent, false) : convertView;
                NavigationSectionDescriptor section = (NavigationSectionDescriptor)this.getItem(position);
                TextView text = (TextView)view;
                text.setText((CharSequence)section.getHeading(context));
                break;
            }
            case 2: {
                view = convertView == null ? inflater.inflate(R.layout.mnd_separator, parent, false) : convertView;
                int lastPosition = this.getCount() - 1;
                Object divider = ViewHolder.get(view, R.id.divider);
                divider.setBackgroundColor(Utils.createDividerColor(context));
                divider.setVisibility(position < lastPosition ? 0 : 4);
                break;
            }
            default: {
                CompositeNavigationItemDescriptor item = (CompositeNavigationItemDescriptor)this.getItem(position);
                view = convertView == null || !item.isRecyclable() ? item.createView(context, parent) : convertView;
                item.bindView(view, position == this.mSelectedPosition);
                break;
            }
        }
        return view;
    }

    private void calculateViewTypesAndItems() {
        this.mItemViewTypeSet.clear();
        this.mViewTypes.clear();
        this.mItems.clear();
        if (this.mSections == null) {
            this.mPositions = new SparseIntArray();
            return;
        }
        SparseIntArray positions = new SparseIntArray();
        int position = 0;
        for (int i = 0; i < this.mSections.size(); ++i) {
            NavigationSectionDescriptor section = this.mSections.get(i);
            boolean hasHeading = section.hasHeading();
            this.mViewTypes.put(position, hasHeading ? 0 : 1);
            this.mItems.put(position, (Object)section);
            ++position;
            for (int j = 0; j < section.size(); ++j) {
                int viewType;
                CompositeNavigationItemDescriptor item = (CompositeNavigationItemDescriptor)section.get(j);
                int key = item.getClass().hashCode();
                if (this.mItemViewTypeSet.indexOfKey(key) >= 0) {
                    viewType = this.mItemViewTypeSet.get(key);
                } else {
                    viewType = 3 + this.mItemViewTypeSet.size();
                    this.mItemViewTypeSet.put(key, viewType);
                }
                this.mViewTypes.put(position, viewType);
                this.mItems.put(position, (Object)item);
                positions.put(item.getId(), position);
                ++position;
            }
            this.mViewTypes.put(position, 2);
            ++position;
        }
        this.mPositions = positions;
    }

    public int getPositionById(int id2) {
        return this.mPositions.get(id2, -1);
    }
}

