/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.internal;

import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.SparseArray;

public class ColorFilterStateListDrawable
extends StateListDrawable {
    private SparseArray<ColorFilter> mFilters = new SparseArray();
    private int mCount = 0;
    private int mSelected = -1;

    public void addState(int[] stateSet, Drawable drawable) {
        super.addState(stateSet, drawable);
        ++this.mCount;
    }

    public void addState(int[] stateSet, Drawable drawable, int color2) {
        int index = this.mCount;
        this.addState(stateSet, drawable);
        this.mFilters.put(index, (Object)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
    }

    public boolean selectDrawable(int idx) {
        if (this.mSelected != idx) {
            this.setColorFilter(this.getColorFilter(idx));
        }
        boolean result = super.selectDrawable(idx);
        if (this.getCurrent() != null) {
            int n = this.mSelected = result ? idx : this.mSelected;
            if (!result) {
                this.setColorFilter(this.getColorFilter(this.mSelected));
            }
        } else {
            this.mSelected = -1;
            this.setColorFilter(null);
        }
        return result;
    }

    private ColorFilter getColorFilter(int index) {
        return this.mFilters != null ? (ColorFilter)this.mFilters.get(index) : null;
    }
}

