/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.descriptors;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.TextView;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.descriptors.BaseNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;
import net.xpece.material.navigationdrawer.internal.ViewHolder;

public class SimpleNavigationItemDescriptor
extends BaseNavigationItemDescriptor {
    private String badge = null;
    @StringRes
    private int badgeId = 0;
    int badgeColor = -16777216;
    @ColorRes
    int badgeColorId = 17170444;
    @AttrRes
    int badgeColorAttr = 0x1010030;

    public SimpleNavigationItemDescriptor(int id2) {
        super(id2);
    }

    public SimpleNavigationItemDescriptor badge(String badge) {
        this.badge = badge;
        this.badgeId = 0;
        return this;
    }

    public SimpleNavigationItemDescriptor badge(@StringRes int badge) {
        this.badgeId = badge;
        this.badge = null;
        return this;
    }

    public String getBadge(Context context) {
        if (this.badgeId != 0) {
            return context.getString(this.badgeId);
        }
        return this.badge;
    }

    public SimpleNavigationItemDescriptor badgeColor(int color2) {
        this.badgeColor = color2;
        this.badgeColorId = 0;
        this.badgeColorAttr = 0;
        return this;
    }

    public SimpleNavigationItemDescriptor badgeColorResource(@ColorRes int color2) {
        this.badgeColorId = color2;
        this.badgeColorAttr = 0;
        this.badgeColor = 0;
        return this;
    }

    public SimpleNavigationItemDescriptor badgeColorAttribute(@AttrRes int color2) {
        this.badgeColorAttr = color2;
        this.badgeColorId = 0;
        this.badgeColor = 0;
        return this;
    }

    public int getBadgeColor(Context context) {
        if (this.badgeColorAttr != 0) {
            return Utils.getColor(context, this.badgeColorAttr, -16777216);
        }
        if (this.badgeColorId != 0) {
            return context.getResources().getColor(this.badgeColorId);
        }
        return this.badgeColor;
    }

    @Override
    public SimpleNavigationItemDescriptor sticky() {
        return (SimpleNavigationItemDescriptor)super.sticky();
    }

    @Override
    public SimpleNavigationItemDescriptor notSticky() {
        return (SimpleNavigationItemDescriptor)super.notSticky();
    }

    @Override
    public SimpleNavigationItemDescriptor iconResource(@DrawableRes int icon) {
        return (SimpleNavigationItemDescriptor)super.iconResource(icon);
    }

    @Override
    public SimpleNavigationItemDescriptor iconColorAlwaysPassiveOff() {
        return (SimpleNavigationItemDescriptor)super.iconColorAlwaysPassiveOff();
    }

    @Override
    public SimpleNavigationItemDescriptor iconColorAlwaysPassiveOn() {
        return (SimpleNavigationItemDescriptor)super.iconColorAlwaysPassiveOn();
    }

    @Override
    public SimpleNavigationItemDescriptor text(String text) {
        return (SimpleNavigationItemDescriptor)super.text(text);
    }

    @Override
    public SimpleNavigationItemDescriptor text(@StringRes int text) {
        return (SimpleNavigationItemDescriptor)super.text(text);
    }

    @Override
    public SimpleNavigationItemDescriptor activeColor(int color2) {
        return (SimpleNavigationItemDescriptor)super.activeColor(color2);
    }

    @Override
    public SimpleNavigationItemDescriptor activeColorResource(@ColorRes int color2) {
        return (SimpleNavigationItemDescriptor)super.activeColorResource(color2);
    }

    @Override
    public SimpleNavigationItemDescriptor activeColorAttribute(@AttrRes int color2) {
        return (SimpleNavigationItemDescriptor)super.activeColorAttribute(color2);
    }

    @Override
    public SimpleNavigationItemDescriptor passiveColor(int color2) {
        return (SimpleNavigationItemDescriptor)super.passiveColor(color2);
    }

    @Override
    public SimpleNavigationItemDescriptor passiveColorResource(@ColorRes int color2) {
        return (SimpleNavigationItemDescriptor)super.passiveColorResource(color2);
    }

    @Override
    public SimpleNavigationItemDescriptor passiveColorAttribute(@AttrRes int color2) {
        return (SimpleNavigationItemDescriptor)super.passiveColorAttribute(color2);
    }

    @Override
    public SimpleNavigationItemDescriptor enable() {
        return (SimpleNavigationItemDescriptor)super.enable();
    }

    @Override
    public SimpleNavigationItemDescriptor disable() {
        return (SimpleNavigationItemDescriptor)super.disable();
    }

    @Override
    public SimpleNavigationItemDescriptor activatedBackground(Drawable drawable) {
        return (SimpleNavigationItemDescriptor)super.activatedBackground(drawable);
    }

    @Override
    public SimpleNavigationItemDescriptor activatedBackgroundResource(@ColorRes int drawable) {
        return (SimpleNavigationItemDescriptor)super.activatedBackgroundResource(drawable);
    }

    @Override
    public SimpleNavigationItemDescriptor activatedBackgroundAttribute(@AttrRes int drawable) {
        return (SimpleNavigationItemDescriptor)super.activatedBackgroundAttribute(drawable);
    }

    @Override
    public SimpleNavigationItemDescriptor clearActivatedBackground() {
        return (SimpleNavigationItemDescriptor)super.clearActivatedBackground();
    }

    @Override
    public int getLayoutId() {
        return R.layout.mnd_item_simple;
    }

    @Override
    public void bindView(View view, boolean selected) {
        super.bindView(view, selected);
        Context context = view.getContext();
        TextView badge = (TextView)ViewHolder.get(view, R.id.badge);
        int badgeColor = this.getBadgeColor(context);
        String badgeString = this.getBadge(context);
        if (badgeString != null) {
            badge.setText((CharSequence)badgeString);
            if (badgeColor == 0) {
                badge.setBackgroundColor(0);
                badge.setTextAppearance(context, R.style.TextAppearance_MaterialNavigationDrawer_Badge_NoBackground);
                int textColor = selected ? Utils.getColor(context, 16842806, -570425344) : Utils.getColor(context, 16842808, -1996488704);
                badge.setTextColor(textColor);
            } else {
                Utils.setBackground((View)badge, Utils.createRoundRect(context, badgeColor, 1));
                badge.setTextAppearance(context, R.style.TextAppearance_MaterialNavigationDrawer_Badge);
                badge.setTextColor(Utils.computeTextColor(context, badgeColor));
            }
            badge.setVisibility(0);
        } else {
            badge.setVisibility(8);
        }
    }

    @Override
    public String toString() {
        return "SimpleNavigationItemDescriptor{id=" + this.id + "sticky=" + this.sticky + '}';
    }
}

