/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.descriptors;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import net.xpece.material.navigationdrawer.descriptors.CompositeNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;

public abstract class AbsNavigationItemDescriptor
implements CompositeNavigationItemDescriptor {
    protected int id;
    protected Drawable activatedBackground = null;
    @DrawableRes
    protected int activatedBackgroundId = 0;
    @AttrRes
    protected int activatedBackgroundAttr = 0;
    private boolean customActivatedBackground = false;

    protected AbsNavigationItemDescriptor(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void bindView(View view, boolean selected) {
        if (selected) {
            Utils.setBackground(view, this.getActivatedBackground(view.getContext()));
        } else {
            view.setBackgroundColor(0);
        }
    }

    @Override
    public final View createView(Context context, ViewGroup parent) {
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), parent, false);
        this.onViewCreated(view);
        return view;
    }

    public abstract int getLayoutId();

    public void onViewCreated(View view) {
    }

    public AbsNavigationItemDescriptor activatedBackground(Drawable background) {
        this.customActivatedBackground = true;
        this.activatedBackground = background;
        this.activatedBackgroundId = 0;
        this.activatedBackgroundAttr = 0;
        return this;
    }

    public AbsNavigationItemDescriptor activatedBackgroundResource(@DrawableRes int background) {
        this.customActivatedBackground = true;
        this.activatedBackgroundId = background;
        this.activatedBackground = null;
        this.activatedBackgroundAttr = 0;
        return this;
    }

    public AbsNavigationItemDescriptor activatedBackgroundAttribute(@AttrRes int background) {
        this.customActivatedBackground = true;
        this.activatedBackgroundAttr = background;
        this.activatedBackgroundId = 0;
        this.activatedBackground = null;
        return this;
    }

    public AbsNavigationItemDescriptor clearActivatedBackground() {
        this.customActivatedBackground = false;
        this.activatedBackground = null;
        this.activatedBackgroundAttr = 0;
        this.activatedBackgroundId = 0;
        return this;
    }

    public Drawable getActivatedBackground(Context context) {
        if (!this.customActivatedBackground) {
            return Utils.getActivatedDrawable(context);
        }
        if (this.activatedBackgroundAttr != 0) {
            return Utils.getDrawableAttr(context, this.activatedBackgroundAttr);
        }
        if (this.activatedBackgroundId != 0) {
            return ContextCompat.getDrawable((Context)context, (int)this.activatedBackgroundId);
        }
        return this.activatedBackground;
    }

    @Override
    public boolean onClick(View view) {
        return false;
    }

    public String toString() {
        return "AbsNavigationItemDescriptor{id=" + this.id + '}';
    }

    @Override
    public boolean isRecyclable() {
        return false;
    }
}

