/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.descriptors;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import net.xpece.material.navigationdrawer.descriptors.CompositeNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;

public abstract class AbsNavigationItemDescriptor
implements CompositeNavigationItemDescriptor {
    protected long id;

    protected AbsNavigationItemDescriptor(long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public void loadInto(View view, boolean selected) {
        if (selected) {
            Utils.setBackground(view, Utils.getActivatedDrawable(view.getContext()));
        } else {
            view.setBackgroundColor(0);
        }
    }

    @Override
    public final View createView(Context context, ViewGroup parent) {
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), parent, false);
        this.onViewCreated(view);
        return view;
    }

    public abstract int getLayoutId();

    public void onViewCreated(View view) {
    }

    @Override
    public boolean onClick(View view) {
        return false;
    }

    public String toString() {
        return "AbsNavigationItemDescriptor{id=" + this.id + '}';
    }
}

