/*
 * Decompiled with CFR 0.152.
 */
package com.sqisland.android.sliding_pane_layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.v4.widget.SlidingPaneLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.nineoldandroids.view.ViewHelper;

public class CrossFadeSlidingPaneLayout
extends SlidingPaneLayout {
    private View partialView = null;
    private View fullView = null;
    private boolean mWasOpened = false;
    private SlidingPaneLayout.SimplePanelSlideListener crossFadeListener = new SlidingPaneLayout.SimplePanelSlideListener(){

        public void onPanelSlide(View panel, float slideOffset) {
            super.onPanelSlide(panel, slideOffset);
            if (CrossFadeSlidingPaneLayout.this.partialView == null || CrossFadeSlidingPaneLayout.this.fullView == null) {
                return;
            }
            CrossFadeSlidingPaneLayout.this.updateVisibility(slideOffset);
            CrossFadeSlidingPaneLayout.setAlpha(CrossFadeSlidingPaneLayout.this.partialView, 1.0f - slideOffset);
        }
    };

    public CrossFadeSlidingPaneLayout(Context context) {
        super(context);
    }

    public CrossFadeSlidingPaneLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CrossFadeSlidingPaneLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() < 1) {
            return;
        }
        View panel = this.getChildAt(0);
        if (!(panel instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)panel;
        if (viewGroup.getChildCount() != 2) {
            return;
        }
        this.fullView = viewGroup.getChildAt(0);
        this.partialView = viewGroup.getChildAt(1);
        super.setPanelSlideListener((SlidingPaneLayout.PanelSlideListener)this.crossFadeListener);
    }

    public void setPanelSlideListener(final SlidingPaneLayout.PanelSlideListener listener) {
        if (listener == null) {
            super.setPanelSlideListener((SlidingPaneLayout.PanelSlideListener)this.crossFadeListener);
            return;
        }
        super.setPanelSlideListener(new SlidingPaneLayout.PanelSlideListener(){

            public void onPanelSlide(View panel, float slideOffset) {
                CrossFadeSlidingPaneLayout.this.crossFadeListener.onPanelSlide(panel, slideOffset);
                listener.onPanelSlide(panel, slideOffset);
            }

            public void onPanelOpened(View panel) {
                CrossFadeSlidingPaneLayout.this.crossFadeListener.onPanelOpened(panel);
                listener.onPanelOpened(panel);
            }

            public void onPanelClosed(View panel) {
                CrossFadeSlidingPaneLayout.this.crossFadeListener.onPanelClosed(panel);
                listener.onPanelClosed(panel);
            }
        });
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.partialView != null) {
            this.updateVisibility(this.isOpen());
        }
    }

    private void updateVisibility(float slideOffset) {
        if (Build.VERSION.SDK_INT < 11) {
            this.updateVisibilityBase(slideOffset);
        } else {
            this.updateVisibilityHoneycomb(slideOffset == 1.0f);
        }
    }

    private void updateVisibility(boolean visible) {
        if (Build.VERSION.SDK_INT < 11) {
            this.updateVisibilityBase(visible);
        } else {
            this.updateVisibilityHoneycomb(visible);
        }
    }

    private void updateVisibilityBase(float slideOffset) {
        if (slideOffset == 1.0f && !this.mWasOpened) {
            this.updateVisibilityBase(true);
            this.mWasOpened = true;
        } else if (slideOffset < 1.0f && this.mWasOpened) {
            this.updateVisibilityBase(false);
            this.mWasOpened = false;
        }
    }

    private void updateVisibilityBase(boolean visible) {
        if (visible) {
            this.partialView.layout(-this.partialView.getWidth(), 0, 0, this.partialView.getHeight());
        } else {
            this.partialView.layout(0, 0, this.partialView.getWidth(), this.partialView.getHeight());
        }
    }

    private void updateVisibilityHoneycomb(boolean visible) {
        this.partialView.setVisibility(visible ? 8 : 0);
    }

    @TargetApi(value=11)
    private static void setAlpha(View view, float alpha) {
        ViewHelper.setAlpha((View)view, (float)alpha);
    }
}

