/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.descriptors;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import net.xpece.material.navigationdrawer.descriptors.CompositeNavigationItemDescriptor;

public final class NavigationSectionDescriptor
extends ArrayList<CompositeNavigationItemDescriptor> {
    private String heading;
    private int headingId;

    public NavigationSectionDescriptor heading(String heading) {
        this.heading = heading;
        this.headingId = 0;
        return this;
    }

    public NavigationSectionDescriptor heading(int heading) {
        this.headingId = heading;
        this.heading = null;
        return this;
    }

    public NavigationSectionDescriptor addItems(List<? extends CompositeNavigationItemDescriptor> items) {
        this.addAll(items);
        return this;
    }

    public NavigationSectionDescriptor addItem(CompositeNavigationItemDescriptor item) {
        this.add(item);
        return this;
    }

    public String getHeading(Context context) {
        if (this.headingId != 0) {
            return context.getString(this.headingId);
        }
        return this.heading;
    }

    public boolean hasHeading() {
        return this.heading != null || this.headingId != 0;
    }

    @Override
    public String toString() {
        return "NavigationSectionDescriptor{" + (this.heading == null ? "" : "heading='" + this.heading + '\'') + (this.headingId == 0 ? "" : ", headingId=" + this.headingId) + ", items=" + super.toString() + '}';
    }
}

