/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.list;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.util.LongSparseArray;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.List;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.descriptors.GraphicNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.NavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.NavigationSectionDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;

class CompactNavigationListAdapter
extends BaseAdapter {
    private static final String TAG = CompactNavigationListAdapter.class.getSimpleName();
    private List<NavigationSectionDescriptor> mSections = new ArrayList<NavigationSectionDescriptor>(0);
    private SparseArray<GraphicNavigationItemDescriptor> mItems = new SparseArray();
    private LongSparseArray<Integer> mPositions = null;
    private int mSelectedPosition = -1;

    public CompactNavigationListAdapter(List<NavigationSectionDescriptor> sections) {
        this.setSections(sections);
    }

    private void setSections(List<NavigationSectionDescriptor> sections) {
        this.notifyDataSetInvalidated();
        this.mSections = sections;
        this.calculateViewTypesAndItems();
        this.notifyDataSetChanged();
    }

    public void setActivatedItem(int position) {
        if (this.mSelectedPosition != position) {
            this.mSelectedPosition = position;
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetInvalidated() {
        this.mPositions = null;
        super.notifyDataSetInvalidated();
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public boolean isEnabled(int position) {
        return position != this.mSelectedPosition;
    }

    public int getCount() {
        return this.getRealItemCount();
    }

    private int getRealItemCount() {
        int count = 0;
        for (NavigationSectionDescriptor section : this.mSections) {
            count += section.size();
        }
        return count;
    }

    public GraphicNavigationItemDescriptor getItem(int position) {
        return (GraphicNavigationItemDescriptor)this.mItems.get(position);
    }

    public long getItemId(int position) {
        GraphicNavigationItemDescriptor item = this.getItem(position);
        if (item instanceof GraphicNavigationItemDescriptor) {
            return item.getId();
        }
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        boolean selected;
        ImageView view;
        Context context = parent.getContext();
        GraphicNavigationItemDescriptor item = this.getItem(position);
        if (convertView == null) {
            view = new ImageView(context);
            int minSize = context.getResources().getDimensionPixelSize(R.dimen.mnd_list_item_height_normal);
            view.setMinimumHeight(minSize);
            view.setMinimumWidth(minSize);
            view.setScaleType(ImageView.ScaleType.CENTER);
        } else {
            view = (ImageView)convertView;
        }
        Drawable iconDrawable = item.getIcon(context);
        boolean tintIcon = item.isIconColorAlwaysPassiveOff();
        int passiveColor = item.getPassiveColor(context);
        int activeColor = item.getActiveColor(context);
        String textString = item.getText(context);
        boolean bl = selected = position == this.mSelectedPosition;
        if (iconDrawable != null) {
            if (tintIcon && selected) {
                view.setImageDrawable(Utils.tintDrawable(iconDrawable, activeColor));
            } else {
                view.setImageDrawable(Utils.tintDrawable(iconDrawable, passiveColor));
            }
        } else {
            view.setImageDrawable(null);
        }
        view.setContentDescription((CharSequence)textString);
        if (selected) {
            Utils.setBackground((View)view, Utils.getActivatedDrawable(context));
        } else {
            view.setBackgroundColor(0);
        }
        return view;
    }

    private void calculateViewTypesAndItems() {
        this.mItems.clear();
        if (this.mSections == null) {
            this.mPositions = new LongSparseArray(0);
            return;
        }
        LongSparseArray positions = new LongSparseArray();
        int position = 0;
        for (int i = 0; i < this.mSections.size(); ++i) {
            NavigationSectionDescriptor section = this.mSections.get(i);
            for (int j = 0; j < section.size(); ++j) {
                NavigationItemDescriptor item = (NavigationItemDescriptor)section.get(j);
                if (!(item instanceof GraphicNavigationItemDescriptor)) continue;
                this.mItems.put(position, (Object)((GraphicNavigationItemDescriptor)item));
                positions.put(item.getId(), (Object)position);
                ++position;
            }
        }
        this.mPositions = positions;
    }

    public int getPositionById(long id2) {
        return (Integer)this.mPositions.get(id2, (Object)-1);
    }
}

