/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.descriptors;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.descriptors.AbsNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.GraphicNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;
import net.xpece.material.navigationdrawer.internal.ViewHolder;

public class BaseNavigationItemDescriptor
extends AbsNavigationItemDescriptor
implements GraphicNavigationItemDescriptor {
    protected boolean sticky = false;
    protected int iconId = 0;
    protected String text = null;
    protected int textId = 0;
    protected int activeColor = -16777216;
    protected int activeColorId = R.color.mnd_text_primary_light;
    protected int passiveColor = -570425344;
    protected int passiveColorId = R.color.mnd_text_secondary_light;
    int activeColorAttr = 16842806;
    int passiveColorAttr = 16842808;
    private Drawable icon = null;
    private boolean tintIcon = true;
    private boolean customPassiveColor = false;

    public BaseNavigationItemDescriptor(long id2) {
        super(id2);
    }

    public BaseNavigationItemDescriptor iconResource(int icon) {
        this.iconId = icon;
        this.icon = null;
        return this;
    }

    @Override
    public Drawable getIcon(Context context) {
        if (this.iconId != 0) {
            return context.getResources().getDrawable(this.iconId).mutate();
        }
        return this.icon;
    }

    public BaseNavigationItemDescriptor iconColorAlwaysPassiveOff() {
        this.tintIcon = true;
        return this;
    }

    public BaseNavigationItemDescriptor iconColorAlwaysPassiveOn() {
        this.tintIcon = false;
        return this;
    }

    @Override
    public boolean isIconColorAlwaysPassiveOff() {
        return this.tintIcon;
    }

    public BaseNavigationItemDescriptor text(String text) {
        this.text = text;
        this.textId = 0;
        return this;
    }

    public BaseNavigationItemDescriptor text(int text) {
        this.textId = text;
        this.text = null;
        return this;
    }

    @Override
    public String getText(Context context) {
        if (this.textId != 0) {
            return context.getString(this.textId);
        }
        return this.text;
    }

    public BaseNavigationItemDescriptor activeColor(int color2) {
        this.activeColor = color2;
        this.activeColorId = 0;
        this.activeColorAttr = 0;
        return this;
    }

    public BaseNavigationItemDescriptor activeColorResource(int color2) {
        this.activeColorId = color2;
        this.activeColor = 0;
        this.activeColorAttr = 0;
        return this;
    }

    public BaseNavigationItemDescriptor activeColorAttribute(int color2) {
        this.activeColorAttr = color2;
        this.activeColorId = 0;
        this.activeColor = 0;
        return this;
    }

    @Override
    public int getActiveColor(Context context) {
        if (this.activeColorAttr != 0) {
            return Utils.getColor(context, this.activeColorAttr, -16777216);
        }
        if (this.activeColorId != 0) {
            return context.getResources().getColor(this.activeColorId);
        }
        return this.activeColor;
    }

    public BaseNavigationItemDescriptor passiveColor(int color2) {
        this.customPassiveColor = true;
        this.passiveColor = color2;
        this.passiveColorId = 0;
        this.passiveColorAttr = 0;
        return this;
    }

    public BaseNavigationItemDescriptor passiveColorResource(int color2) {
        this.customPassiveColor = true;
        this.passiveColorId = color2;
        this.passiveColorAttr = 0;
        this.passiveColor = 0;
        return this;
    }

    public BaseNavigationItemDescriptor passiveColorAttribute(int color2) {
        this.customPassiveColor = true;
        this.passiveColorAttr = color2;
        this.passiveColorId = 0;
        this.passiveColor = 0;
        return this;
    }

    @Override
    public int getPassiveColor(Context context) {
        if (!this.customPassiveColor) {
            int secondary = Utils.getColor(context, 16842808, -570425344);
            if ((secondary & 0xFFFFFF) == 0xFFFFFF) {
                return Utils.getColor(context, 16842806, -1);
            }
            return secondary;
        }
        if (this.passiveColorAttr != 0) {
            return Utils.getColor(context, this.passiveColorAttr, -570425344);
        }
        if (this.passiveColorId != 0) {
            return context.getResources().getColor(this.passiveColorId);
        }
        return this.passiveColor;
    }

    public BaseNavigationItemDescriptor sticky() {
        this.sticky = true;
        return this;
    }

    public BaseNavigationItemDescriptor notSticky() {
        this.sticky = false;
        return this;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    @Override
    public int getLayoutId() {
        return R.layout.mnd_item_base;
    }

    @Override
    public void loadInto(View view, boolean selected) {
        super.loadInto(view, selected);
        Context context = view.getContext();
        ImageView icon = (ImageView)ViewHolder.get(view, R.id.icon);
        TextView text = (TextView)ViewHolder.get(view, R.id.text);
        Drawable iconDrawable = this.getIcon(context);
        boolean tintIcon = this.isIconColorAlwaysPassiveOff();
        int passiveColor = this.getPassiveColor(context);
        int activeColor = this.getActiveColor(context);
        String textString = this.getText(context);
        int textColor = Utils.getColor(context, 16842806, -570425344);
        text.setText((CharSequence)textString);
        if (selected) {
            text.setTextAppearance(context, R.style.TextAppearance_MaterialNavigationDrawer_Item_Selected);
            text.setTextColor(activeColor);
        } else {
            text.setTextAppearance(context, R.style.TextAppearance_MaterialNavigationDrawer_Item);
            text.setTextColor(textColor);
        }
        if (iconDrawable != null) {
            if (tintIcon) {
                if (selected) {
                    icon.setImageDrawable(Utils.tintDrawable(iconDrawable, activeColor));
                } else {
                    icon.setImageDrawable(Utils.tintDrawable(iconDrawable, passiveColor));
                }
            } else {
                icon.setImageDrawable(Utils.tintDrawable(iconDrawable, passiveColor));
            }
            icon.setVisibility(0);
        } else {
            icon.setVisibility(8);
            icon.setImageDrawable(null);
        }
    }

    @Override
    public String toString() {
        return "BaseNavigationItemDescriptor{id=" + this.id + "sticky=" + this.sticky + '}';
    }
}

