/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.list;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.List;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.descriptors.CompositeNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.NavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.NavigationSectionDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;
import net.xpece.material.navigationdrawer.list.NavigationListAdapter;
import net.xpece.material.navigationdrawer.list.NavigationListFragmentCallbacks;
import net.xpece.material.navigationdrawer.list.NavigationListFragmentImpl;

abstract class NavigationListFragmentDelegate
implements AdapterView.OnItemClickListener,
NavigationListFragmentImpl {
    public static final String TAG = NavigationListFragmentDelegate.class.getSimpleName();
    private static final NavigationListFragmentCallbacks DUMMY_CALLBACKS = new NavigationListFragmentCallbacks(){

        @Override
        public void onNavigationItemSelected(View view, int position, long id2, NavigationItemDescriptor item) {
        }
    };
    private NavigationListFragmentCallbacks mCallbacks = DUMMY_CALLBACKS;
    private ListView mListView;
    private ViewGroup mPinnedContainer;
    private View mPinnedDivider;
    private int mTheFix = 0;
    private final ViewTreeObserver.OnGlobalLayoutListener mPinnedContainerOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            int pinnedHeight;
            int targetPadding;
            int lastPosition;
            int fix = 0;
            int paddingBottom = NavigationListFragmentDelegate.this.mListView.getPaddingBottom();
            int lastVisible = NavigationListFragmentDelegate.this.mListView.getLastVisiblePosition();
            if (lastVisible == (lastPosition = NavigationListFragmentDelegate.this.mListView.getAdapter().getCount() - 1)) {
                int listHeight = NavigationListFragmentDelegate.this.mListView.getMeasuredHeight() - paddingBottom - NavigationListFragmentDelegate.this.mListView.getPaddingTop();
                int lastBottom = NavigationListFragmentDelegate.this.mListView.getChildAt(NavigationListFragmentDelegate.this.mListView.getLastVisiblePosition() - NavigationListFragmentDelegate.this.mListView.getFirstVisiblePosition()).getBottom();
                if (lastBottom < listHeight) {
                    if (paddingBottom == 0) {
                        NavigationListFragmentDelegate.this.mTheFix = Math.max(0, listHeight - lastBottom);
                    }
                    fix = NavigationListFragmentDelegate.this.mTheFix;
                }
            }
            if (paddingBottom != (targetPadding = (pinnedHeight = NavigationListFragmentDelegate.this.mPinnedContainer.getMeasuredHeight()) - fix - Utils.dpToPixelOffset((Context)NavigationListFragmentDelegate.this.getActivity(), 1))) {
                NavigationListFragmentDelegate.this.mListView.setPadding(0, 0, 0, targetPadding);
            }
            if (NavigationListFragmentDelegate.this.getView() == null) {
                return;
            }
            int parentHeight = NavigationListFragmentDelegate.this.getView().getHeight();
            int pinnedBottom = NavigationListFragmentDelegate.this.mPinnedContainer.getBottom();
            if (pinnedBottom >= parentHeight) {
                int colorBackground = Utils.getColor(NavigationListFragmentDelegate.this.getView().getContext(), 0x1010031, 0);
                if (Build.VERSION.SDK_INT < 21 || (colorBackground & 0xFFFFFF) < 0x7FFFFF) {
                    ViewCompat.setElevation((View)NavigationListFragmentDelegate.this.mPinnedContainer, (float)0.0f);
                    NavigationListFragmentDelegate.this.mPinnedDivider.setVisibility(0);
                } else {
                    ViewCompat.setElevation((View)NavigationListFragmentDelegate.this.mPinnedContainer, (float)NavigationListFragmentDelegate.this.getActivity().getResources().getDimension(R.dimen.mnd_unit));
                    NavigationListFragmentDelegate.this.mPinnedDivider.setVisibility(8);
                }
            } else {
                ViewCompat.setElevation((View)NavigationListFragmentDelegate.this.mPinnedContainer, (float)0.0f);
                NavigationListFragmentDelegate.this.mPinnedDivider.setVisibility(0);
            }
            if (paddingBottom == targetPadding) {
                Utils.removeOnGlobalLayoutListener((View)NavigationListFragmentDelegate.this.mPinnedContainer, NavigationListFragmentDelegate.this.mPinnedContainerOnGlobalLayoutListener);
            }
        }
    };
    private NavigationListAdapter mAdapter;
    private int mLastSelected = -1;
    private List<NavigationSectionDescriptor> mSections = new ArrayList<NavigationSectionDescriptor>(0);
    private List<CompositeNavigationItemDescriptor> mPinnedSection = null;
    private View mHeader = null;

    public abstract Activity getActivity();

    public abstract View getView();

    @Override
    public void onAttach(Activity activity) {
        this.mCallbacks = (NavigationListFragmentCallbacks)activity;
    }

    @Override
    public void onDetach() {
        this.mCallbacks = DUMMY_CALLBACKS;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putInt("mLastSelected", this.mLastSelected);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.mnd_list, container, false);
        this.mListView = (ListView)view.findViewById(R.id.mnd_list);
        this.mPinnedContainer = (ViewGroup)view.findViewById(R.id.mnd_section_pinned);
        this.mPinnedDivider = view.findViewById(R.id.mnd_divider_pinned);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        Context context = view.getContext();
        this.mPinnedDivider.setBackgroundColor(Utils.createDividerColor(context));
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mListView.setSelector(Utils.getSelectorDrawable(context));
        if (savedInstanceState != null) {
            this.mLastSelected = savedInstanceState.getInt("mLastSelected");
        }
    }

    @Override
    public void setItems(List<? extends CompositeNavigationItemDescriptor> items) {
        NavigationSectionDescriptor section = new NavigationSectionDescriptor().addItems(items);
        ArrayList<NavigationSectionDescriptor> sections = new ArrayList<NavigationSectionDescriptor>(1);
        sections.add(section);
        this.setSections(sections);
    }

    @Override
    public void setSections(List<NavigationSectionDescriptor> sections) {
        this.mSections = sections;
        this.updateSections();
    }

    private void updateSections() {
        if (this.getView() == null) {
            return;
        }
        this.mAdapter = new NavigationListAdapter(this.mSections);
        this.mAdapter.setActivatedItem(this.mLastSelected - this.getHeaderViewsCount());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mPinnedContainer.getViewTreeObserver().addOnGlobalLayoutListener(this.mPinnedContainerOnGlobalLayoutListener);
    }

    @Override
    public void setPinnedSection(NavigationSectionDescriptor section) {
        if (section == null || !section.equals(this.mPinnedSection)) {
            this.mPinnedSection = section;
            this.updatePinnedSection();
        }
    }

    private void updatePinnedSection() {
        int targetCount;
        if (this.getView() == null) {
            return;
        }
        Drawable selector = Utils.getSelectorDrawable(this.getView().getContext());
        int offset = 2;
        int n = targetCount = this.mPinnedSection == null ? 0 : this.mPinnedSection.size();
        while (this.mPinnedContainer.getChildCount() > 2) {
            View view = this.mPinnedContainer.getChildAt(2);
            view.setOnClickListener(null);
            this.mPinnedContainer.removeView(view);
        }
        int currentCount = this.mPinnedContainer.getChildCount() - 2;
        int i = 0;
        while (i < targetCount) {
            View view;
            final CompositeNavigationItemDescriptor item = this.mPinnedSection.get(i);
            if (i < currentCount) {
                view = this.mPinnedContainer.getChildAt(i + 2);
                item.loadInto(view, false);
            } else {
                Activity context = this.getActivity();
                view = item.createView((Context)context, this.mPinnedContainer);
                this.mPinnedContainer.addView(view);
            }
            Utils.setBackground(view, selector.getConstantState().newDrawable());
            final int relativePosition = i++;
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NavigationListFragmentDelegate.this.onItemClick(v, NavigationListFragmentDelegate.this.mAdapter.getCount() + relativePosition, item.getId(), item);
                }
            });
        }
        if (targetCount > 0) {
            this.mPinnedContainer.setVisibility(0);
        } else {
            this.mPinnedContainer.setVisibility(8);
        }
        this.mPinnedContainer.getViewTreeObserver().addOnGlobalLayoutListener(this.mPinnedContainerOnGlobalLayoutListener);
    }

    @Override
    public void setHeaderView(View view, boolean clickable) {
        if (view == this.mHeader) {
            return;
        }
        if (this.mHeader != null) {
            this.mListView.removeHeaderView(this.mHeader);
        }
        if (view != null && this.mListView != null) {
            if (Build.VERSION.SDK_INT < 19) {
                if (this.mListView.getAdapter() != null) {
                    this.mListView.setAdapter(null);
                }
                this.mListView.addHeaderView(view, null, clickable);
                if (this.mAdapter != null) {
                    this.mListView.setAdapter((ListAdapter)this.mAdapter);
                }
            } else {
                this.mListView.addHeaderView(view);
            }
        }
        this.mHeader = view;
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void setBackgroundColor(int color2) {
        if (this.getView() != null) {
            this.getView().setBackgroundColor(color2);
            this.mPinnedContainer.setBackgroundColor(color2);
        }
    }

    @Override
    public void setBackground(Drawable drawable) {
        if (this.getView() != null) {
            Utils.setBackground(this.getView(), drawable);
            Utils.setBackground((View)this.mPinnedContainer, drawable);
        }
    }

    @Override
    public void setBackgroundResource(int resource) {
        if (this.getView() != null) {
            this.getView().setBackgroundResource(resource);
            this.mPinnedContainer.setBackgroundResource(resource);
        }
    }

    @Override
    public void setBackgroundAttr(int attr) {
        Drawable d = Utils.getDrawable((Context)this.getActivity(), attr);
        this.setBackground(d);
    }

    @Override
    public void setSelectedItem(long id2) {
        if (this.mAdapter != null) {
            int position = this.mAdapter.getPositionById(id2);
            if (position >= 0 && this.trySelectPosition(position)) {
                this.scrollToPosition(position);
            }
        } else {
            throw new IllegalStateException("No adapter yet!");
        }
    }

    private void scrollToPosition(int position) {
        int last = this.mListView.getLastVisiblePosition();
        int first = this.mListView.getFirstVisiblePosition();
        if (last < position) {
            this.mListView.setSelection(position - (last - first) - 1);
        } else if (first > position) {
            this.mListView.setSelection(position - 1);
        }
    }

    private boolean trySelectPosition(int itemPosition) {
        int listPosition = itemPosition + this.getHeaderViewsCount();
        if (itemPosition < 0) {
            throw new IllegalArgumentException("Position to select is less than 0.");
        }
        CompositeNavigationItemDescriptor item = (CompositeNavigationItemDescriptor)this.mAdapter.getItem(itemPosition);
        if (item != null && item.isSticky()) {
            this.selectPosition(listPosition, this.mLastSelected);
            this.mAdapter.setActivatedItem(itemPosition);
            this.mLastSelected = listPosition;
            return true;
        }
        this.selectPosition(this.mLastSelected, listPosition);
        return false;
    }

    private void selectPosition(int select, int deselect) {
        if (deselect >= 0) {
            this.mListView.setItemChecked(deselect, false);
        }
        if (select >= 0) {
            this.mListView.setItemChecked(this.mLastSelected, true);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        CompositeNavigationItemDescriptor item = (CompositeNavigationItemDescriptor)parent.getItemAtPosition(position);
        this.onItemClick(view, position, id2, item);
    }

    private void onItemClick(View view, int position, long id2, CompositeNavigationItemDescriptor item) {
        if (position < this.getHeaderViewsCount()) {
            this.selectPosition(this.mLastSelected, position);
        } else {
            int itemPosition = position - this.getHeaderViewsCount();
            this.trySelectPosition(itemPosition);
        }
        if (item == null || !item.onClick(view)) {
            this.mCallbacks.onNavigationItemSelected(view, position, id2, item);
        }
    }

    private int getHeaderViewsCount() {
        return this.mListView.getHeaderViewsCount();
    }

    private static void timber(String s) {
    }
}

