/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.list;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.List;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.descriptors.CompositeNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.GraphicNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.NavigationItemDescriptor;
import net.xpece.material.navigationdrawer.descriptors.NavigationSectionDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;
import net.xpece.material.navigationdrawer.list.CompactNavigationListAdapter;
import net.xpece.material.navigationdrawer.list.CompactNavigationListFragmentImpl;
import net.xpece.material.navigationdrawer.list.NavigationListFragmentCallbacks;

abstract class CompactNavigationListFragmentDelegate
implements AdapterView.OnItemClickListener,
CompactNavigationListFragmentImpl {
    public static final String TAG = CompactNavigationListFragmentDelegate.class.getSimpleName();
    private static final NavigationListFragmentCallbacks DUMMY_CALLBACKS = new NavigationListFragmentCallbacks(){

        @Override
        public void onNavigationItemSelected(View view, int position, long id2, NavigationItemDescriptor item) {
        }
    };
    private NavigationListFragmentCallbacks mCallbacks = DUMMY_CALLBACKS;
    private ListView mListView;
    private CompactNavigationListAdapter mAdapter;
    private int mLastSelected = -1;
    private List<NavigationSectionDescriptor> mSections = new ArrayList<NavigationSectionDescriptor>(0);
    private View mHeader = null;

    public abstract Activity getActivity();

    public abstract View getView();

    @Override
    public void onAttach(Activity activity) {
        this.mCallbacks = (NavigationListFragmentCallbacks)activity;
    }

    @Override
    public void onDetach() {
        this.mCallbacks = DUMMY_CALLBACKS;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putInt("mLastSelected", this.mLastSelected);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.mnd_list_compact, container, false);
        this.mListView = (ListView)view.findViewById(R.id.mnd_list_compact);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        if (savedInstanceState != null) {
            this.mLastSelected = savedInstanceState.getInt("mLastSelected");
        }
    }

    @Override
    public void setItems(List<? extends CompositeNavigationItemDescriptor> items) {
        NavigationSectionDescriptor section = new NavigationSectionDescriptor().addItems(items);
        ArrayList<NavigationSectionDescriptor> sections = new ArrayList<NavigationSectionDescriptor>(1);
        sections.add(section);
        this.setSections(sections);
    }

    @Override
    public void setSections(List<NavigationSectionDescriptor> sections) {
        this.mSections = sections;
        this.updateSections();
    }

    private void updateSections() {
        if (this.getView() == null) {
            return;
        }
        this.mAdapter = new CompactNavigationListAdapter(this.mSections);
        this.mAdapter.setActivatedItem(this.mLastSelected);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
    }

    @Override
    public void setHeaderView(View view, boolean clickable) {
        if (view == this.mHeader) {
            return;
        }
        if (this.mHeader != null) {
            this.mListView.removeHeaderView(this.mHeader);
        }
        if (view != null && this.mListView != null) {
            if (Build.VERSION.SDK_INT < 19) {
                if (this.mListView.getAdapter() != null) {
                    this.mListView.setAdapter(null);
                }
                this.mListView.addHeaderView(view, null, clickable);
                if (this.mAdapter != null) {
                    this.mListView.setAdapter((ListAdapter)this.mAdapter);
                }
            } else {
                this.mListView.addHeaderView(view);
            }
        }
        this.mHeader = view;
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void setBackgroundColor(int color2) {
        if (this.getView() != null) {
            this.getView().setBackgroundColor(color2);
        }
    }

    @Override
    public void setBackground(Drawable drawable) {
        if (this.getView() != null) {
            Utils.setBackground(this.getView(), drawable);
        }
    }

    @Override
    public void setBackgroundResource(int resource) {
        if (this.getView() != null) {
            this.getView().setBackgroundResource(resource);
        }
    }

    @Override
    public void setBackgroundAttr(int attr) {
        Drawable d = Utils.getDrawable((Context)this.getActivity(), attr);
        this.setBackground(d);
    }

    @Override
    public void setSelectedItem(long id2) {
        if (this.mAdapter == null) {
            throw new IllegalStateException("No adapter yet!");
        }
        int position = this.mAdapter.getPositionById(id2);
        this.trySelectPosition(position);
    }

    private void trySelectPosition(int itemPosition) {
        int listPosition = itemPosition + this.mListView.getHeaderViewsCount();
        if (itemPosition < 0) {
            this.mListView.setItemChecked(listPosition, false);
            this.mAdapter.setActivatedItem(-1);
            this.mLastSelected = -1;
            return;
        }
        CompositeNavigationItemDescriptor item = (CompositeNavigationItemDescriptor)((Object)this.mAdapter.getItem(itemPosition));
        if (item != null && item.isSticky()) {
            this.mListView.setItemChecked(this.mLastSelected, false);
            this.mListView.setItemChecked(listPosition, true);
            this.mAdapter.setActivatedItem(itemPosition);
            this.mLastSelected = listPosition;
        } else {
            this.selectPreviousPosition(listPosition);
        }
    }

    private void selectPreviousPosition(int deselect) {
        this.mListView.setItemChecked(deselect, false);
        this.mListView.setItemChecked(this.mLastSelected, true);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        GraphicNavigationItemDescriptor item = (GraphicNavigationItemDescriptor)parent.getItemAtPosition(position);
        this.onItemClick(view, position, id2, item);
    }

    private void onItemClick(View view, int position, long id2, GraphicNavigationItemDescriptor item) {
        if (position >= 0 && position < this.mListView.getHeaderViewsCount()) {
            this.selectPreviousPosition(position);
        } else {
            int itemPosition = position - this.mListView.getHeaderViewsCount();
            this.trySelectPosition(itemPosition);
        }
        this.mCallbacks.onNavigationItemSelected(view, position, id2, item);
    }

    private static void timber(String s) {
    }
}

