/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.internal.ColorFilterStateListDrawable;

public class Utils {
    public static final int APPCOMPAT_ATTR_SELECTABLE_ITEM_BACKGROUND;
    public static final int APPCOMPAT_ATTR_ACTIVATED_BACKGROUND_INDICATOR;

    private Utils() {
    }

    public static Drawable createRoundRect(Context context, int color2, int cornerDp) {
        GradientDrawable gd = new GradientDrawable();
        gd.setColor(color2);
        gd.setCornerRadius(Utils.dpToPixel(context, cornerDp));
        return gd;
    }

    public static int dpToPixelSize(Context context, int dp) {
        return Math.round(0.5f + Utils.dpToPixel(context, dp));
    }

    public static int dpToPixelOffset(Context context, int dp) {
        return (int)Utils.dpToPixel(context, dp);
    }

    public static float dpToPixel(Context context, int dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int computeTextColor(Context context, int background) {
        int r = (background & 0xFF0000) >> 16;
        int g = (background & 0xFF00) >> 8;
        int b = background & 0xFF;
        double a = Utils.computeTextColorAlgorithm2(r, g, b);
        if ((int)(a * 100.0) <= 50) {
            return context.getResources().getColor(R.color.mnd_text_primary_dark);
        }
        return context.getResources().getColor(R.color.mnd_text_primary_light);
    }

    private static double computeTextColorAlgorithm0(int r, int g, int b) {
        return ((double)r / 3.0 + (double)g / 3.0 + (double)b / 3.0) / 255.0;
    }

    private static double computeTextColorAlgorithm1(int r, int g, int b) {
        return (0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b) / 255.0;
    }

    private static double computeTextColorAlgorithm2(int r, int g, int b) {
        return (0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b) / 255.0;
    }

    @TargetApi(value=11)
    public static Drawable createActivatedDrawable(Drawable drawable, int passive, int active) {
        ColorFilterStateListDrawable stateful = new ColorFilterStateListDrawable();
        stateful.addState(new int[]{16843518}, drawable, active);
        stateful.addState(StateSet.WILD_CARD, drawable, passive);
        return stateful;
    }

    @TargetApi(value=11)
    public static Drawable createActivatedDrawable(int passive, int active) {
        StateListDrawable stateful = new StateListDrawable();
        stateful.addState(new int[]{16843518}, (Drawable)new ColorDrawable(active));
        stateful.addState(StateSet.WILD_CARD, (Drawable)new ColorDrawable(passive));
        return stateful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBoolean(Context context, int attr, boolean fallback) {
        TypedArray ta = context.obtainStyledAttributes(new int[]{attr});
        try {
            boolean bl = ta.getBoolean(0, fallback);
            return bl;
        }
        finally {
            ta.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getColor(Context context, int attr, int fallback) {
        TypedArray ta = context.obtainStyledAttributes(new int[]{attr});
        try {
            int n = ta.getColor(0, fallback);
            return n;
        }
        finally {
            ta.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(Context context, int attr) {
        TypedArray ta = context.obtainStyledAttributes(new int[]{attr});
        try {
            Drawable drawable = ta.getDrawable(0);
            return drawable;
        }
        finally {
            ta.recycle();
        }
    }

    public static Drawable tintDrawable(Context context, int drawableId, int colorId) {
        Drawable d = context.getResources().getDrawable(drawableId);
        int c = context.getResources().getColor(colorId);
        return Utils.tintDrawable(d, c);
    }

    public static Drawable tintDrawable(Drawable d, int c) {
        PorterDuffColorFilter cf = new PorterDuffColorFilter(c, PorterDuff.Mode.SRC_IN);
        d.setColorFilter((ColorFilter)cf);
        return d;
    }

    @TargetApi(value=16)
    public static void setBackground(View v, Drawable d) {
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(d);
        } else {
            v.setBackgroundDrawable(d);
        }
    }

    @TargetApi(value=16)
    public static void removeOnGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        } else {
            view.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        }
    }

    public static int createDividerColor(Context context) {
        return Utils.getColor(context, 0x1010030, 0) & 0x1EFFFFFF;
    }

    public static int createActivatedColor(Context context) {
        return Utils.getColor(context, 0x1010030, 0) & 0x12FFFFFF;
    }

    @TargetApi(value=11)
    public static Drawable getSelectorDrawable(Context context) {
        Drawable d = null;
        if (APPCOMPAT_ATTR_SELECTABLE_ITEM_BACKGROUND != 0) {
            Log.d((String)"", (String)(APPCOMPAT_ATTR_SELECTABLE_ITEM_BACKGROUND + ""));
            d = Utils.getDrawable(context, APPCOMPAT_ATTR_SELECTABLE_ITEM_BACKGROUND);
        }
        if (d != null) {
            return d;
        }
        if (Build.VERSION.SDK_INT < 11) {
            return context.getResources().getDrawable(17301602);
        }
        return Utils.getDrawable(context, 16843534);
    }

    public static Drawable getActivatedDrawable(Context context) {
        return new ColorDrawable(Utils.createActivatedColor(context));
    }

    static {
        int activatedBackgroundIndicator;
        int selectableItemBackground;
        String clsName = "android.support.v7.appcompat.R$attr";
        try {
            selectableItemBackground = Class.forName("android.support.v7.appcompat.R$attr").getField("selectableItemBackground").getInt(null);
        }
        catch (Exception e) {
            selectableItemBackground = 0;
        }
        try {
            activatedBackgroundIndicator = Class.forName("android.support.v7.appcompat.R$attr").getField("activatedBackgroundIndicator").getInt(null);
        }
        catch (Exception e) {
            activatedBackgroundIndicator = 0;
        }
        APPCOMPAT_ATTR_SELECTABLE_ITEM_BACKGROUND = selectableItemBackground;
        APPCOMPAT_ATTR_ACTIVATED_BACKGROUND_INDICATOR = activatedBackgroundIndicator;
    }
}

