/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer.descriptors;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import net.xpece.material.navigationdrawer.descriptors.CompositeNavigationItemDescriptor;
import net.xpece.material.navigationdrawer.internal.Utils;

public abstract class AbsNavigationItemDescriptor
implements CompositeNavigationItemDescriptor {
    protected final long id;
    private Drawable mActive;

    protected AbsNavigationItemDescriptor(long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public void loadInto(View view, boolean selected) {
        if (selected) {
            Utils.setBackground(view, this.mActive);
        } else {
            Utils.setBackground(view, (Drawable)new ColorDrawable(0));
        }
    }

    @Override
    public final View createView(Context context, ViewGroup parent) {
        this.mActive = Utils.getActivatedDrawable(context);
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), parent, false);
        this.loadInto(view, false);
        return view;
    }

    @Override
    public boolean onClick(View view) {
        return false;
    }

    public String toString() {
        return "AbsNavigationItemDescriptor{id=" + this.id + '}';
    }
}

