/*
 * Decompiled with CFR 0.152.
 */
package net.xpece.material.navigationdrawer;

import android.content.Context;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewTreeObserver;
import java.lang.reflect.Field;
import net.xpece.material.navigationdrawer.R;
import net.xpece.material.navigationdrawer.internal.Utils;

public class NavigationDrawerUtils {
    private NavigationDrawerUtils() {
    }

    public static void fixMinDrawerMargin(DrawerLayout drawerLayout) {
        try {
            Field f = DrawerLayout.class.getDeclaredField("mMinDrawerMargin");
            f.setAccessible(true);
            f.set(drawerLayout, 0);
            drawerLayout.requestLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setProperNavigationDrawerWidth(final View view) {
        final Context context = view.getContext();
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Utils.removeOnGlobalLayoutListener(view, this);
                int smallestWidthPx = context.getResources().getDisplayMetrics().widthPixels < context.getResources().getDisplayMetrics().heightPixels ? context.getResources().getDisplayMetrics().widthPixels : context.getResources().getDisplayMetrics().heightPixels;
                int drawerMargin = context.getResources().getDimensionPixelOffset(R.dimen.mnd_drawer_margin);
                view.getLayoutParams().width = Math.min(context.getResources().getDimensionPixelSize(R.dimen.mnd_drawer_max_width), smallestWidthPx - drawerMargin);
                view.requestLayout();
            }
        });
    }
}

