/*
 * Decompiled with CFR 0.152.
 */
package com.sqisland.android.sliding_pane_layout;

import android.content.Context;
import android.support.v4.widget.SlidingPaneLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class CrossFadeSlidingPaneLayout
extends SlidingPaneLayout {
    private View partialView = null;
    private View fullView = null;
    private SlidingPaneLayout.SimplePanelSlideListener crossFadeListener = new SlidingPaneLayout.SimplePanelSlideListener(){

        public void onPanelSlide(View panel, float slideOffset) {
            super.onPanelSlide(panel, slideOffset);
            if (CrossFadeSlidingPaneLayout.this.partialView == null || CrossFadeSlidingPaneLayout.this.fullView == null) {
                return;
            }
            CrossFadeSlidingPaneLayout.this.partialView.setVisibility(CrossFadeSlidingPaneLayout.this.isOpen() ? 8 : 0);
            CrossFadeSlidingPaneLayout.this.partialView.setAlpha(1.0f - slideOffset);
            CrossFadeSlidingPaneLayout.this.fullView.setAlpha(slideOffset);
        }
    };

    public CrossFadeSlidingPaneLayout(Context context) {
        super(context);
    }

    public CrossFadeSlidingPaneLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CrossFadeSlidingPaneLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() < 1) {
            return;
        }
        View panel = this.getChildAt(0);
        if (!(panel instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)panel;
        if (viewGroup.getChildCount() != 2) {
            return;
        }
        this.fullView = viewGroup.getChildAt(0);
        this.partialView = viewGroup.getChildAt(1);
        super.setPanelSlideListener((SlidingPaneLayout.PanelSlideListener)this.crossFadeListener);
    }

    public void setPanelSlideListener(final SlidingPaneLayout.PanelSlideListener listener) {
        if (listener == null) {
            super.setPanelSlideListener((SlidingPaneLayout.PanelSlideListener)this.crossFadeListener);
            return;
        }
        super.setPanelSlideListener(new SlidingPaneLayout.PanelSlideListener(){

            public void onPanelSlide(View panel, float slideOffset) {
                CrossFadeSlidingPaneLayout.this.crossFadeListener.onPanelSlide(panel, slideOffset);
                listener.onPanelSlide(panel, slideOffset);
            }

            public void onPanelOpened(View panel) {
                listener.onPanelOpened(panel);
            }

            public void onPanelClosed(View panel) {
                listener.onPanelClosed(panel);
            }
        });
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.partialView != null) {
            this.partialView.setVisibility(this.isOpen() ? 8 : 0);
        }
    }
}

