/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.applications;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import net.wasdev.wlp.ant.UndeployTask;
import net.wasdev.wlp.maven.plugins.BasicSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.types.PatternSet;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

@Mojo(name="undeploy")
public class UndeployAppMojo
extends BasicSupport {
    @Parameter(property="appArchive")
    protected String appArchive = null;
    @Parameter
    protected ArtifactItem appArtifact;
    @Parameter
    private PatternSet patternSet;
    @Parameter(property="timeout", defaultValue="40")
    protected int timeout = 40;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        this.checkServerHomeExists();
        this.checkServerDirectoryExists();
        UndeployTask undeployTask = (UndeployTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:undeploy");
        if (undeployTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "undeploy"));
        }
        if (this.appArchive != null || this.appArtifact != null) {
            if (this.appArchive != null && this.appArtifact != null) {
                throw new MojoExecutionException(messages.getString("error.app.set.twice"));
            }
            if (this.appArtifact != null) {
                Artifact artifact = this.getArtifact(this.appArtifact);
                this.appArchive = artifact.getFile().getName();
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "artifact based application", this.appArtifact));
            } else if (this.appArchive != null) {
                File file = new File(this.appArchive);
                if (file.exists()) {
                    this.appArchive = file.getName();
                }
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based application", this.appArchive));
            }
            File destFile = new File(this.serverDirectory, "dropins/" + this.appArchive);
            if (destFile == null || !destFile.exists() || destFile.isDirectory()) {
                throw new IOException(MessageFormat.format(messages.getString("error.undeploy.app.noexist"), destFile.getCanonicalPath()));
            }
            undeployTask.setFile(this.appArchive);
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.undeploy.app"), destFile.getCanonicalPath()));
        } else if (this.patternSet != null && this.patternSet.hasPatterns(this.ant.getAnt())) {
            this.log.info((CharSequence)messages.getString("info.undeploy.patternset"));
            undeployTask.addPatternset(this.patternSet);
        } else {
            this.log.info((CharSequence)messages.getString("info.undeploy.all"));
        }
        undeployTask.setInstallDir(this.installDirectory);
        undeployTask.setServerName(this.serverName);
        undeployTask.setUserDir(this.userDirectory);
        undeployTask.setOutputDir(this.outputDirectory);
        undeployTask.setTimeout(Long.toString(this.timeout * 1000));
        undeployTask.execute();
    }
}

