/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.android.cat;

import android.util.LruCache;
import net.vrallev.android.cat.Cat;

public final class CatUtil {
    private static final String PACKAGE;
    private static final LruCache<String, Boolean> IGNORED_CLASS_NAMES;

    public static boolean isValidClass(String className) {
        return PACKAGE == null || !className.startsWith(PACKAGE);
    }

    private static boolean isClassNameIgnored(String className) {
        return (Boolean)IGNORED_CLASS_NAMES.get((Object)className);
    }

    public static String getCallingClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 3; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (!CatUtil.isValidClass(className) || CatUtil.isClassNameIgnored(className)) continue;
            return className;
        }
        return "Cat";
    }

    public static String getCallingClassNameSimple() {
        return CatUtil.simpleClassName(CatUtil.getCallingClassName());
    }

    public static String simpleClassName(String className) {
        String[] split = className.split("\\.");
        if (split.length == 0) {
            return className;
        }
        return split[split.length - 1];
    }

    public static String stripInnerClass(String className) {
        String[] split = className.split("\\$");
        if (split.length == 0) {
            return className;
        }
        return split[0];
    }

    public static String getCallingPackage() {
        String className = CatUtil.getCallingClassName();
        String[] split = className.split("\\.");
        if (split.length <= 1) {
            return className;
        }
        return className.substring(0, className.length() - 1 - split[split.length - 1].length());
    }

    private CatUtil() {
    }

    static {
        Package catPackage = Cat.class.getPackage();
        PACKAGE = catPackage == null ? null : catPackage.getName();
        IGNORED_CLASS_NAMES = new LruCache<String, Boolean>(100){

            protected Boolean create(String className) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (this.hasInvalidInterfaces(clazz)) {
                        return true;
                    }
                    for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                        if (CatUtil.isValidClass(superclass.getName()) && !this.hasInvalidInterfaces(superclass)) continue;
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }

            private boolean hasInvalidInterfaces(Class<?> clazz) {
                if (clazz == null) {
                    return false;
                }
                Class<?>[] interfaces = clazz.getInterfaces();
                if (interfaces == null || interfaces.length == 0) {
                    return false;
                }
                for (Class<?> interfaceClass : interfaces) {
                    if (CatUtil.isValidClass(interfaceClass.getName())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

