/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.ElmExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallElmExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElmInstaller {
    public static final String INSTALL_PATH = "/node/elm";
    public static final String DEFAULT_ELM_DOWNLOAD_ROOT = "https://github.com/elm/compiler/releases/download/";
    private static final Object LOCK = new Object();
    private static final String ELM_ROOT_DIRECTORY = "dist";
    private String elmVersion;
    private String elmDownloadRoot;
    private String userName;
    private String password;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    ElmInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public ElmInstaller setElmVersion(String elmVersion) {
        this.elmVersion = elmVersion;
        return this;
    }

    public ElmInstaller setElmDownloadRoot(String elmDownloadRoot) {
        this.elmDownloadRoot = elmDownloadRoot;
        return this;
    }

    public ElmInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public ElmInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws InstallationException {
        Object object = LOCK;
        synchronized (object) {
            if (this.elmDownloadRoot == null || this.elmDownloadRoot.isEmpty()) {
                this.elmDownloadRoot = DEFAULT_ELM_DOWNLOAD_ROOT;
            }
            if (!this.elmIsAlreadyInstalled()) {
                this.installElm();
            }
        }
    }

    private boolean elmIsAlreadyInstalled() {
        try {
            InstallElmExecutorConfig executorConfig = new InstallElmExecutorConfig(this.config);
            File nodeFile = executorConfig.getElmPath();
            if (nodeFile.exists()) {
                String version = new ElmExecutor(executorConfig, Arrays.asList("--version"), null).executeAndGetResult(this.logger).trim();
                if (version.equals(this.elmVersion.replaceFirst("^v", ""))) {
                    this.logger.info("Elm {} is already installed.", (Object)version);
                    return true;
                }
                this.logger.info("Yarn {} was installed, but we need version {}", (Object)version, (Object)this.elmVersion);
                return false;
            }
            return false;
        }
        catch (ProcessExecutionException e) {
            return false;
        }
    }

    private void installElm() throws InstallationException {
        try {
            this.logger.info("Installing Elm version {}", (Object)this.elmVersion);
            String downloadUrl = this.elmDownloadRoot + this.elmVersion;
            String extension = "tar.gz";
            String platform = this.config.getPlatform().isWindows() ? "windows" : (this.config.getPlatform().isMac() ? "mac" : "linux");
            String fileending = "/binaries-for-" + platform + "." + extension;
            downloadUrl = downloadUrl + fileending;
            CacheDescriptor cacheDescriptor = new CacheDescriptor("elm", this.elmVersion, extension);
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password);
            File installDirectory = this.getInstallDirectory();
            try {
                if (installDirectory.isDirectory()) {
                    FileUtils.deleteDirectory((File)installDirectory);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete existing Elm installation.");
            }
            try {
                this.extractFile(archive, installDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                    if (installDirectory.exists()) {
                        FileUtils.deleteDirectory((File)installDirectory);
                    }
                }
                throw e;
            }
            this.ensureCorrectElmRootDirectory(installDirectory, this.elmVersion);
            this.logger.info("Installed Elm locally.");
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Elm", (Throwable)e);
        }
        catch (ArchiveExtractionException | IOException e) {
            throw new InstallationException("Could not extract the Elm archive", e);
        }
    }

    private File getInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), INSTALL_PATH);
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private void ensureCorrectElmRootDirectory(File installDirectory, String elmVersion) throws IOException {
        File elmRootDirectory = new File(installDirectory, ELM_ROOT_DIRECTORY);
        if (!elmRootDirectory.exists()) {
            // empty if block
        }
    }

    private void downloadFileIfMissing(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password);
        }
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password);
    }
}

