/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.listener.QueryCountStrategy;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.QueryUtils;
import net.ttddyy.dsproxy.listener.ThreadQueryCountHolder;

public class DataSourceQueryCountListener
implements QueryExecutionListener {
    private QueryCountStrategy queryCountStrategy = new ThreadQueryCountHolder();

    @Override
    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
    }

    @Override
    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        String dataSourceName = execInfo.getDataSourceName();
        QueryCount count = this.queryCountStrategy.getOrCreateQueryCount(dataSourceName);
        count.incrementTotal();
        if (execInfo.isSuccess()) {
            count.incrementSuccess();
        } else {
            count.incrementFailure();
        }
        long elapsedTime = execInfo.getElapsedTime();
        count.incrementTime(elapsedTime);
        count.increment(execInfo.getStatementType());
        for (QueryInfo queryInfo : queryInfoList) {
            String query = queryInfo.getQuery();
            QueryType type = QueryUtils.getQueryType(query);
            count.increment(type);
        }
    }

    public QueryCountStrategy getQueryCountStrategy() {
        return this.queryCountStrategy;
    }

    public void setQueryCountStrategy(QueryCountStrategy queryCountStrategy) {
        this.queryCountStrategy = queryCountStrategy;
    }
}

