/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.lang.reflect.Method;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.listener.CompositeMethodListener;
import net.ttddyy.dsproxy.listener.MethodExecutionContext;
import net.ttddyy.dsproxy.proxy.ProxyConfig;

public class MethodExecutionListenerUtils {
    public static Object invoke(MethodExecutionCallback callback, ProxyConfig proxyConfig, Object proxyTarget, ConnectionInfo connectionInfo, Method method, Object[] args) throws Throwable {
        MethodExecutionContext methodContext = MethodExecutionContext.Builder.create().target(proxyTarget).method(method).methodArgs(args).connectionInfo(connectionInfo).proxyConfig(proxyConfig).build();
        CompositeMethodListener methodExecutionListener = proxyConfig.getMethodListener();
        methodExecutionListener.beforeMethod(methodContext);
        long beforeTime = System.currentTimeMillis();
        Object result = null;
        Throwable thrown = null;
        try {
            result = callback.execute(proxyTarget, method, args);
        }
        catch (Throwable throwable) {
            thrown = throwable;
            throw throwable;
        }
        finally {
            long afterTime = System.currentTimeMillis();
            long elapsedTime = afterTime - beforeTime;
            methodContext.setElapsedTime(elapsedTime);
            methodContext.setResult(result);
            methodContext.setThrown(thrown);
            methodExecutionListener.afterMethod(methodContext);
        }
        return result;
    }

    public static interface MethodExecutionCallback {
        public Object execute(Object var1, Method var2, Object[] var3) throws Throwable;
    }
}

