/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener.logging;

import net.ttddyy.dsproxy.listener.logging.AbstractQueryLoggingListener;
import net.ttddyy.dsproxy.listener.logging.Log4jLogLevel;
import net.ttddyy.dsproxy.listener.logging.LoggingCondition;
import net.ttddyy.dsproxy.support.Log4jLogUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4jQueryLoggingListener
extends AbstractQueryLoggingListener {
    protected Logger log = LogManager.getLogger((String)Log4jQueryLoggingListener.class.getName());
    protected Log4jLogLevel logLevel = Log4jLogLevel.DEBUG;

    public Log4jQueryLoggingListener() {
        this.loggingCondition = new LoggingCondition(){

            @Override
            public boolean getAsBoolean() {
                switch (Log4jQueryLoggingListener.this.logLevel) {
                    case TRACE: {
                        return Log4jQueryLoggingListener.this.log.isTraceEnabled();
                    }
                    case DEBUG: {
                        return Log4jQueryLoggingListener.this.log.isDebugEnabled();
                    }
                    case INFO: {
                        return Log4jQueryLoggingListener.this.log.isInfoEnabled();
                    }
                    case WARN: {
                        return Log4jQueryLoggingListener.this.log.isWarnEnabled();
                    }
                    case ERROR: {
                        return Log4jQueryLoggingListener.this.log.isErrorEnabled();
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void writeLog(String message) {
        Log4jLogUtils.writeLog(this.log, this.logLevel, message);
    }

    public void setLogLevel(Log4jLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    @Deprecated
    protected void resetLogger(String loggerName) {
        this.log = LogManager.getLogger((String)loggerName);
    }

    public void setLogger(String log) {
        this.log = LogManager.getLogger((String)log);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public Logger getLogger() {
        return this.log;
    }

    public Log4jLogLevel getLogLevel() {
        return this.logLevel;
    }
}

