/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.List;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.times.PackedLocalTime;

final class TableProxy {
    private final Table table;
    private final boolean[] rowColumnsSet;
    private final BooleanColumn[] booleanColumns;
    private final ShortColumn[] shortColumns;
    private final IntColumn[] intColumns;
    private final LongColumn[] longColumns;
    private final FloatColumn[] floatColumns;
    private final DoubleColumn[] doubleColumns;
    private final DateColumn[] dateColumns;
    private final TimeColumn[] timeColumns;
    private final DateTimeColumn[] dateTimeColumns;
    private final InstantColumn[] instantColumns;
    private final StringColumn[] stringColumns;
    private final TextColumn[] textColumns;
    private Row currentRow = null;
    private int currentRownum;

    TableProxy(Table table) {
        this.table = table;
        this.currentRownum = table.rowCount() - 1;
        List columns = table.columns();
        int size = columns.size();
        this.rowColumnsSet = new boolean[size];
        this.booleanColumns = new BooleanColumn[size];
        this.shortColumns = new ShortColumn[size];
        this.intColumns = new IntColumn[size];
        this.longColumns = new LongColumn[size];
        this.floatColumns = new FloatColumn[size];
        this.doubleColumns = new DoubleColumn[size];
        this.dateColumns = new DateColumn[size];
        this.timeColumns = new TimeColumn[size];
        this.dateTimeColumns = new DateTimeColumn[size];
        this.instantColumns = new InstantColumn[size];
        this.stringColumns = new StringColumn[size];
        this.textColumns = new TextColumn[size];
        for (int i = 0; i < size; ++i) {
            this.fillColumnArrays(i, ((Column)columns.get(i)).type());
        }
    }

    private void fillColumnArrays(int colIndex, ColumnType columnType) {
        if (columnType == ColumnType.BOOLEAN) {
            this.booleanColumns[colIndex] = this.table.booleanColumn(colIndex);
        } else if (columnType == ColumnType.SHORT) {
            this.shortColumns[colIndex] = this.table.shortColumn(colIndex);
        } else if (columnType == ColumnType.INTEGER) {
            this.intColumns[colIndex] = this.table.intColumn(colIndex);
        } else if (columnType == ColumnType.LONG) {
            this.longColumns[colIndex] = this.table.longColumn(colIndex);
        } else if (columnType == ColumnType.FLOAT) {
            this.floatColumns[colIndex] = this.table.floatColumn(colIndex);
        } else if (columnType == ColumnType.DOUBLE) {
            this.doubleColumns[colIndex] = this.table.doubleColumn(colIndex);
        } else if (columnType == ColumnType.LOCAL_TIME) {
            this.timeColumns[colIndex] = this.table.timeColumn(colIndex);
        } else if (columnType == ColumnType.LOCAL_DATE) {
            this.dateColumns[colIndex] = this.table.dateColumn(colIndex);
        } else if (columnType == ColumnType.LOCAL_DATE_TIME) {
            this.dateTimeColumns[colIndex] = this.table.dateTimeColumn(colIndex);
        } else if (columnType == ColumnType.INSTANT) {
            this.instantColumns[colIndex] = this.table.instantColumn(colIndex);
        } else if (columnType == ColumnType.STRING) {
            this.stringColumns[colIndex] = this.table.stringColumn(colIndex);
        } else if (columnType == ColumnType.TEXT) {
            this.textColumns[colIndex] = this.table.textColumn(colIndex);
        }
    }

    void appendInstant(int colIndex, Instant value) {
        this.instantColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendDateTime(int colIndex, LocalDateTime value) {
        this.dateTimeColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendFloat(int colIndex, float value) {
        this.floatColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendDouble(int colIndex, double value) {
        this.doubleColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendTime(int colIndex, LocalTime value) {
        this.timeColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendString(int colIndex, String value) {
        this.stringColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendText(int colIndex, String value) {
        this.textColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendBoolean(int colIndex, boolean value) {
        this.booleanColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendShort(int colIndex, short value) {
        this.shortColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendInt(int colIndex, int value) {
        this.intColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendLong(int colIndex, long value) {
        this.longColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void appendDate(int colIndex, LocalDate value) {
        this.dateColumns[colIndex].append(value);
        this.rowColumnsSet[colIndex] = true;
    }

    void startRow() {
        ++this.currentRownum;
    }

    void endRow() {
        for (int i = 0; i < this.rowColumnsSet.length; ++i) {
            if (!this.rowColumnsSet[i]) {
                this.table.column(i).appendMissing();
                continue;
            }
            this.rowColumnsSet[i] = false;
        }
    }

    Row getCurrentRow() {
        if (this.currentRow == null) {
            this.currentRow = this.table.row(this.currentRownum);
        } else {
            this.currentRow.at(this.currentRownum);
        }
        return this.currentRow;
    }

    boolean getBoolean(int colIndex, int rowIndex) {
        return this.booleanColumns[colIndex].get(rowIndex);
    }

    int getShort(int colIndex, int rowIndex) {
        return this.shortColumns[colIndex].getShort(rowIndex);
    }

    int getInt(int colIndex, int rowIndex) {
        return this.intColumns[colIndex].getInt(rowIndex);
    }

    long getLong(int colIndex, int rowIndex) {
        return this.longColumns[colIndex].getLong(rowIndex);
    }

    float getFloat(int colIndex, int rowIndex) {
        return this.floatColumns[colIndex].getFloat(rowIndex);
    }

    double getDouble(int colIndex, int rowIndex) {
        return this.doubleColumns[colIndex].getDouble(rowIndex);
    }

    String getString(int colIndex, int rowIndex) {
        return this.stringColumns[colIndex].get(rowIndex);
    }

    String getText(int colIndex, int rowIndex) {
        return this.textColumns[colIndex].get(rowIndex);
    }

    int getDateToEpochDay(int colIndex, int rowIndex) {
        return (int)PackedLocalDate.toEpochDay((int)this.dateColumns[colIndex].getIntInternal(rowIndex));
    }

    long getTimeToNanoOfDay(int colIndex, int rowIndex) {
        return PackedLocalTime.toNanoOfDay((int)this.timeColumns[colIndex].getIntInternal(rowIndex));
    }

    long getInstantToEpochMilli(int colIndex, int rowIndex) {
        return this.instantColumns[colIndex].get(rowIndex).toEpochMilli();
    }

    long getDateTimeToEpochMilli(int colIndex, int rowIndex) {
        return this.dateTimeColumns[colIndex].get(rowIndex).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    Column<?> column(int colIndex) {
        return this.table.column(colIndex);
    }
}

