/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.spi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.base.ResourceLoader;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZoneProvider;
import net.time4j.tz.spi.ZoneNameProviderSPI;

public class TimezoneRepositoryProviderSPI
implements ZoneProvider,
LeapSecondProvider {
    private static final ZoneProvider NAME_PROVIDER = new ZoneNameProviderSPI();
    private final String version;
    private final String location;
    private final Map<String, byte[]> data;
    private final Map<String, String> aliases;
    private final PlainDate expires;
    private final Map<GregorianDate, Integer> leapsecs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimezoneRepositoryProviderSPI() {
        URI uRI = null;
        InputStream inputStream = null;
        DataInputStream dataInputStream = null;
        IllegalStateException illegalStateException = null;
        Object object = "";
        String string = "";
        PlainDate plainDate = (PlainDate)PlainDate.axis().getMinimum();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        boolean bl = System.getProperty("net.time4j.scale.leapseconds.path") != null;
        this.leapsecs = bl ? Collections.emptyMap() : new LinkedHashMap<GregorianDate, Integer>(50);
        String string2 = System.getProperty("net.time4j.tz.repository.path");
        String string3 = System.getProperty("net.time4j.tz.repository.version");
        String string4 = string3 == null ? "tzdata.repository" : "tzdata" + string3 + ".repository";
        try {
            Object object2;
            String string5 = "tzrepo/" + string4;
            if (string2 != null) {
                object2 = new File(string2, string4);
                if (((File)object2).isAbsolute()) {
                    if (!((File)object2).exists()) throw new FileNotFoundException("Path to tz-repository not found: " + object2);
                    uRI = ((File)object2).toURI();
                } else {
                    uRI = ResourceLoader.getInstance().locate("tzdata", TimezoneRepositoryProviderSPI.getReference(), ((File)object2).toString());
                }
            } else {
                uRI = ResourceLoader.getInstance().locate("tzdata", TimezoneRepositoryProviderSPI.getReference(), string5);
            }
            if (uRI != null) {
                int n;
                int n2;
                int n3;
                inputStream = ResourceLoader.getInstance().load(uRI, true);
                if (inputStream == null) {
                    object2 = TimezoneRepositoryProviderSPI.getReference().getClassLoader().getResource(string5);
                    if (object2 == null) {
                        throw new FileNotFoundException("Classloader cannot access tz-repository: " + string5);
                    }
                    URLConnection uRLConnection = ((URL)object2).openConnection();
                    uRLConnection.setUseCaches(false);
                    uRLConnection.connect();
                    inputStream = uRLConnection.getInputStream();
                }
                dataInputStream = new DataInputStream(inputStream);
                string = uRI.toString();
                TimezoneRepositoryProviderSPI.checkMagicLabel(dataInputStream, string);
                object2 = dataInputStream.readUTF();
                int n4 = dataInputStream.readInt();
                ArrayList<String> arrayList = new ArrayList<String>(n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    String string6 = dataInputStream.readUTF();
                    int n5 = dataInputStream.readInt();
                    byte[] byArray = new byte[n5];
                    n2 = 0;
                    do {
                        if ((n2 += dataInputStream.read(byArray, n2, n5 - n2)) != -1) continue;
                        throw new EOFException("Incomplete data: " + string6);
                    } while (n5 > n2);
                    arrayList.add(string6);
                    hashMap.put(string6, byArray);
                }
                n3 = dataInputStream.readShort();
                for (n = 0; n < n3; ++n) {
                    String string7 = dataInputStream.readUTF();
                    String string8 = (String)arrayList.get(dataInputStream.readShort());
                    hashMap2.put(string7, string8);
                }
                if (!bl) {
                    int n6;
                    n = dataInputStream.readShort();
                    for (n6 = 0; n6 < n; ++n6) {
                        short s = dataInputStream.readShort();
                        n2 = dataInputStream.readByte();
                        byte by = dataInputStream.readByte();
                        byte by2 = dataInputStream.readByte();
                        this.leapsecs.put((GregorianDate)PlainDate.of((int)s, (int)n2, (int)by), Integer.valueOf(by2));
                    }
                    n6 = dataInputStream.readShort();
                    byte by = dataInputStream.readByte();
                    n2 = dataInputStream.readByte();
                    plainDate = PlainDate.of((int)n6, (int)by, (int)n2);
                }
                object = object2;
            }
        }
        catch (IOException iOException) {
            illegalStateException = new IllegalStateException("[ERROR] TZ-repository not available. => " + iOException.getMessage(), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (illegalStateException != null) {
            throw illegalStateException;
        }
        this.version = object;
        this.location = string;
        this.data = Collections.unmodifiableMap(hashMap);
        this.aliases = Collections.unmodifiableMap(hashMap2);
        this.expires = plainDate;
    }

    public Set<String> getAvailableIDs() {
        return this.data.keySet();
    }

    public Set<String> getPreferredIDs(Locale locale, boolean bl) {
        return NAME_PROVIDER.getPreferredIDs(locale, bl);
    }

    public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
        return NAME_PROVIDER.getDisplayName(string, nameStyle, locale);
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public TransitionHistory load(String string) {
        try {
            byte[] byArray = this.data.get(string);
            if (byArray != null) {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                return (TransitionHistory)objectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public String getFallback() {
        return "";
    }

    public String getName() {
        return "TZDB";
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<GregorianDate, Integer> getLeapSecondTable() {
        return Collections.unmodifiableMap(this.leapsecs);
    }

    public boolean supportsNegativeLS() {
        return !this.leapsecs.isEmpty();
    }

    public PlainDate getDateOfEvent(int n, int n2, int n3) {
        return PlainDate.of((int)n, (int)n2, (int)n3);
    }

    public PlainDate getDateOfExpiration() {
        return this.expires;
    }

    public String toString() {
        return "TZ-REPOSITORY(" + this.version + ")";
    }

    private static void checkMagicLabel(DataInputStream dataInputStream, String string) throws IOException {
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        byte by3 = dataInputStream.readByte();
        byte by4 = dataInputStream.readByte();
        byte by5 = dataInputStream.readByte();
        byte by6 = dataInputStream.readByte();
        if (by != 116 || by2 != 122 || by3 != 114 || by4 != 101 || by5 != 112 || by6 != 111) {
            throw new IOException("Invalid tz-repository: " + string);
        }
    }

    private static Class<?> getReference() {
        if (Boolean.getBoolean("test.environment")) {
            try {
                return Class.forName("net.time4j.tz.spi.RepositoryTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        return TimezoneRepositoryProviderSPI.class;
    }
}

