/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.tz.ExtZoneProvider;
import net.time4j.tz.NameStyle;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZoneProvider;
import net.time4j.tz.spi.ZoneNameProviderSPI;

public class TimezoneRepositoryProviderSPI
implements ExtZoneProvider,
LeapSecondProvider {
    private static final Set<String> JDK_NAME_REFS;
    private static final ExtZoneProvider NAME_PROVIDER;
    private final String version;
    private final String location;
    private final Map<String, TransitionHistory> data;
    private final Map<String, String> aliases;
    private final PlainDate expires;
    private final Map<GregorianDate, Integer> leapsecs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimezoneRepositoryProviderSPI() {
        URL uRL = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = "";
        String string = "";
        PlainDate plainDate = (PlainDate)PlainDate.axis().getMinimum();
        HashMap<String, TransitionHistory> hashMap = new HashMap<String, TransitionHistory>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        boolean bl = System.getProperty("net.time4j.scale.leapseconds.path") != null;
        this.leapsecs = bl ? Collections.emptyMap() : new LinkedHashMap<GregorianDate, Integer>(50);
        String string2 = System.getProperty("net.time4j.tz.repository.path");
        String string3 = System.getProperty("net.time4j.tz.repository.version");
        String string4 = string3 == null ? "tzdata.repository" : "tzdata" + string3 + ".repository";
        try {
            Object object2;
            if (string2 != null) {
                object2 = new File(string2, string4);
                if (((File)object2).isAbsolute()) {
                    if (!((File)object2).exists()) throw new FileNotFoundException("Path to tz-repository not found: " + object2);
                    uRL = ((File)object2).toURI().toURL();
                } else {
                    String string5 = ((File)object2).toString();
                    uRL = TimezoneRepositoryProviderSPI.classLoader().getResource(string5);
                }
            } else {
                object2 = "tzrepo/" + string4;
                uRL = TimezoneRepositoryProviderSPI.classLoader().getResource((String)object2);
            }
            if (uRL != null) {
                int n;
                int n2;
                inputStream = uRL.openStream();
                objectInputStream = new ObjectInputStream(inputStream);
                string = uRL.toString();
                TimezoneRepositoryProviderSPI.checkMagicLabel(objectInputStream, string);
                object2 = objectInputStream.readUTF();
                int n3 = objectInputStream.readInt();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n2 = 0; n2 < n3; ++n2) {
                    String string6 = objectInputStream.readUTF();
                    TransitionHistory transitionHistory = (TransitionHistory)objectInputStream.readObject();
                    arrayList.add(string6);
                    hashMap.put(string6, transitionHistory);
                }
                n2 = objectInputStream.readShort();
                for (n = 0; n < n2; ++n) {
                    String string7 = objectInputStream.readUTF();
                    String string8 = (String)arrayList.get(objectInputStream.readShort());
                    hashMap2.put(string7, string8);
                }
                if (!bl) {
                    void var18_29;
                    n = objectInputStream.readShort();
                    boolean bl2 = false;
                    while (var18_29 < n) {
                        short s = objectInputStream.readShort();
                        byte by = objectInputStream.readByte();
                        byte by2 = objectInputStream.readByte();
                        byte by3 = objectInputStream.readByte();
                        this.leapsecs.put((GregorianDate)PlainDate.of((int)s, (int)by, (int)by2), Integer.valueOf(by3));
                        ++var18_29;
                    }
                    plainDate = (PlainDate)objectInputStream.readObject();
                }
                object = object2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Note: TZ-repository corrupt. => " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Note: TZ-repository not available. => " + iOException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.version = object;
        this.location = string;
        this.data = Collections.unmodifiableMap(hashMap);
        this.aliases = Collections.unmodifiableMap(hashMap2);
        this.expires = plainDate;
    }

    public Set<String> getAvailableIDs() {
        return this.data.keySet();
    }

    public Set<String> getPreferredIDs(Locale locale, boolean bl) {
        return NAME_PROVIDER.getPreferredIDs(locale, bl);
    }

    public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
        if (JDK_NAME_REFS.contains(string)) {
            Timezone timezone = Timezone.of((String)("java.util.TimeZone~" + string));
            return timezone.getDisplayName(nameStyle, locale);
        }
        return string;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public TransitionHistory load(String string) {
        return this.data.get(string);
    }

    public String getFallback() {
        return "";
    }

    public String getName() {
        return "TZDB";
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<GregorianDate, Integer> getLeapSecondTable() {
        return Collections.unmodifiableMap(this.leapsecs);
    }

    public boolean supportsNegativeLS() {
        return !this.leapsecs.isEmpty();
    }

    public PlainDate getDateOfEvent(int n, int n2, int n3) {
        return PlainDate.of((int)n, (int)n2, (int)n3);
    }

    public PlainDate getDateOfExpiration() {
        return this.expires;
    }

    public String toString() {
        return "TZ-REPOSITORY(" + this.version + ")";
    }

    private static void checkMagicLabel(ObjectInputStream objectInputStream, String string) throws IOException {
        byte by = objectInputStream.readByte();
        byte by2 = objectInputStream.readByte();
        byte by3 = objectInputStream.readByte();
        byte by4 = objectInputStream.readByte();
        byte by5 = objectInputStream.readByte();
        byte by6 = objectInputStream.readByte();
        if (by != 116 || by2 != 122 || by3 != 114 || by4 != 101 || by5 != 112 || by6 != 111) {
            throw new IOException("Invalid tz-repository: " + string);
        }
    }

    private static ClassLoader classLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ZoneProvider.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : TimeZone.getAvailableIDs()) {
            hashSet.add(string);
        }
        JDK_NAME_REFS = Collections.unmodifiableSet(hashSet);
        NAME_PROVIDER = new ZoneNameProviderSPI();
    }
}

