/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.time.Instant;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.SimpleInterval;

public class IntervalTree<T, I extends ChronoInterval<T>>
extends AbstractCollection<I> {
    private final Node<T, I> root;
    private final int size;
    private final TimeLine<T> timeLine;
    private volatile List<I> intervals = null;

    private IntervalTree(Collection<I> collection, TimeLine<T> timeLine) {
        if (timeLine == null) {
            throw new NullPointerException("Missing timeline.");
        }
        Node<T, ChronoInterval> node = null;
        int n = 0;
        for (ChronoInterval chronoInterval : collection) {
            if (chronoInterval.isEmpty()) continue;
            node = IntervalTree.insert(node, chronoInterval, timeLine);
            n = Math.incrementExact(n);
        }
        this.root = node;
        this.size = n;
        this.timeLine = timeLine;
    }

    public static <I extends ChronoInterval<PlainDate>> IntervalTree<PlainDate, I> onDateAxis(Collection<I> collection) {
        return IntervalTree.onTimeLine(PlainDate.axis(), collection);
    }

    public static <I extends ChronoInterval<PlainTime>> IntervalTree<PlainTime, I> onClockAxis(Collection<I> collection) {
        return IntervalTree.onTimeLine(PlainTime.axis(), collection);
    }

    public static <I extends ChronoInterval<PlainTimestamp>> IntervalTree<PlainTimestamp, I> onTimestampAxis(Collection<I> collection) {
        return IntervalTree.onTimeLine(PlainTimestamp.axis(), collection);
    }

    public static <I extends ChronoInterval<Moment>> IntervalTree<Moment, I> onMomentAxis(Collection<I> collection) {
        return IntervalTree.onTimeLine(Moment.axis(), collection);
    }

    public static IntervalTree<Date, SimpleInterval<Date>> onTraditionalTimeLine(Collection<SimpleInterval<Date>> collection) {
        return IntervalTree.onTimeLine(SimpleInterval.onTraditionalTimeLine().getTimeLine(), collection);
    }

    public static IntervalTree<Instant, SimpleInterval<Instant>> onInstantTimeLine(Collection<SimpleInterval<Instant>> collection) {
        return IntervalTree.onTimeLine(SimpleInterval.onInstantTimeLine().getTimeLine(), collection);
    }

    public static <T, I extends ChronoInterval<T>> IntervalTree<T, I> onTimeLine(TimeLine<T> timeLine, Collection<I> collection) {
        return new IntervalTree<T, I>(collection, timeLine);
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public Iterator<I> iterator() {
        List<Object> list = this.intervals;
        if (list == null) {
            Collector collector = new Collector();
            this.accept(collector);
            list = Collections.unmodifiableList(collector.visited);
            this.intervals = list;
        }
        return list.iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    public List<I> findIntersections(T t) {
        ArrayList arrayList = new ArrayList();
        this.findIntersections(t, this.timeLine.stepForward(t), this.root, arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public List<I> findIntersections(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = chronoInterval.getStart().getTemporal();
        Object object2 = chronoInterval.getEnd().getTemporal();
        if (object != null && chronoInterval.getStart().isOpen()) {
            object = this.timeLine.stepForward(object);
        }
        if (object2 != null && chronoInterval.getEnd().isClosed()) {
            object2 = this.timeLine.stepForward(object2);
        }
        ArrayList arrayList = new ArrayList();
        this.findIntersections(object, object2, this.root, arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public boolean contains(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.isEmpty()) {
            return false;
        }
        Object object = chronoInterval.getStart().getTemporal();
        if (object != null && chronoInterval.getStart().isOpen()) {
            object = this.timeLine.stepForward(object);
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        this.findByEquals(chronoInterval, object, arrayList, this.root);
        return !arrayList.isEmpty();
    }

    public void accept(Visitor<I> visitor) {
        IntervalTree.accept(visitor, this.root);
    }

    private static <T, I extends ChronoInterval<T>> Node<T, I> insert(Node<T, I> node, I i, TimeLine<T> timeLine) {
        if (node == null) {
            return new Node(i);
        }
        if (IntervalTree.compareAtStart(((Node)node).interval.getStart(), i.getStart(), timeLine) > 0) {
            node.left = IntervalTree.insert(node.left, i, timeLine);
        } else {
            node.right = IntervalTree.insert(node.right, i, timeLine);
        }
        node.height = Math.max(IntervalTree.getHeight(node.left), IntervalTree.getHeight(node.right)) + 1;
        node.max = IntervalTree.findMax(node, timeLine);
        int n = IntervalTree.getBalance(node);
        if (n < -1) {
            if (IntervalTree.getBalance(node.right) > 0) {
                node.right = IntervalTree.rightRotate(node.right, timeLine);
            }
            return IntervalTree.leftRotate(node, timeLine);
        }
        if (n > 1) {
            if (IntervalTree.getBalance(node.left) < 0) {
                node.left = IntervalTree.leftRotate(node.left, timeLine);
            }
            return IntervalTree.rightRotate(node, timeLine);
        }
        return node;
    }

    private static <T, I extends ChronoInterval<T>> Node<T, I> leftRotate(Node<T, I> node, TimeLine<T> timeLine) {
        Node node2 = node.right;
        node.right = node2.left;
        node2.left = node;
        node.height = Math.max(IntervalTree.getHeight(node.left), IntervalTree.getHeight(node.right)) + 1;
        node2.height = Math.max(IntervalTree.getHeight(node2.left), IntervalTree.getHeight(node2.right)) + 1;
        node.max = IntervalTree.findMax(node, timeLine);
        node2.max = IntervalTree.findMax(node2, timeLine);
        return node2;
    }

    private static <T, I extends ChronoInterval<T>> Node<T, I> rightRotate(Node<T, I> node, TimeLine<T> timeLine) {
        Node node2 = node.left;
        node.left = node2.right;
        node2.right = node;
        node.height = Math.max(IntervalTree.getHeight(node.left), IntervalTree.getHeight(node.right)) + 1;
        node2.height = Math.max(IntervalTree.getHeight(node2.left), IntervalTree.getHeight(node2.right)) + 1;
        node.max = IntervalTree.findMax(node, timeLine);
        node2.max = IntervalTree.findMax(node2, timeLine);
        return node2;
    }

    private static int getHeight(Node<?, ?> node) {
        return node == null ? 0 : node.height;
    }

    private static <T, I extends ChronoInterval<T>> Boundary<T> findMax(Node<T, I> node, TimeLine<T> timeLine) {
        if (node.left == null && node.right == null) {
            return node.max;
        }
        if (node.left == null) {
            if (IntervalTree.compareAtEnd(node.right.max, node.max, timeLine) > 0) {
                return node.right.max;
            }
            return node.max;
        }
        if (node.right == null) {
            if (IntervalTree.compareAtEnd(node.left.max, node.max, timeLine) > 0) {
                return node.left.max;
            }
            return node.max;
        }
        Boundary boundary = IntervalTree.compareAtEnd(node.left.max, node.right.max, timeLine) < 0 ? node.right.max : node.left.max;
        if (IntervalTree.compareAtEnd(node.max, boundary, timeLine) > 0) {
            boundary = node.max;
        }
        return boundary;
    }

    private static <T> int compareAtStart(Boundary<T> boundary, Boundary<T> boundary2, TimeLine<T> timeLine) {
        if (boundary.isInfinite()) {
            return boundary2.isInfinite() ? 0 : -1;
        }
        if (boundary2.isInfinite()) {
            return 1;
        }
        Object object = boundary.getTemporal();
        Object object2 = boundary2.getTemporal();
        if (boundary.getEdge() != boundary2.getEdge()) {
            if (boundary.isOpen() && boundary2.isClosed()) {
                if ((object2 = timeLine.stepBackwards(object2)) == null) {
                    return 1;
                }
            } else if (boundary.isClosed() && boundary2.isOpen() && (object = timeLine.stepBackwards(object)) == null) {
                return -1;
            }
        }
        return timeLine.compare(object, object2);
    }

    private static <T> int compareAtEnd(Boundary<T> boundary, Boundary<T> boundary2, TimeLine<T> timeLine) {
        if (boundary.isInfinite()) {
            return boundary2.isInfinite() ? 0 : 1;
        }
        if (boundary2.isInfinite()) {
            return -1;
        }
        Object object = boundary.getTemporal();
        Object object2 = boundary2.getTemporal();
        if (boundary.getEdge() != boundary2.getEdge()) {
            if (boundary.isOpen() && boundary2.isClosed()) {
                if ((object2 = timeLine.stepForward(object2)) == null) {
                    return -1;
                }
            } else if (boundary.isClosed() && boundary2.isOpen() && (object = timeLine.stepForward(object)) == null) {
                return 1;
            }
        }
        return timeLine.compare(object, object2);
    }

    private static int getBalance(Node<?, ?> node) {
        if (node == null) {
            return 0;
        }
        return IntervalTree.getHeight(node.left) - IntervalTree.getHeight(node.right);
    }

    private void findIntersections(T t, T t2, Node<T, I> node, List<I> list) {
        Object object;
        boolean bl;
        if (node == null) {
            return;
        }
        if (t != null && !node.max.isInfinite() && (node.max.isOpen() ? this.timeLine.compare(node.max.getTemporal(), t) <= 0 : this.timeLine.compare(node.max.getTemporal(), t) < 0)) {
            return;
        }
        this.findIntersections(t, t2, node.left, list);
        Object t3 = ((Node)node).interval.getStart().getTemporal();
        boolean bl2 = bl = t3 == null || t2 == null;
        if (!bl) {
            if (((Node)node).interval.getStart().isClosed()) {
                bl = this.timeLine.compare(t3, t2) < 0;
            } else {
                object = this.timeLine.stepForward(t3);
                boolean bl3 = bl = object != null && this.timeLine.compare(object, t2) < 0;
            }
        }
        if (bl) {
            boolean bl4;
            object = ((Node)node).interval.getEnd().getTemporal();
            boolean bl5 = bl4 = object == null || t == null;
            if (!bl4) {
                if (((Node)node).interval.getEnd().isOpen()) {
                    bl4 = this.timeLine.compare(t, object) < 0;
                } else {
                    boolean bl6 = bl4 = this.timeLine.compare(t, object) <= 0;
                }
            }
            if (bl4) {
                list.add(((Node)node).interval);
            }
        } else {
            return;
        }
        this.findIntersections(t, t2, node.right, list);
    }

    private boolean findByEquals(ChronoInterval<T> chronoInterval, T t, List<ChronoInterval<T>> list, Node<T, I> node) {
        if (node == null) {
            return false;
        }
        if (this.findByEquals(chronoInterval, t, list, node.left)) {
            return true;
        }
        if (chronoInterval.equals(((Node)node).interval)) {
            list.add(chronoInterval);
            return true;
        }
        if (t != null && ((Node)node).interval.isAfter(t) || chronoInterval.getStart().isInfinite() && !((Node)node).interval.getStart().isInfinite()) {
            return true;
        }
        return this.findByEquals(chronoInterval, t, list, node.right);
    }

    private static <T, I extends ChronoInterval<T>> boolean accept(Visitor<I> visitor, Node<T, I> node) {
        if (node == null) {
            return false;
        }
        if (IntervalTree.accept(visitor, node.left)) {
            return true;
        }
        if (visitor.visited(((Node)node).interval)) {
            return true;
        }
        return IntervalTree.accept(visitor, node.right);
    }

    private class Collector
    implements Visitor<I> {
        private List<I> visited;

        private Collector() {
            this.visited = new ArrayList(IntervalTree.this.size());
        }

        @Override
        public boolean visited(I i) {
            this.visited.add(i);
            return false;
        }
    }

    private static class Node<T, I extends ChronoInterval<T>> {
        private final I interval;
        Node<T, I> left = null;
        Node<T, I> right = null;
        int height;
        Boundary<T> max;

        Node(I i) {
            this.interval = i;
            this.height = 1;
            this.max = i.getEnd();
        }
    }

    @FunctionalInterface
    public static interface Visitor<I> {
        public boolean visited(I var1);
    }
}

