/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.time.Year;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Quarter;
import net.time4j.SystemClock;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.range.Boundary;
import net.time4j.range.CalendarMonth;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.FixedCalendarInterval;
import net.time4j.range.SPX;
import net.time4j.range.Years;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class CalendarYear
extends FixedCalendarInterval<CalendarYear>
implements ThreetenAdapter,
LocalizedPatternSupport {
    @FormattableElement(format="u")
    public static final ChronoElement<Integer> YEAR = PlainDate.YEAR;
    private static final Chronology<CalendarYear> ENGINE = Chronology.Builder.setUp(CalendarYear.class, (ChronoMerger)new Merger()).appendElement(YEAR, (ElementRule)new YearRule()).build();
    private static final Chronology<Year> THREETEN;
    private static final long serialVersionUID = 2151327270599436439L;
    private final transient int year;
    private final transient Boundary<PlainDate> start;
    private final transient Boundary<PlainDate> end;

    private CalendarYear(int n) {
        if (n < -999999999 || n > 999999999) {
            throw new IllegalArgumentException("Year out of bounds: " + n);
        }
        this.year = n;
        this.start = Boundary.ofClosed(PlainDate.of((int)this.year, (int)1, (int)1));
        this.end = Boundary.ofClosed(PlainDate.of((int)this.year, (int)12, (int)31));
    }

    public static CalendarYear of(int n) {
        return new CalendarYear(n);
    }

    public static CalendarYear nowInSystemTime() {
        return (CalendarYear)SystemClock.inLocalView().now(CalendarYear.chronology());
    }

    public CalendarQuarter at(Quarter quarter) {
        return CalendarQuarter.of(this.year, quarter);
    }

    public CalendarMonth at(Month month) {
        return CalendarMonth.of(this.year, month);
    }

    public CalendarMonth atMonth(int n) {
        return CalendarMonth.of(this.year, n);
    }

    public PlainDate atDayOfYear(int n) {
        return n == 1 ? this.start.getTemporal() : PlainDate.of((int)this.year, (int)n);
    }

    public int getValue() {
        return this.year;
    }

    @Override
    public Boundary<PlainDate> getStart() {
        return this.start;
    }

    @Override
    public Boundary<PlainDate> getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(PlainDate plainDate) {
        return plainDate.getYear() == this.year;
    }

    @Override
    public boolean isAfter(PlainDate plainDate) {
        return plainDate.getYear() < this.year;
    }

    @Override
    public boolean isBefore(PlainDate plainDate) {
        return plainDate.getYear() > this.year;
    }

    public boolean isLeap() {
        return GregorianMath.isLeapYear((int)this.year);
    }

    public int length() {
        return this.isLeap() ? 366 : 365;
    }

    public static CalendarYear from(Year year) {
        return CalendarYear.of(year.getValue());
    }

    public CalendarYear plus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarYear.of(MathUtils.safeAdd((int)this.year, (int)years.getAmount()));
    }

    public CalendarYear minus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarYear.of(MathUtils.safeSubtract((int)this.year, (int)years.getAmount()));
    }

    @Override
    public int compareTo(CalendarYear calendarYear) {
        return this.year - calendarYear.year;
    }

    @Override
    public Iterator<PlainDate> iterator() {
        return new Iter();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarYear) {
            CalendarYear calendarYear = (CalendarYear)object;
            return this.year == calendarYear.year;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CalendarYear.formatYear(stringBuilder, this.year);
        return stringBuilder.toString();
    }

    public Year toTemporalAccessor() {
        return Year.of(this.year);
    }

    public static Chronology<CalendarYear> chronology() {
        return ENGINE;
    }

    public static Chronology<Year> threeten() {
        return THREETEN;
    }

    protected Chronology<CalendarYear> getChronology() {
        return ENGINE;
    }

    protected CalendarYear getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 36);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Converter<Year, CalendarYear> converter = new Converter<Year, CalendarYear>(){

            public CalendarYear translate(Year year) {
                return CalendarYear.of(year.getValue());
            }

            public Year from(CalendarYear calendarYear) {
                return Year.of(calendarYear.year);
            }

            public Class<Year> getSourceType() {
                return Year.class;
            }
        };
        THREETEN = new BridgeChronology((Converter)converter, ENGINE);
    }

    private class Iter
    implements Iterator<PlainDate> {
        private PlainDate current;

        private Iter() {
            this.current = (PlainDate)CalendarYear.this.start.getTemporal();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public PlainDate next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            PlainDate plainDate = this.current;
            PlainDate plainDate2 = plainDate.plus(1L, CalendarUnit.DAYS);
            this.current = plainDate2.getYear() == CalendarYear.this.year ? plainDate2 : null;
            return plainDate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class YearRule
    implements IntElementRule<CalendarYear> {
        private YearRule() {
        }

        public Integer getValue(CalendarYear calendarYear) {
            return calendarYear.year;
        }

        public Integer getMinimum(CalendarYear calendarYear) {
            return -999999999;
        }

        public Integer getMaximum(CalendarYear calendarYear) {
            return 999999999;
        }

        public boolean isValid(CalendarYear calendarYear, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= -999999999 && n2 <= 999999999;
        }

        public CalendarYear withValue(CalendarYear calendarYear, Integer n, boolean bl) {
            if (this.isValid(calendarYear, n)) {
                return CalendarYear.of(n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        public ChronoElement<?> getChildAtFloor(CalendarYear calendarYear) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarYear calendarYear) {
            return null;
        }

        public int getInt(CalendarYear calendarYear) {
            return calendarYear.year;
        }

        public boolean isValid(CalendarYear calendarYear, int n) {
            return n >= -999999999 && n <= 999999999;
        }

        public CalendarYear withValue(CalendarYear calendarYear, int n, boolean bl) {
            if (this.isValid(calendarYear, n)) {
                return CalendarYear.of(n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }

    private static class Merger
    implements ChronoMerger<CalendarYear> {
        private Merger() {
        }

        public CalendarYear createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of((TZID)((TZID)attributeQuery.get(Attributes.TIMEZONE_ID)));
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            int n = Moment.from((UnixTime)timeSource.currentTime()).toZonalTimestamp(timezone.getID()).getYear();
            return CalendarYear.of(n);
        }

        public CalendarYear createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        public CalendarYear createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR);
            if (n >= -999999999 && n <= 999999999) {
                return CalendarYear.of(n);
            }
            if (n > Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)("Year out of bounds: " + n));
            }
            return null;
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            String string;
            Map map = CalendarText.getIsoInstance((Locale)locale).getTextForms();
            return map.containsKey(string = "F_y") ? (String)map.get(string) : "uuuu";
        }

        public CalendarYear createFrom(TemporalAccessor temporalAccessor, AttributeQuery attributeQuery) {
            if (temporalAccessor.query(TemporalQueries.chronology()) == IsoChronology.INSTANCE && temporalAccessor.isSupported(ChronoField.YEAR)) {
                int n = temporalAccessor.get(ChronoField.YEAR);
                return CalendarYear.of(n);
            }
            return null;
        }
    }
}

