/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalCreator;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;

public final class SimpleInterval<T>
implements ChronoInterval<T>,
Serializable {
    private static final ChronoFunction<ChronoDisplay, Void> NO_RESULT = new ChronoFunction<ChronoDisplay, Void>(){

        public Void apply(ChronoDisplay chronoDisplay) {
            return null;
        }
    };
    private static final Factory<Date> OLD_DATE_FACTORY = new Factory(new TraditionalTimeLine());
    private static final long serialVersionUID = -3508139527445140226L;
    private final Boundary<T> start;
    private final Boundary<T> end;
    private final TimeLine<T> timeLine;

    SimpleInterval(T t, T t2, TimeLine<T> timeLine) {
        if (timeLine == null) {
            throw new NullPointerException();
        }
        if (t != null && t2 != null && timeLine.compare(t, t2) > 0) {
            throw new IllegalArgumentException("Start after end: " + t + "/" + t2);
        }
        Boundary boundary = this.start = t == null ? Boundary.infinitePast() : Boundary.ofClosed(t);
        this.end = t2 == null ? Boundary.infiniteFuture() : (timeLine.isCalendrical() ? Boundary.ofClosed(t2) : Boundary.ofOpen(t2));
        this.timeLine = timeLine;
    }

    SimpleInterval(Boundary<T> boundary, Boundary<T> boundary2, TimeLine<T> timeLine) {
        this.start = boundary;
        this.end = boundary2;
        this.timeLine = timeLine;
    }

    public static SimpleInterval<Date> between(Date date, Date date2) {
        return OLD_DATE_FACTORY.between(date, date2);
    }

    public static SimpleInterval<Date> since(Date date) {
        return OLD_DATE_FACTORY.since(date);
    }

    public static SimpleInterval<Date> until(Date date) {
        return OLD_DATE_FACTORY.until(date);
    }

    public static Factory<Date> onTraditionalTimeLine() {
        return OLD_DATE_FACTORY;
    }

    public static <T> Factory<T> onTimeLine(TimeLine<T> timeLine) {
        return new Factory(timeLine);
    }

    public static <U, T extends TimePoint<U, T>> Factory<T> on(TimeAxis<U, T> timeAxis) {
        return new Factory(SerializableTimeLine.wrap(timeAxis));
    }

    public static <D extends CalendarVariant<D>> Factory<D> on(CalendarFamily<D> calendarFamily, String string) {
        return new Factory(calendarFamily.getTimeLine(string));
    }

    @Override
    public Boundary<T> getStart() {
        return this.start;
    }

    @Override
    public Boundary<T> getEnd() {
        return this.end;
    }

    @Override
    public boolean isFinite() {
        return !this.getStart().isInfinite() && !this.getEnd().isInfinite();
    }

    @Override
    public boolean isEmpty() {
        if (!this.isFinite()) {
            return false;
        }
        return this.end.isOpen() && this.timeLine.compare(this.start.getTemporal(), this.end.getTemporal()) == 0;
    }

    @Override
    public boolean contains(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (!this.start.isInfinite() && this.timeLine.compare(t, this.start.getTemporal()) < 0) {
            return false;
        }
        if (!this.end.isInfinite()) {
            int n = this.timeLine.compare(this.end.getTemporal(), t);
            return this.end.isClosed() ? n >= 0 : n > 0;
        }
        return true;
    }

    @Override
    public boolean contains(ChronoInterval<T> chronoInterval) {
        if (!chronoInterval.isFinite()) {
            return false;
        }
        T t = this.start.getTemporal();
        Object object = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            object = this.timeLine.stepForward(object);
        }
        if (object == null || t != null && this.timeLine.compare(t, object) > 0) {
            return false;
        }
        Object object2 = this.end.getTemporal();
        if (object2 == null) {
            return true;
        }
        Object object3 = chronoInterval.getEnd().getTemporal();
        if (chronoInterval.getEnd().isOpen() && this.timeLine.compare(object, object3) == 0) {
            if (this.end.isOpen()) {
                object2 = this.timeLine.stepBackwards(object2);
            }
            if (object2 == null || this.timeLine.compare(object, object2) > 0) {
                return false;
            }
        } else if (this.timeLine.isCalendrical()) {
            if (chronoInterval.getEnd().isOpen()) {
                object3 = this.timeLine.stepBackwards(object3);
            }
            if (object2 == null || object3 == null || this.timeLine.compare(object2, object3) < 0) {
                return false;
            }
        } else {
            if (chronoInterval.getEnd().isClosed() && (object3 = this.timeLine.stepForward(object3)) == null) {
                return false;
            }
            return this.timeLine.compare(object2, object3) >= 0;
        }
        return true;
    }

    @Override
    public boolean isAfter(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            return false;
        }
        return this.timeLine.compare(this.start.getTemporal(), t) > 0;
    }

    @Override
    public boolean isAfter(ChronoInterval<T> chronoInterval) {
        return chronoInterval.isBefore(this);
    }

    @Override
    public boolean isBefore(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.end.isInfinite()) {
            return false;
        }
        if (this.end.isOpen()) {
            return this.timeLine.compare(this.end.getTemporal(), t) <= 0;
        }
        return this.timeLine.compare(this.end.getTemporal(), t) < 0;
    }

    @Override
    public boolean isBefore(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        T t = this.end.getTemporal();
        Object object = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            object = this.timeLine.stepForward(object);
        }
        if (object == null) {
            return true;
        }
        if (this.end.isOpen()) {
            return this.timeLine.compare(t, object) <= 0;
        }
        return this.timeLine.compare(t, object) < 0;
    }

    @Override
    public boolean abuts(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        T t = this.start.getTemporal();
        Object object = chronoInterval.getStart().getTemporal();
        if (object != null && chronoInterval.getStart().isOpen()) {
            object = this.timeLine.stepForward(object);
        }
        Object object2 = this.end.getTemporal();
        Object object3 = chronoInterval.getEnd().getTemporal();
        if (object2 != null && this.end.isClosed()) {
            object2 = this.timeLine.stepForward(object2);
        }
        if (object3 != null && chronoInterval.getEnd().isClosed()) {
            object3 = this.timeLine.stepForward(object3);
        }
        if (object2 == null || object == null) {
            return t != null && object3 != null && this.timeLine.compare(t, object3) == 0;
        }
        if (t == null || object3 == null) {
            return this.timeLine.compare(object2, object) == 0;
        }
        return this.timeLine.compare(object2, object) == 0 ^ this.timeLine.compare(t, object3) == 0;
    }

    @Override
    public boolean intersects(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        return !this.isBefore(chronoInterval) && !this.isAfter(chronoInterval);
    }

    public SimpleInterval<T> findIntersection(ChronoInterval<T> chronoInterval) {
        Boundary<Object> boundary;
        Object object;
        Object object2;
        Boundary<T> boundary2;
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return null;
        }
        if (this.start.isInfinite()) {
            boundary2 = chronoInterval.getStart();
        } else if (chronoInterval.getStart().isInfinite()) {
            boundary2 = this.start;
        } else {
            object2 = this.start.getTemporal();
            object = chronoInterval.getStart().getTemporal();
            if (chronoInterval.getStart().isOpen()) {
                object = this.timeLine.stepForward(object);
            }
            if (object2 == null || object == null) {
                return null;
            }
            Boundary<Object> boundary3 = boundary2 = this.timeLine.compare(object2, object) < 0 ? Boundary.ofClosed(object) : Boundary.ofClosed(object2);
        }
        if (this.end.isInfinite()) {
            boundary = chronoInterval.getEnd();
        } else if (chronoInterval.getEnd().isInfinite()) {
            boundary = this.end;
        } else {
            object2 = this.end.getTemporal();
            object = chronoInterval.getEnd().getTemporal();
            if (this.timeLine.isCalendrical()) {
                if (this.end.isOpen()) {
                    object2 = this.timeLine.stepBackwards(object2);
                }
                if (chronoInterval.getEnd().isOpen()) {
                    object = this.timeLine.stepBackwards(object);
                }
                boundary = this.timeLine.compare(object2, object) < 0 ? Boundary.ofClosed(object2) : Boundary.ofClosed(object);
            } else {
                if (this.end.isClosed()) {
                    object2 = this.timeLine.stepForward(object2);
                }
                if (chronoInterval.getEnd().isClosed()) {
                    object = this.timeLine.stepForward(object);
                }
                if (object2 == null) {
                    boundary = object == null ? Boundary.infiniteFuture() : Boundary.ofOpen(object);
                } else if (object == null) {
                    boundary = object2 == null ? Boundary.infiniteFuture() : Boundary.ofOpen(object2);
                } else {
                    Boundary<Object> boundary4 = boundary = this.timeLine.compare(object2, object) < 0 ? Boundary.ofOpen(object2) : Boundary.ofOpen(object);
                }
            }
        }
        if (this.isAfter(boundary2, boundary)) {
            return null;
        }
        object2 = new SimpleInterval<T>(boundary2, boundary, this.timeLine);
        return ((SimpleInterval)object2).isEmpty() ? null : object2;
    }

    public String print(ChronoPrinter<T> chronoPrinter) {
        return this.print(chronoPrinter, IsoInterval.getIntervalPattern(chronoPrinter));
    }

    public String print(ChronoPrinter<T> chronoPrinter, String string) {
        AttributeQuery attributeQuery = IsoInterval.extractDefaultAttributes(chronoPrinter);
        StringBuilder stringBuilder = new StringBuilder(32);
        int n = 0;
        int n2 = string.length();
        try {
            while (n < n2) {
                char c = string.charAt(n);
                if (c == '{' && n + 2 < n2 && string.charAt(n + 2) == '}') {
                    char c2 = string.charAt(n + 1);
                    if (c2 == '0') {
                        if (this.start.isInfinite()) {
                            stringBuilder.append("-\u221e");
                        } else {
                            chronoPrinter.print(this.start.getTemporal(), (Appendable)stringBuilder, attributeQuery, NO_RESULT);
                        }
                        n += 3;
                        continue;
                    }
                    if (c2 == '1') {
                        if (this.end.isInfinite()) {
                            stringBuilder.append("+\u221e");
                        } else {
                            chronoPrinter.print(this.end.getTemporal(), (Appendable)stringBuilder, attributeQuery, NO_RESULT);
                        }
                        n += 3;
                        continue;
                    }
                }
                stringBuilder.append(c);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleInterval) {
            SimpleInterval simpleInterval = (SimpleInterval)object;
            return this.start.equals(simpleInterval.start) && this.end.equals(simpleInterval.end) && this.timeLine.equals(simpleInterval.timeLine);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.start.isInfinite()) {
            stringBuilder.append("(-\u221e");
        } else {
            stringBuilder.append('[');
            stringBuilder.append(this.start.getTemporal());
        }
        stringBuilder.append('/');
        if (this.end.isInfinite()) {
            stringBuilder.append("+\u221e)");
        } else {
            stringBuilder.append(this.end.getTemporal());
            if (this.end.isClosed()) {
                stringBuilder.append(']');
            } else {
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    private boolean isAfter(Boundary<T> boundary, Boundary<T> boundary2) {
        if (boundary.isInfinite() || boundary2.isInfinite()) {
            return false;
        }
        return this.timeLine.compare(boundary.getTemporal(), boundary2.getTemporal()) > 0;
    }

    private static class SerializableTimeLine<T extends TimePoint<?, T>>
    implements TimeLine<T>,
    Serializable {
        private final transient TimeAxis<?, T> axis;
        private final Class<T> chronoType;

        private SerializableTimeLine(TimeAxis<?, T> timeAxis) {
            this.axis = timeAxis;
            this.chronoType = timeAxis.getChronoType();
        }

        static <T extends TimePoint<?, T>> TimeLine<T> wrap(TimeAxis<?, T> timeAxis) {
            return new SerializableTimeLine<T>(timeAxis);
        }

        public T stepForward(T t) {
            return (T)this.axis.stepForward(t);
        }

        public T stepBackwards(T t) {
            return (T)this.axis.stepBackwards(t);
        }

        public boolean isCalendrical() {
            return this.axis.isCalendrical();
        }

        public int compare(T t, T t2) {
            return this.axis.compare(t, t2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SerializableTimeLine) {
                SerializableTimeLine serializableTimeLine = (SerializableTimeLine)object;
                return this.chronoType == serializableTimeLine.chronoType;
            }
            return false;
        }

        public int hashCode() {
            return this.chronoType.hashCode();
        }

        private Object readResolve() throws ObjectStreamException {
            Chronology chronology = Chronology.lookup(this.chronoType);
            return SerializableTimeLine.wrap((TimeAxis)TimeAxis.class.cast(chronology));
        }
    }

    private static class TraditionalTimeLine
    implements TimeLine<Date>,
    Serializable {
        private TraditionalTimeLine() {
        }

        public Date stepForward(Date date) {
            if (date.getTime() == Long.MAX_VALUE) {
                return null;
            }
            return new Date(date.getTime() + 1L);
        }

        public Date stepBackwards(Date date) {
            if (date.getTime() == Long.MIN_VALUE) {
                return null;
            }
            return new Date(date.getTime() - 1L);
        }

        public boolean isCalendrical() {
            return false;
        }

        public int compare(Date date, Date date2) {
            return date.compareTo(date2);
        }

        private Object readResolve() throws ObjectStreamException {
            return OLD_DATE_FACTORY.getTimeLine();
        }
    }

    public static class Factory<T> {
        private final TimeLine<T> timeLine;

        private Factory(TimeLine<T> timeLine) {
            if (timeLine == null) {
                throw new NullPointerException("Missing timeline.");
            }
            this.timeLine = timeLine;
        }

        public SimpleInterval<T> between(T t, T t2) {
            if (t == null) {
                throw new NullPointerException("Missing start.");
            }
            if (t2 == null) {
                throw new NullPointerException("Missing end.");
            }
            return new SimpleInterval<T>(t, t2, this.timeLine);
        }

        public SimpleInterval<T> since(T t) {
            if (t == null) {
                throw new NullPointerException("Missing start.");
            }
            return new SimpleInterval<Object>(t, null, (TimeLine<Object>)this.timeLine);
        }

        public SimpleInterval<T> until(T t) {
            if (t == null) {
                throw new NullPointerException("Missing end.");
            }
            return new SimpleInterval<Object>(null, t, (TimeLine<Object>)this.timeLine);
        }

        public SimpleInterval<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser) throws ParseException {
            return this.parse(charSequence, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
        }

        public SimpleInterval<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser, String string) throws ParseException {
            IntervalCreator intervalCreator = new IntervalCreator<T, SimpleInterval<T>>(){

                @Override
                public SimpleInterval<T> between(Boundary<T> boundary, Boundary<T> boundary2) {
                    return new SimpleInterval(boundary, boundary2, Factory.this.timeLine);
                }

                @Override
                public boolean isCalendrical() {
                    return false;
                }
            };
            ParseLog parseLog = new ParseLog();
            SimpleInterval simpleInterval = (SimpleInterval)IntervalParser.parseCustom(charSequence, intervalCreator, chronoParser, string, parseLog);
            if (parseLog.isError()) {
                throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
            }
            if (simpleInterval == null) {
                throw new ParseException("Parsing of interval failed: " + charSequence, parseLog.getPosition());
            }
            return simpleInterval;
        }

        TimeLine<T> getTimeLine() {
            return this.timeLine;
        }
    }
}

