/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.Serializable;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoEntity;
import net.time4j.range.ChronoInterval;
import net.time4j.range.DateInterval;
import net.time4j.range.ValueInterval;

public abstract class FixedCalendarInterval<T extends FixedCalendarInterval<T>>
extends ChronoEntity<T>
implements Comparable<T>,
ChronoInterval<PlainDate>,
Iterable<PlainDate>,
Serializable {
    FixedCalendarInterval() {
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(ChronoInterval<PlainDate> chronoInterval) {
        if (!chronoInterval.isFinite()) {
            return false;
        }
        PlainDate plainDate = (PlainDate)this.getStart().getTemporal();
        PlainDate plainDate2 = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            if (plainDate2.equals((Object)PlainDate.axis().getMaximum())) {
                return false;
            }
            plainDate2 = (PlainDate)plainDate2.plus(1L, (Object)CalendarUnit.DAYS);
        }
        if (plainDate.isAfter((CalendarDate)plainDate2)) {
            return false;
        }
        PlainDate plainDate3 = (PlainDate)this.getEnd().getTemporal();
        PlainDate plainDate4 = chronoInterval.getEnd().getTemporal();
        if (chronoInterval.getEnd().isOpen()) {
            if (plainDate2.isSimultaneous((CalendarDate)plainDate4)) {
                return !plainDate2.isAfter((CalendarDate)plainDate3);
            }
            if (plainDate4.equals((Object)PlainDate.axis().getMinimum())) {
                return false;
            }
            plainDate4 = (PlainDate)plainDate4.minus(1L, (Object)CalendarUnit.DAYS);
        }
        return !plainDate3.isBefore((CalendarDate)plainDate4);
    }

    @Override
    public boolean isBefore(ChronoInterval<PlainDate> chronoInterval) {
        if (chronoInterval.getStart().isInfinite()) {
            return false;
        }
        PlainDate plainDate = (PlainDate)this.getEnd().getTemporal();
        PlainDate plainDate2 = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            if (plainDate2.equals((Object)PlainDate.axis().getMaximum())) {
                return true;
            }
            plainDate2 = (PlainDate)plainDate2.plus(1L, (Object)CalendarUnit.DAYS);
        }
        return plainDate.isBefore((CalendarDate)plainDate2);
    }

    @Override
    public boolean isAfter(ChronoInterval<PlainDate> chronoInterval) {
        return chronoInterval.isBefore(this);
    }

    @Override
    public boolean abuts(ChronoInterval<PlainDate> chronoInterval) {
        if (chronoInterval.isEmpty()) {
            return false;
        }
        PlainDate plainDate = (PlainDate)this.getStart().getTemporal();
        PlainDate plainDate2 = chronoInterval.getStart().getTemporal();
        if (plainDate2 != null && chronoInterval.getStart().isOpen()) {
            plainDate2 = (PlainDate)plainDate2.plus(1L, (Object)CalendarUnit.DAYS);
        }
        PlainDate plainDate3 = (PlainDate)this.getEnd().getTemporal();
        PlainDate plainDate4 = chronoInterval.getEnd().getTemporal();
        try {
            plainDate3 = (PlainDate)plainDate3.plus(1L, (Object)CalendarUnit.DAYS);
        }
        catch (ArithmeticException arithmeticException) {
            return plainDate4 != null && plainDate.isSimultaneous((CalendarDate)plainDate4);
        }
        try {
            if (plainDate4 == null) {
                return plainDate2 != null && plainDate3.isSimultaneous((CalendarDate)plainDate2);
            }
            if (chronoInterval.getEnd().isClosed()) {
                plainDate4 = (PlainDate)plainDate4.plus(1L, (Object)CalendarUnit.DAYS);
            }
        }
        catch (ArithmeticException arithmeticException) {
            return plainDate2 != null && plainDate3.isSimultaneous((CalendarDate)plainDate2);
        }
        if (plainDate2 == null) {
            return plainDate.isSimultaneous((CalendarDate)plainDate4);
        }
        if (plainDate4 == null) {
            return plainDate3.isSimultaneous((CalendarDate)plainDate2);
        }
        return plainDate3.isSimultaneous((CalendarDate)plainDate2) ^ plainDate.isSimultaneous((CalendarDate)plainDate4);
    }

    @Override
    public boolean intersects(ChronoInterval<PlainDate> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        return !this.isBefore(chronoInterval) && !this.isAfter(chronoInterval);
    }

    public boolean isSimultaneous(T t) {
        return this.compareTo(t) == 0;
    }

    public DateInterval toFlexInterval() {
        return new DateInterval(this.getStart(), this.getEnd());
    }

    public <V> ValueInterval<PlainDate, T, V> withValue(V v) {
        return new ValueInterval((ChronoInterval)this.getContext(), v);
    }

    static void formatYear(StringBuilder stringBuilder, int n) {
        int n2 = n;
        if (n2 < 0) {
            stringBuilder.append('-');
            n2 = MathUtils.safeNegate((int)n);
        }
        if (n2 >= 10000) {
            if (n > 0) {
                stringBuilder.append('+');
            }
        } else if (n2 < 1000) {
            stringBuilder.append('0');
            if (n2 < 100) {
                stringBuilder.append('0');
                if (n2 < 10) {
                    stringBuilder.append('0');
                }
            }
        }
        stringBuilder.append(n2);
    }
}

