/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.List;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.Temporal;
import net.time4j.range.Boundary;
import net.time4j.range.ClockInterval;
import net.time4j.range.ClockWindows;
import net.time4j.range.DateInterval;
import net.time4j.range.DateWindows;
import net.time4j.range.IntervalCollection;
import net.time4j.range.IntervalEdge;
import net.time4j.range.MomentInterval;
import net.time4j.range.MomentWindows;
import net.time4j.range.TimestampInterval;
import net.time4j.range.TimestampWindows;

final class SPX
implements Externalizable {
    static final int DATE_TYPE = 50;
    static final int TIME_TYPE = 51;
    static final int TIMESTAMP_TYPE = 52;
    static final int MOMENT_TYPE = 53;
    static final int BOUNDARY_TYPE = 57;
    static final int DATE_WINDOW_ID = 60;
    static final int CLOCK_WINDOW_ID = 61;
    static final int TIMESTAMP_WINDOW_ID = 62;
    static final int MOMENT_WINDOW_ID = 63;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 50: {
                this.writeDateInterval(objectOutput);
                break;
            }
            case 51: {
                this.writeClockInterval(objectOutput);
                break;
            }
            case 52: {
                this.writeTimestampInterval(objectOutput);
                break;
            }
            case 53: {
                this.writeMomentInterval(objectOutput);
                break;
            }
            case 57: {
                this.writeBoundary(objectOutput);
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                int n = this.type << 2;
                objectOutput.writeByte(n);
                IntervalCollection intervalCollection = (IntervalCollection)IntervalCollection.class.cast(this.obj);
                objectOutput.writeObject(intervalCollection.getIntervals());
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by >> 2) {
            case 50: {
                this.obj = this.readDateInterval(objectInput);
                break;
            }
            case 51: {
                this.obj = this.readClockInterval(objectInput);
                break;
            }
            case 52: {
                this.obj = this.readTimestampInterval(objectInput);
                break;
            }
            case 53: {
                this.obj = this.readMomentInterval(objectInput);
                break;
            }
            case 57: {
                this.readBoundary(objectInput, by);
                break;
            }
            case 60: {
                this.obj = this.readDateWindow(objectInput);
                break;
            }
            case 61: {
                this.obj = this.readClockWindow(objectInput);
                break;
            }
            case 62: {
                this.obj = this.readTimestampWindow(objectInput);
                break;
            }
            case 63: {
                this.obj = this.readMomentWindow(objectInput);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeDateInterval(ObjectOutput objectOutput) throws IOException {
        DateInterval dateInterval = (DateInterval)this.obj;
        objectOutput.writeByte(200);
        objectOutput.writeObject(dateInterval.getStart());
        objectOutput.writeObject(dateInterval.getEnd());
    }

    private Object readDateInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        Object object2 = objectInput.readObject();
        Boundary<PlainDate> boundary = SPX.getBoundary(object, PlainDate.class, false);
        Boundary<PlainDate> boundary2 = SPX.getBoundary(object2, PlainDate.class, true);
        if (boundary != null && boundary2 != null) {
            return new DateInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private void writeClockInterval(ObjectOutput objectOutput) throws IOException {
        ClockInterval clockInterval = (ClockInterval)this.obj;
        objectOutput.writeByte(204);
        objectOutput.writeObject(clockInterval.getStart());
        objectOutput.writeObject(clockInterval.getEnd());
    }

    private Object readClockInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        Object object2 = objectInput.readObject();
        Boundary<PlainTime> boundary = SPX.getBoundary(object, PlainTime.class, false);
        Boundary<PlainTime> boundary2 = SPX.getBoundary(object2, PlainTime.class, true);
        if (boundary != null && boundary2 != null) {
            return new ClockInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private void writeTimestampInterval(ObjectOutput objectOutput) throws IOException {
        TimestampInterval timestampInterval = (TimestampInterval)this.obj;
        objectOutput.writeByte(208);
        objectOutput.writeObject(timestampInterval.getStart());
        objectOutput.writeObject(timestampInterval.getEnd());
    }

    private Object readTimestampInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        Object object2 = objectInput.readObject();
        Boundary<PlainTimestamp> boundary = SPX.getBoundary(object, PlainTimestamp.class, false);
        Boundary<PlainTimestamp> boundary2 = SPX.getBoundary(object2, PlainTimestamp.class, true);
        if (boundary != null && boundary2 != null) {
            return new TimestampInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private void writeMomentInterval(ObjectOutput objectOutput) throws IOException {
        MomentInterval momentInterval = (MomentInterval)this.obj;
        objectOutput.writeByte(212);
        objectOutput.writeObject(momentInterval.getStart());
        objectOutput.writeObject(momentInterval.getEnd());
    }

    private Object readMomentInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        Object object2 = objectInput.readObject();
        Boundary<Moment> boundary = SPX.getBoundary(object, Moment.class, false);
        Boundary<Moment> boundary2 = SPX.getBoundary(object2, Moment.class, true);
        if (boundary != null && boundary2 != null) {
            return new MomentInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private Object readDateWindow(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        List list = (List)SPX.cast(objectInput.readObject());
        return DateWindows.EMPTY.plus(list);
    }

    private Object readClockWindow(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        List list = (List)SPX.cast(objectInput.readObject());
        return ClockWindows.EMPTY.plus(list);
    }

    private Object readTimestampWindow(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        List list = (List)SPX.cast(objectInput.readObject());
        return TimestampWindows.EMPTY.plus(list);
    }

    private Object readMomentWindow(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        List list = (List)SPX.cast(objectInput.readObject());
        return MomentWindows.EMPTY.plus(list);
    }

    private void writeBoundary(ObjectOutput objectOutput) throws IOException {
        Boundary boundary = (Boundary)this.obj;
        int n = 228;
        if (boundary.equals(Boundary.infinitePast())) {
            objectOutput.writeByte(n |= 1);
        } else if (boundary.equals(Boundary.infiniteFuture())) {
            objectOutput.writeByte(n |= 2);
        } else {
            objectOutput.writeByte(n);
            objectOutput.writeByte(boundary.isOpen() ? 1 : 0);
            objectOutput.writeObject(boundary.getTemporal());
        }
    }

    private Object readBoundary(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        IntervalEdge intervalEdge;
        int n = by & 1;
        if (n == 1) {
            return Boundary.infinitePast();
        }
        int n2 = by & 2;
        if (n2 == 1) {
            return Boundary.infiniteFuture();
        }
        byte by2 = objectInput.readByte();
        switch (by2) {
            case 0: {
                intervalEdge = IntervalEdge.CLOSED;
                break;
            }
            case 1: {
                intervalEdge = IntervalEdge.OPEN;
                break;
            }
            default: {
                throw new StreamCorruptedException("Invalid edge state.");
            }
        }
        Object object = objectInput.readObject();
        return Boundary.of(intervalEdge, (Temporal)Temporal.class.cast(object));
    }

    private static <T extends Temporal<? super T>> Boundary<T> getBoundary(Object object, Class<T> clazz, boolean bl) {
        Boundary boundary = null;
        if (object instanceof Boundary) {
            Boundary boundary2 = (Boundary)SPX.cast(object);
            if (boundary2.isInfinite()) {
                Boundary boundary3 = bl ? Boundary.infiniteFuture() : Boundary.infinitePast();
                if (boundary3.equals(object)) {
                    boundary = boundary3;
                }
            } else if (clazz.isInstance(boundary2.getTemporal())) {
                boundary = (Boundary)SPX.cast(boundary2);
            }
        }
        return boundary;
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

