/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoOperator;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum Weekday implements ChronoCondition<GregorianDate>,
ChronoOperator<PlainDate>
{
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;

    private static final Weekday[] ENUMS;

    public int getValue() {
        return this.ordinal() + 1;
    }

    public int getValue(Weekmodel weekmodel) {
        int n = weekmodel.getFirstDayOfWeek().ordinal();
        return (7 + this.ordinal() - n) % 7 + 1;
    }

    public static Weekday[] values(Weekmodel weekmodel) {
        Weekday[] weekdayArray = new Weekday[7];
        Weekday weekday = weekmodel.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            weekdayArray[i] = weekday;
            weekday = weekday.next();
        }
        return weekdayArray;
    }

    public static Weekday valueOf(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[n - 1];
    }

    public static Weekday valueOf(int n, Weekmodel weekmodel) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Weekday out of range: " + n);
        }
        int n2 = weekmodel.getFirstDayOfWeek().ordinal();
        return ENUMS[(n - 1 + n2) % 7];
    }

    public static Weekday valueOf(int n, Month month, int n2) {
        return Weekday.valueOf(GregorianMath.getDayOfWeek(n, month.getValue(), n2));
    }

    public Weekday next() {
        return this.roll(1);
    }

    public Weekday previous() {
        return this.roll(-1);
    }

    public Weekday roll(int n) {
        return Weekday.valueOf((this.ordinal() + (n % 7 + 7)) % 7 + 1);
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return CalendarText.getIsoInstance(locale).getWeekdays(textWidth, outputContext).print(this);
    }

    public static Weekday parse(CharSequence charSequence, Locale locale, TextWidth textWidth, OutputContext outputContext) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Weekday weekday = CalendarText.getIsoInstance(locale).getWeekdays(textWidth, outputContext).parse(charSequence, parsePosition, Weekday.class);
        if (weekday == null) {
            throw new ParseException("Cannot parse: " + charSequence, parsePosition.getErrorIndex());
        }
        return weekday;
    }

    @Override
    public boolean test(GregorianDate gregorianDate) {
        int n;
        int n2;
        int n3 = gregorianDate.getYear();
        return GregorianMath.getDayOfWeek(n3, n2 = gregorianDate.getMonth(), n = gregorianDate.getDayOfMonth()) == this.getValue();
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        return (PlainDate)plainDate.with(PlainDate.DAY_OF_WEEK, this);
    }

    static {
        ENUMS = Weekday.values();
    }
}

