/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.misc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.thisptr.jackson.jq.internal.misc.JsonQueryJacksonModule;
import net.thisptr.jackson.jq.internal.misc.Lists;

public class JsonNodeUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)JsonQueryJacksonModule.getInstance());

    private JsonNodeUtils() {
    }

    public static boolean asBoolean(JsonNode n) {
        if (n == null || n.isNull() || n.isMissingNode()) {
            return false;
        }
        if (n.isBoolean()) {
            return n.asBoolean();
        }
        return true;
    }

    public static JsonNode asNumericNode(long value) {
        if ((long)((int)value) == value) {
            return new IntNode((int)value);
        }
        return new LongNode(value);
    }

    public static JsonNode asNumericNode(double value) {
        if ((double)((int)value) == value) {
            return new IntNode((int)value);
        }
        if ((double)((long)value) == value) {
            return new LongNode((long)value);
        }
        return new DoubleNode(value);
    }

    public static ArrayNode asArrayNode(ObjectMapper mapper, List<JsonNode> values) {
        ArrayNode result = mapper.createArrayNode();
        result.addAll(values);
        return result;
    }

    public static List<JsonNode> asArrayList(ArrayNode in) {
        return Lists.newArrayList(in);
    }

    public static String typeOf(JsonNode in) {
        if (in == null) {
            return "null";
        }
        switch (in.getNodeType()) {
            case ARRAY: {
                return "array";
            }
            case BINARY: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case MISSING: {
                return "null";
            }
            case NULL: {
                return "null";
            }
            case NUMBER: {
                return "number";
            }
            case OBJECT: {
                return "object";
            }
            case STRING: {
                return "string";
            }
        }
        throw new IllegalArgumentException("Unknown JsonNodeType: " + in.getNodeType());
    }

    public static JsonNode nullToNullNode(JsonNode value) {
        if (value == null) {
            return NullNode.getInstance();
        }
        return value;
    }

    private static JsonNode filterInternal(JsonNode in, Predicate<JsonNode> pred) {
        if (in.isObject()) {
            ObjectNode out = MAPPER.createObjectNode();
            Iterator iter = in.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (!pred.test((JsonNode)entry.getValue())) continue;
                out.set((String)entry.getKey(), JsonNodeUtils.filterInternal((JsonNode)entry.getValue(), pred));
            }
            return out;
        }
        if (in.isArray()) {
            ArrayNode out = MAPPER.createArrayNode();
            for (JsonNode val : in) {
                if (!pred.test(val)) continue;
                out.add(JsonNodeUtils.filterInternal(val, pred));
            }
            return out;
        }
        return in;
    }

    public static JsonNode filter(JsonNode in, Predicate<JsonNode> pred) {
        if (!pred.test(in)) {
            return NullNode.getInstance();
        }
        return JsonNodeUtils.filterInternal(in, pred);
    }

    public static String toString(JsonNode node) {
        try {
            return MAPPER.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

