/*
 * Decompiled with CFR 0.152.
 */
package net.thanatosx.previewer;

import android.animation.FloatEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;

public class ImagePreviewView
extends ImageView {
    private ScaleGestureDetector mScaleDetector;
    private GestureDetector mFlatDetector;
    private float scale = 1.0f;
    private static final float mMaxScale = 4.0f;
    private static final float mMinScale = 0.4f;
    private float translateLeft = 0.0f;
    private float translateTop = 0.0f;
    private int mBoundWidth = 0;
    private int mBoundHeight = 0;
    private boolean isAutoScale = false;
    private ValueAnimator resetScaleAnimator;
    private ValueAnimator resetXAnimator;
    private ValueAnimator resetYAnimator;
    private ValueAnimator.AnimatorUpdateListener onScaleAnimationUpdate;
    private ValueAnimator.AnimatorUpdateListener onTranslateXAnimationUpdate;
    private ValueAnimator.AnimatorUpdateListener onTranslateYAnimationUpdate;
    private FloatEvaluator mFloatEvaluator = new FloatEvaluator();
    private AccelerateInterpolator mAccInterpolator = new AccelerateInterpolator();
    private DecelerateInterpolator mDecInterpolator = new DecelerateInterpolator();
    private OnReachBorderListener onReachBorderListener;

    public void setOnReachBorderListener(OnReachBorderListener l) {
        this.onReachBorderListener = l;
    }

    public ImagePreviewView(Context context) {
        this(context, null);
    }

    public ImagePreviewView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImagePreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mFlatDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new FlatGestureListener());
    }

    public ValueAnimator.AnimatorUpdateListener getOnScaleAnimationUpdate() {
        if (this.onScaleAnimationUpdate != null) {
            return this.onScaleAnimationUpdate;
        }
        this.onScaleAnimationUpdate = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImagePreviewView.this.scale = ((Float)animation.getAnimatedValue()).floatValue();
                ImagePreviewView.this.invalidate();
            }
        };
        return this.onScaleAnimationUpdate;
    }

    public ValueAnimator.AnimatorUpdateListener getOnTranslateXAnimationUpdate() {
        if (this.onTranslateXAnimationUpdate != null) {
            return this.onTranslateXAnimationUpdate;
        }
        this.onTranslateXAnimationUpdate = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImagePreviewView.this.translateLeft = ((Float)animation.getAnimatedValue()).floatValue();
                ImagePreviewView.this.invalidate();
            }
        };
        return this.onTranslateXAnimationUpdate;
    }

    public ValueAnimator.AnimatorUpdateListener getOnTranslateYAnimationUpdate() {
        if (this.onTranslateYAnimationUpdate != null) {
            return this.onTranslateYAnimationUpdate;
        }
        this.onTranslateYAnimationUpdate = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImagePreviewView.this.translateTop = ((Float)animation.getAnimatedValue()).floatValue();
                ImagePreviewView.this.invalidate();
            }
        };
        return this.onTranslateYAnimationUpdate;
    }

    private ValueAnimator getResetScaleAnimator() {
        if (this.resetScaleAnimator != null) {
            this.resetScaleAnimator.removeAllUpdateListeners();
        } else {
            this.resetScaleAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        }
        this.resetScaleAnimator.setDuration(150L);
        this.resetScaleAnimator.setInterpolator((TimeInterpolator)this.mAccInterpolator);
        this.resetScaleAnimator.setEvaluator((TypeEvaluator)this.mFloatEvaluator);
        return this.resetScaleAnimator;
    }

    private ValueAnimator getResetXAnimator() {
        if (this.resetXAnimator != null) {
            this.resetXAnimator.removeAllUpdateListeners();
        } else {
            this.resetXAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        }
        this.resetXAnimator.setDuration(150L);
        this.resetXAnimator.setInterpolator((TimeInterpolator)this.mAccInterpolator);
        this.resetXAnimator.setEvaluator((TypeEvaluator)this.mFloatEvaluator);
        return this.resetXAnimator;
    }

    private ValueAnimator getResetYAnimator() {
        if (this.resetYAnimator != null) {
            this.resetYAnimator.removeAllUpdateListeners();
        } else {
            this.resetYAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        }
        this.resetYAnimator.setDuration(150L);
        this.resetYAnimator.setInterpolator((TimeInterpolator)this.mAccInterpolator);
        this.resetYAnimator.setEvaluator((TypeEvaluator)this.mFloatEvaluator);
        return this.resetYAnimator;
    }

    private void cancelAnimation() {
        if (this.resetScaleAnimator != null && this.resetScaleAnimator.isRunning()) {
            this.resetScaleAnimator.cancel();
        }
        if (this.resetXAnimator != null && this.resetXAnimator.isRunning()) {
            this.resetXAnimator.cancel();
        }
        if (this.resetYAnimator != null && this.resetYAnimator.isRunning()) {
            this.resetYAnimator.cancel();
        }
    }

    private float getDiffX() {
        float mScaledWidth = (float)this.mBoundWidth * this.scale;
        return this.translateLeft >= 0.0f ? this.translateLeft : ((float)this.getWidth() - this.translateLeft - mScaledWidth > 0.0f ? -((float)this.getWidth() - this.translateLeft - mScaledWidth) : 0.0f);
    }

    private float getDiffY() {
        float mScaledHeight = (float)this.mBoundHeight * this.scale;
        return this.translateTop >= 0.0f ? this.translateTop : ((float)this.getHeight() - this.translateTop - mScaledHeight > 0.0f ? -((float)this.getHeight() - this.translateTop - mScaledHeight) : 0.0f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.cancelAnimation();
        }
        this.mFlatDetector.onTouchEvent(event);
        this.mScaleDetector.onTouchEvent(event);
        if (action == 1 || action == 3) {
            if (this.isAutoScale) {
                this.isAutoScale = false;
            } else {
                ValueAnimator animator;
                if (this.scale < 1.0f) {
                    ValueAnimator animator2 = this.getResetScaleAnimator();
                    animator2.setFloatValues(new float[]{this.scale, 1.0f});
                    animator2.addUpdateListener(this.getOnScaleAnimationUpdate());
                    animator2.start();
                }
                float mScaledWidth = (float)this.mBoundWidth * this.scale;
                float mScaledHeight = (float)this.mBoundHeight * this.scale;
                float mDiffX = this.getDiffX();
                float mDiffY = this.getDiffY();
                if (mScaledWidth >= (float)this.getWidth() && mDiffX != 0.0f) {
                    animator = this.getResetXAnimator();
                    animator.setFloatValues(new float[]{this.translateLeft, this.translateLeft - mDiffX});
                    animator.addUpdateListener(this.getOnTranslateXAnimationUpdate());
                    animator.start();
                }
                if (mScaledHeight >= (float)this.getHeight() && mDiffY != 0.0f) {
                    animator = this.getResetYAnimator();
                    animator.setFloatValues(new float[]{this.translateTop, this.translateTop - mDiffY});
                    animator.addUpdateListener(this.getOnTranslateYAnimationUpdate());
                    animator.start();
                }
                if (mScaledWidth < (float)this.getWidth() && mScaledHeight >= (float)this.getHeight() && mDiffX != 0.0f) {
                    animator = this.getResetXAnimator();
                    animator.setFloatValues(new float[]{this.translateLeft, ((float)this.getWidth() - mScaledWidth) / 2.0f});
                    animator.addUpdateListener(this.getOnTranslateXAnimationUpdate());
                    animator.start();
                }
                if (mScaledHeight < (float)this.getHeight() && mScaledWidth >= (float)this.getWidth() && mDiffY != 0.0f) {
                    animator = this.getResetYAnimator();
                    animator.setFloatValues(new float[]{this.translateTop, ((float)this.getHeight() - mScaledHeight) / 2.0f});
                    animator.addUpdateListener(this.getOnTranslateYAnimationUpdate());
                    animator.start();
                }
                if (mScaledWidth < (float)this.getWidth() && mScaledHeight < (float)this.getHeight()) {
                    this.resetDefaultState();
                }
            }
        }
        return true;
    }

    private void resetDefaultState() {
        float midWidth = (this.getWidth() - this.mBoundWidth) / 2;
        float midHeight = (this.getHeight() - this.mBoundHeight) / 2;
        if (midWidth != this.translateLeft) {
            ValueAnimator mTranslateXAnimator = this.getResetXAnimator();
            mTranslateXAnimator.setFloatValues(new float[]{this.translateLeft, midWidth});
            mTranslateXAnimator.addUpdateListener(this.getOnTranslateXAnimationUpdate());
            mTranslateXAnimator.start();
        }
        if (midHeight != this.translateTop) {
            ValueAnimator mTranslateYAnimator = this.getResetYAnimator();
            mTranslateYAnimator.setFloatValues(new float[]{this.translateTop, midHeight});
            mTranslateYAnimator.addUpdateListener(this.getOnTranslateYAnimationUpdate());
            mTranslateYAnimator.start();
        }
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        boolean change = super.setFrame(l, t, r, b);
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return false;
        }
        if (this.mBoundWidth != 0 && this.mBoundHeight != 0 && this.scale != 1.0f) {
            return false;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this.mBoundWidth = drawable.getBounds().width();
        this.mBoundHeight = drawable.getBounds().height();
        float scale = Math.max((float)this.mBoundWidth / (float)width, (float)this.mBoundHeight / (float)height);
        this.mBoundHeight = (int)((float)this.mBoundHeight / scale);
        this.mBoundWidth = (int)((float)this.mBoundWidth / scale);
        drawable.setBounds(0, 0, this.mBoundWidth, this.mBoundHeight);
        this.translateLeft = (width - this.mBoundWidth) / 2;
        this.translateTop = (height - this.mBoundHeight) / 2;
        return change;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.translateLeft = (w - this.mBoundWidth) / 2;
        this.translateTop = (h - this.mBoundHeight) / 2;
    }

    protected void onDraw(Canvas canvas) {
        Drawable mDrawable = this.getDrawable();
        if (mDrawable == null) {
            return;
        }
        int mDrawableWidth = mDrawable.getIntrinsicWidth();
        int mDrawableHeight = mDrawable.getIntrinsicHeight();
        if (mDrawableWidth == 0 || mDrawableHeight == 0) {
            return;
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(this.translateLeft, this.translateTop);
        canvas.scale(this.scale, this.scale);
        mDrawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private float getExplicitTranslateLeft(float l) {
        float mScaledWidth = (float)this.mBoundWidth * this.scale;
        if (l > 0.0f) {
            l = 0.0f;
        }
        if (-l + (float)this.getWidth() > mScaledWidth) {
            l = (float)this.getWidth() - mScaledWidth;
        }
        return l;
    }

    private float getExplicitTranslateTop(float t) {
        float mScaledHeight = (float)this.mBoundHeight * this.scale;
        if (t > 0.0f) {
            t = 0.0f;
        }
        if (-t + (float)this.getHeight() > mScaledHeight) {
            t = (float)this.getHeight() - mScaledHeight;
        }
        return t;
    }

    private class FlatGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private FlatGestureListener() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            float mScaledWidth = (float)ImagePreviewView.this.mBoundWidth * ImagePreviewView.this.scale;
            float mScaledHeight = (float)ImagePreviewView.this.mBoundHeight * ImagePreviewView.this.scale;
            if (mScaledHeight > (float)ImagePreviewView.this.getHeight()) {
                ImagePreviewView.this.translateTop = (float)((double)ImagePreviewView.this.translateTop - (double)distanceY * 1.5);
                ImagePreviewView.this.translateTop = ImagePreviewView.this.getExplicitTranslateTop(ImagePreviewView.this.translateTop);
            }
            boolean isReachBorder = false;
            if (mScaledWidth > (float)ImagePreviewView.this.getWidth()) {
                ImagePreviewView.this.translateLeft = (float)((double)ImagePreviewView.this.translateLeft - (double)distanceX * 1.5);
                float t = ImagePreviewView.this.getExplicitTranslateLeft(ImagePreviewView.this.translateLeft);
                if (t != ImagePreviewView.this.translateLeft) {
                    isReachBorder = true;
                }
                ImagePreviewView.this.translateLeft = t;
            } else {
                isReachBorder = true;
            }
            if (ImagePreviewView.this.onReachBorderListener != null) {
                ImagePreviewView.this.onReachBorderListener.onReachBorder(isReachBorder);
            }
            ImagePreviewView.this.invalidate();
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if ((float)ImagePreviewView.this.mBoundWidth * ImagePreviewView.this.scale > (float)ImagePreviewView.this.getWidth()) {
                float sx = ImagePreviewView.this.translateLeft + 0.5f * velocityX * 0.5f * 0.5f;
                sx = ImagePreviewView.this.getExplicitTranslateLeft(sx);
                ValueAnimator mResetXAnimator = ImagePreviewView.this.getResetXAnimator();
                mResetXAnimator.setDuration(300L);
                mResetXAnimator.setInterpolator((TimeInterpolator)ImagePreviewView.this.mDecInterpolator);
                mResetXAnimator.setFloatValues(new float[]{ImagePreviewView.this.translateLeft, sx});
                mResetXAnimator.addUpdateListener(ImagePreviewView.this.getOnTranslateXAnimationUpdate());
                mResetXAnimator.start();
            }
            if ((float)ImagePreviewView.this.mBoundHeight * ImagePreviewView.this.scale > (float)ImagePreviewView.this.getHeight()) {
                float sy = ImagePreviewView.this.translateTop + 0.5f * velocityY * 0.5f * 0.5f;
                sy = ImagePreviewView.this.getExplicitTranslateTop(sy);
                ValueAnimator mResetYAnimator = ImagePreviewView.this.getResetYAnimator();
                mResetYAnimator.setDuration(300L);
                mResetYAnimator.setInterpolator((TimeInterpolator)ImagePreviewView.this.mDecInterpolator);
                mResetYAnimator.setFloatValues(new float[]{ImagePreviewView.this.translateTop, sy});
                mResetYAnimator.addUpdateListener(ImagePreviewView.this.getOnTranslateYAnimationUpdate());
                mResetYAnimator.start();
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            ImagePreviewView.this.isAutoScale = true;
            ValueAnimator mResetScaleAnimator = ImagePreviewView.this.getResetScaleAnimator();
            if (ImagePreviewView.this.scale == 1.0f) {
                mResetScaleAnimator.setFloatValues(new float[]{1.0f, 2.0f});
                ValueAnimator mResetXAnimator = ImagePreviewView.this.getResetXAnimator();
                ValueAnimator mResetYAnimator = ImagePreviewView.this.getResetYAnimator();
                mResetXAnimator.setFloatValues(new float[]{ImagePreviewView.this.translateLeft, ((float)ImagePreviewView.this.getWidth() - (float)ImagePreviewView.this.mBoundWidth * 2.0f) / 2.0f});
                mResetYAnimator.setFloatValues(new float[]{ImagePreviewView.this.translateTop, ((float)ImagePreviewView.this.getHeight() - (float)ImagePreviewView.this.mBoundHeight * 2.0f) / 2.0f});
                mResetXAnimator.addUpdateListener(ImagePreviewView.this.getOnTranslateXAnimationUpdate());
                mResetYAnimator.addUpdateListener(ImagePreviewView.this.getOnTranslateYAnimationUpdate());
                mResetXAnimator.start();
                mResetYAnimator.start();
            } else {
                mResetScaleAnimator.setFloatValues(new float[]{ImagePreviewView.this.scale, 1.0f});
                ImagePreviewView.this.resetDefaultState();
            }
            mResetScaleAnimator.addUpdateListener(ImagePreviewView.this.getOnScaleAnimationUpdate());
            mResetScaleAnimator.start();
            return true;
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float mOldScaledWidth = (float)ImagePreviewView.this.mBoundWidth * ImagePreviewView.this.scale;
            float mOldScaledHeight = (float)ImagePreviewView.this.mBoundHeight * ImagePreviewView.this.scale;
            if (mOldScaledWidth > (float)ImagePreviewView.this.getWidth() && ImagePreviewView.this.getDiffX() != 0.0f || mOldScaledHeight > (float)ImagePreviewView.this.getHeight() && ImagePreviewView.this.getDiffY() != 0.0f) {
                return false;
            }
            float factor = detector.getScaleFactor();
            float value = ImagePreviewView.this.scale;
            if ((value += (factor - 1.0f) * 2.0f) == ImagePreviewView.this.scale) {
                return true;
            }
            if (value <= 0.4f) {
                return false;
            }
            if (value > 4.0f) {
                return false;
            }
            ImagePreviewView.this.scale = value;
            float mScaledWidth = (float)ImagePreviewView.this.mBoundWidth * ImagePreviewView.this.scale;
            float mScaledHeight = (float)ImagePreviewView.this.mBoundHeight * ImagePreviewView.this.scale;
            ImagePreviewView.this.translateLeft = (float)ImagePreviewView.this.getWidth() / 2.0f - ((float)ImagePreviewView.this.getWidth() / 2.0f - ImagePreviewView.this.translateLeft) * mScaledWidth / mOldScaledWidth;
            ImagePreviewView.this.translateTop = (float)ImagePreviewView.this.getHeight() / 2.0f - ((float)ImagePreviewView.this.getHeight() / 2.0f - ImagePreviewView.this.translateTop) * mScaledHeight / mOldScaledHeight;
            float diffX = ImagePreviewView.this.getDiffX();
            float diffY = ImagePreviewView.this.getDiffY();
            if (diffX > 0.0f && mScaledWidth > (float)ImagePreviewView.this.getWidth()) {
                ImagePreviewView.this.translateLeft = 0.0f;
            }
            if (diffX < 0.0f && mScaledWidth > (float)ImagePreviewView.this.getWidth()) {
                ImagePreviewView.this.translateLeft = (float)ImagePreviewView.this.getWidth() - mScaledWidth;
            }
            if (diffY > 0.0f && mScaledHeight > (float)ImagePreviewView.this.getHeight()) {
                ImagePreviewView.this.translateTop = 0.0f;
            }
            if (diffY < 0.0f && mScaledHeight > (float)ImagePreviewView.this.getHeight()) {
                ImagePreviewView.this.translateTop = (float)ImagePreviewView.this.getHeight() - mScaledHeight;
            }
            ImagePreviewView.this.invalidate();
            return true;
        }
    }

    public static interface OnReachBorderListener {
        public void onReachBorder(boolean var1);
    }
}

